package com.gaea.iesms.bm.archive.model.request.ceContainer;

import com.fasterxml.jackson.databind.JsonNode;
import com.gaea.iesms.core.feign.request.archive.CeResourceRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

/**
 * 用能容器基础请求类
 *
 * @author JIE
 * @version 1.0
 * @date 2024/1/31 11:46
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel("用能容器基础请求类")
public class CeContainerRequest extends CeResourceRequest {

    /**
     * 用能资源（容器）分类编号 见用能资源分类表
     */
    @NotNull
    @ApiModelProperty(value = "用能资源（容器）分类编号")
    private String ceResSortNo;

    /**
     * 用能资源分类id
     */
    @NotNull
    @ApiModelProperty(value = "用能资源分类id")
    private String ceResSortNoId;

    /**
     * 上级用能资源标识
     */
    @ApiModelProperty(value = "上级用能资源标识")
    private Long parentCeResId;

    /**
     * 用能容器属性集
     */
    @NotNull
    @ApiModelProperty(value = "用能容器属性集")
    private JsonNode ceResourceProps;

    private static final long serialVersionUID = 1L;
}
