package com.gaea.iesms.bm.archive.model.request.ceDeivce;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.Date;

/**
 * @author JIE
 * @version 1.0
 * @description: 采集器设备信息请求类
 * @date 2023/3/24 15:47
 */
@Data
@ApiModel(value = "GmDevCollectorRequest对象", description = "采集器设备信息请求类")
public class GmDevCollectorRequest {

    /**
     * 采集器标识 SnowflakeId
     */
    @ApiModelProperty(value = "采集器标识 SnowflakeId")
    private Long id;

    /**
     * 系统单位编号
     */
    @ApiModelProperty(value = "系统单位编号")
    private String orgNo;

    /**
     * 采集器编号
     */
    @ApiModelProperty(value = "采集器编号")
    private String devCollectorNo;

    /**
     * 采集器名称
     */
    @ApiModelProperty(value = "采集器名称")
    private String devCollectorName;

    /**
     * 采集器状态
     */
    @ApiModelProperty(value = "采集器状态 1 - 待装；2 - 待投；3 - 投运；4 - 故障；5 - 暂停；6 - 停运；7 - 拆除；", allowableValues = "1,2,3,4,5,6,7")
    private Integer devCollectorStatus;

    /**
     * 采集器通讯地址
     */
    @ApiModelProperty(value = "采集器通讯地址")
    private String devCollectorCommAddr;

    /**
     * 生产厂家
     */
    @ApiModelProperty(value = "生产厂家")
    private String mfrCode;

    /**
     * 生产批次
     */
    @ApiModelProperty(value = "生产批次")
    private String prodBatch;

    /**
     * 生产日期
     */
    @ApiModelProperty(value = "生产日期")
    private LocalDate prodDate;

    /**
     * 设备型号
     */
    @ApiModelProperty(value = "设备型号")
    private String modelCode;

    /**
     * 装接人
     */
    @ApiModelProperty(value = "装接人")
    private String installer;

    /**
     * 装接时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "装接时间")
    private Date installTime;

    /**
     * 装接备注
     */
    @ApiModelProperty(value = "装接备注")
    private String installRemark;

    /**
     * 投运人
     */
    @ApiModelProperty(value = "投运人")
    private String gotorunner;

    /**
     * 投运时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "投运时间")
    private Date gotorunTime;

    /**
     * 投运备注
     */
    @ApiModelProperty(value = "投运备注")
    private String gotorunRemark;

    /**
     * 停运人
     */
    @ApiModelProperty(value = "停运人")
    private String stoprunner;

    /**
     * 停运时间
     */
    @ApiModelProperty(value = "停运时间")
    private Date stoprunTime;

    /**
     * 停运备注
     */
    @ApiModelProperty(value = "停运备注")
    private String stoprunRemark;

    /**
     * 拆除人
     */
    @ApiModelProperty(value = "拆除人")
    private String dismantler;

    /**
     * 拆除日期
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "拆除日期")
    private Date dismantleTime;

    /**
     * 拆除备注
     */
    @ApiModelProperty(value = "拆除备注")
    private String dismantleRemark;

    /**
     * 接入中继设备标识 采集器投运后，后台自动注册采集平台接入中继设备，注册成功后回填入接入中继设备标识；
     */
    @ApiModelProperty(value = "接入中继设备标识 采集器投运后，后台自动注册采集平台接入中继设备，注册成功后回填入接入中继设备标识；")
    private Long accessTrunkingId;

}
