package com.gaea.iesms.bm.archive.model.request.ceResource;

import com.gaea.iesms.core.model.enums.archive.CeResClassEnum;
import com.gaea.iesms.core.model.enums.archive.CeResTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author Administrator
 * @version 1.0
 * @description: 查询用能资源树请求类
 * @date 2023/4/4 17:15
 */
@Data
@ApiModel("查询用能资源树请求类")
public class EnergyResourceTreeRequest implements Serializable {

    @NotNull(message = "树id不能为空")
    @ApiModelProperty("树id,用于要查询哪个树-+")
    private String treeId;

    /**
     * 上级id
     */
    @ApiModelProperty("上级id")
    private String superiorId;

    /**
     * 上级资源类别
     *
     * @see CeResClassEnum
     */
    @ApiModelProperty("上级资源类别 ：1、用户 2、区域 3、容器 4、 设备")
    private Integer superiorResourceType;

    /**
     * 上级用能资源分类编号
     */
    @ApiModelProperty("上级用能资源分类编号id")
    private String supperCeResSortNoId;

    /**
     * 资源类型
     *
     * @see CeResTypeEnum
     */
    @ApiModelProperty(value = "资源类型 source -> 源  net -> 网  eload -> 荷  store -> 储 charge -> 充")
    private String ceResType;

    private static final long serialVersionUID = 1L;
}
