package com.gaea.iesms.bm.archive.model.response.dto.ceResourceDetail;

import com.gaea.iesms.core.model.core.IesmsNormalEntity;
import lombok.Data;

/**
 * 用能资源树明细返回DTO类
 *
 * @author JIE
 */
@Data
public class CeResourceDetailDto extends IesmsNormalEntity {

    /**
     * 上级用能资源类别
     *
     * @see com.gaea.iesms.core.model.enums.archive.CeResClassEnum
     */
    private Integer supperCeResClass;

    /**
     * 上级用能资源分类编号
     */
    private String supperCeResSortNo;

    /**
     * 下级用能资源类别
     *
     * @see com.gaea.iesms.core.model.enums.archive.CeResClassEnum
     */
    private Integer lowerCeResClass;

    /**
     * 下级用能资源分类编号
     */
    private String lowerCeResSortNo;

    /**
     * 下级能源类型
     *
     * @see com.gaea.iesms.core.model.enums.archive.CeResTypeEnum
     */
    private String lowerCeResType;
}
