package com.gaea.iesms.bm.archive.model.response.vo.CePoint;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 用能点VO类，用于在控制层和前端交互的数据传输对象
 *
 * @author Administrator
 */
@Data
@ApiModel(value = "CePointVo", description = "用能点信息")
public class CePointVo {

    /**
     * 用能点标识
     */
    @ApiModelProperty(value = "用能点标识", example = "1")
    private Long id;

    /**
     * 系统单位编号
     */
    @ApiModelProperty(value = "系统单位编号", example = "001")
    private String orgNo;

    /**
     * 用能点编号
     */
    @ApiModelProperty(value = "用能点编号", example = "001001")
    private String cePointNo;

    /**
     * 用能客户标识
     */
    @ApiModelProperty(value = "用能客户标识", example = "1")
    private Long ceCustId;

    /**
     * 用能资源标识
     */
    @ApiModelProperty(value = "用能资源标识", example = "1")
    private Long ceResId;

    /**
     * 用能资源类别
     * 1 - 用能客户；
     * 2 - 用能区域；
     * 3 - 用能容器；
     * 4 - 用能设备；
     */
    @ApiModelProperty(value = "用能资源类别", example = "1")
    private Integer ceResClass;

    /**
     * 用能点名称
     */
    @ApiModelProperty(value = "用能点名称", example = "电表01")
    private String cePointName;

    /**
     * 用能点分类
     * 1 – 用电；
     * 2 – 用水；
     * 3 – 用气；
     * 4 – 用热；
     * 5 - 用汽；
     */
    @ApiModelProperty(value = "用能点分类", example = "1")
    private Integer cePointSort;

    /**
     * 是否结算
     */
    @ApiModelProperty(value = "是否结算", example = "0")
    private Integer isSettlement;

    /**
     * 用能点层级
     */
    @ApiModelProperty(value = "用能点层级", example = "1")
    private Integer cePointLevel;

    /**
     * 上级用能点标识
     */
    @ApiModelProperty(value = "上级用能点标识", example = "0")
    private Long parentId;

    /**
     * 量测点集合
     */
    @ApiModelProperty(value = "量测点集合", example = "[]")
    private List<Long> measPointIdList;

    /**
     * 量测计算公式
     */
    @ApiModelProperty(value = "量测计算公式", example = "电表读数")
    private String measCalcRule;

    /**
     * 用能点属性集
     */
    @ApiModelProperty(value = "用能点属性集", example = "{}")
    private String cePointProps;

    /**
     * 排序序号
     */
    @ApiModelProperty(value = "排序序号", example = "1")
    private Integer sortSn;

    /**
     * 是否有效
     */
    @ApiModelProperty(value = "是否有效", example = "true")
    private Boolean isValid;

    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    @ApiModelProperty(value = "创建人", example = "admin")
    private String creator;

    /**
     * 创建时间;为0表示为空
     */
    @ApiModelProperty(value = "创建时间", example = "1633213732000")
    private Long gmtCreate;

    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    @ApiModelProperty(value = "更新人", example = "admin")
    private String modifier;

    /**
     * 更新时间;为0表示为空
     */
    @ApiModelProperty(value = "更新时间", example = "1633213732000")
    private Long gmtModified;

    /**
     * 失效人;系统用户表用户编号字段（user_no）
     */
    @ApiModelProperty(value = "失效人", example = "admin")
    private String invalider;

    /**
     * 失效时间;为0表示为空
     */
    @ApiModelProperty(value = "失效时间", example = "1633213732000")
    private Long gmtInvalid;

    /**
     * 版本号;用于乐观锁
     */
    @ApiModelProperty(value = "版本号", example = "1")
    private Integer version;

}
