package com.gaea.iesms.bm.archive.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.gaea.iesms.bm.archive.model.request.ceDeivce.CeDeviceRequest;
import com.gaea.iesms.bm.archive.model.request.ceDeivce.UpdateCeDeviceRequest;
import com.gaea.iesms.bm.archive.model.response.vo.ceResource.IntervalVo;
import com.gaea.iesms.core.feign.request.archive.PagedDevicesRequest;
import com.gaea.iesms.core.feign.response.archive.CeDeviceVo;
import com.gaea.iesms.core.model.entity.archive.CeDevice;

import java.util.List;

/**
 * 针对表【ce_device(用能设备 用能资源子表)】的数据库操作Service
 *
 * @author JIE
 * @createDate 2023-02-20 09:44:39
 */
public interface CeDeviceService extends IService<CeDevice> {

    /**
     * 增加设备档案
     *
     * @param request 请求参数
     * @return 主键id
     * @author JIE
     * @date: 2023/11/10 10:49
     */
    String addCeDevice(CeDeviceRequest request);

    /**
     * 修改设备档案
     *
     * @param request 请求参数
     * @return true 成功 false 失败
     * @author JIE
     * @date: 2023/11/10 13:06
     */
    Boolean updateDeviceById(UpdateCeDeviceRequest request);

    /**
     * 查询设备档案
     *
     * @param id 设备档案id
     * @return: com.gaea.bm.ems.model.dto.ceDevice.CeDeviceDto
     * @author 阿杰 2416338031@qq.com
     * @date: 2023/11/19 20:03
     */
    CeDeviceVo getDeviceById(String id);

    /**
     * 分页查询设备档案
     *
     * @param: request
     * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.gaea.iesms.core.feign.response.archive.CeDeviceVo>
     * @author JIE
     * @date: 2024/4/1 16:46
     */
    IPage<CeDeviceVo> listPagedDevices(PagedDevicesRequest request);

    /**
     * 查询间隔
     *
     * @param keyWord 搜索关键词
     * @return List<IntervalVo>
     * @author JIE
     * @date: 2023/11/24 19:13
     */
    List<IntervalVo> searchIntervals(String keyWord);
}
