package com.gaea.iesms.bm.archive.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasterxml.jackson.databind.JsonNode;
import com.gaea.base.core.R;
import com.gaea.base.error.BizException;
import com.gaea.iesms.bm.archive.mapper.CeDeviceMapper;
import com.gaea.iesms.bm.archive.model.request.ceDeivce.CeDeviceRequest;
import com.gaea.iesms.bm.archive.model.request.ceDeivce.UpdateCeDeviceRequest;
import com.gaea.iesms.bm.archive.model.response.dto.ceDevice.CeDeviceDto;
import com.gaea.iesms.bm.archive.model.response.dto.ceDevice.IntervalsWithParentInfoDto;
import com.gaea.iesms.bm.archive.model.response.dto.ceResourceSort.CeResourceSortDto;
import com.gaea.iesms.bm.archive.model.response.vo.ceResource.IntervalVo;
import com.gaea.iesms.bm.archive.service.*;
import com.gaea.iesms.core.feign.request.archive.PagedDevicesRequest;
import com.gaea.iesms.core.feign.response.archive.CeDeviceVo;
import com.gaea.iesms.core.feign.service.RemoteIotService;
import com.gaea.iesms.core.model.entity.archive.*;
import com.gaea.iesms.core.model.entity.iot.GmDevMeter;
import com.gaea.iesms.core.model.enums.archive.CeResClassEnum;
import com.gaea.iesms.core.model.jsonobject.archive.CePointPropsJsonObject;
import com.gaea.spring.cloud.starter.util.AuthUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

import static com.gaea.iesms.core.model.entity.archive.factory.CeResourcePropsFactory.createResourceData;

/**
 * @author Administrator
 * @description 针对表【ce_device(用能设备 用能资源子表)】的数据库操作Service实现
 * @createDate 2023-02-20 09:44:39
 */
@Slf4j
@Service
public class CeDeviceServiceImpl extends ServiceImpl<CeDeviceMapper, CeDevice>
        implements CeDeviceService {

    @Resource
    private RemoteIotService remoteIotService;

    @Resource
    private CeDeviceMapper ceDeviceMapper;

    @Resource
    private CeResourceService ceResourceService;

    @Resource
    private CePartService cePartService;

    @Resource
    private CeContainerService ceContainerService;

    @Resource
    private CePointService cePointService;

    @Resource
    private CePointMeterService cePointMeterService;

    @Resource
    private CeResourceSortService ceResourceSortService;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public String addCeDevice(CeDeviceRequest ceDeviceRequest) {
        String orgNo = AuthUtils.getOrgNo();

        // 根据上级用能资源标识查询上级资源是什么类型
        Long parentCeResId = ceDeviceRequest.getParentCeResId();
        CeResource parCeResource = ceResourceService.getById(parentCeResId);
        // 判断上级用能资源类型
        Integer ceResClass = parCeResource.getCeResClass();

        // 1、新增用能设备表
        CeDevice ceDevice = new CeDevice();
        switch (CeResClassEnum.fromCode(ceResClass)) {
            case CUSTOMER:
                ceDevice.setCeCustId(parCeResource.getId());
                ceDevice.setParentCeResClass(CeResClassEnum.CUSTOMER.getValue());
                ceDevice.setParentCeResId(parCeResource.getId());
                ceDevice.setCePartId(0L);
                ceDevice.setParentId(0L);
                ceDevice.setCeCntrId(0L);
                break;
            case REGION:
                CePart part = cePartService.getById(parCeResource.getId());
                ceDevice.setCeCustId(part.getCeCustId());
                ceDevice.setCePartId(part.getId());
                ceDevice.setParentCeResId(part.getId());
                ceDevice.setParentCeResClass(CeResClassEnum.REGION.getValue());
                ceDevice.setParentId(0L);
                ceDevice.setCeCntrId(0L);
                break;
            case CONTAINER:
                CeContainer container = ceContainerService.getById(parCeResource.getId());
                ceDevice.setCeCustId(container.getCeCustId());
                ceDevice.setCePartId(container.getCePartId());
                ceDevice.setParentCeResId(container.getId());
                ceDevice.setParentCeResClass(CeResClassEnum.CONTAINER.getValue());
                ceDevice.setParentId(0L);
                ceDevice.setCeCntrId(container.getId());
                break;
            case DEVICE:
                CeDevice cedevice = getById(parCeResource.getId());
                ceDevice.setCeCustId(cedevice.getCeCustId());
                ceDevice.setCePartId(cedevice.getCePartId());
                ceDevice.setParentCeResId(cedevice.getId());
                ceDevice.setParentCeResClass(CeResClassEnum.DEVICE.getValue());
                ceDevice.setParentId(cedevice.getId());
                ceDevice.setCeCntrId(cedevice.getCeCntrId());
                break;
            default:
                throw new IllegalArgumentException("Invalid ceResClass: " + ceResClass);
        }
        ceDevice.setCeResSortNo(ceDeviceRequest.getCeResSortNo());
        JsonNode ceCntrProps = ceDeviceRequest.getCeResourceProps();
        CeResourceProps resourceData = createResourceData(ceDeviceRequest.getCeResSortNo());
        ceDevice.setCeDevProps(resourceData.savaConvertFields(ceCntrProps));
        ceDevice.setCeResSortNoId(ceDeviceRequest.getCeResSortNoId());
        save(ceDevice);

        // 2、将一些公共的字段从json里面抽取出来
        JsonNode ceResourceProps = ceDeviceRequest.getCeResourceProps();
        String ceResName = ceResourceProps.get("ceResName").asText();
        JsonNode sortSn1 = ceResourceProps.get("sortSn");
        String sortSn = sortSn1 == null || "".equals(sortSn1.asText()) || "null".equals(sortSn1.asText()) ? "1" : sortSn1.asText();
        JsonNode ceResNo1 = ceResourceProps.get("ceResNo");
        String ceResNo = ceResNo1 == null ? "" : ceResNo1.asText();
        // 获取关联表计
        JsonNode correlTableMeter = ceResourceProps.get("correlTableMeter");
        // 转换成List
        // 将correlTableMeter 转为 LIST<Long>
        List<String> meterList = new ArrayList<>();
        if (correlTableMeter != null) {
            if (correlTableMeter.isArray()) {
                for (Iterator<JsonNode> it = correlTableMeter.elements(); it.hasNext(); ) {
                    meterList.add(it.next().asText());
                }
            }
        }

        // 3、新增用能点
        CePoint cePoint = new CePoint();
        cePoint.setOrgNo(orgNo);
        cePoint.setCeCustId(ceDevice.getCeCustId());
        cePoint.setCeResId(ceDevice.getId());
        cePoint.setCeResClass(4);
        cePoint.setCePointLevel(1);
        cePoint.setCePointNo(ceResNo);
        if (StrUtil.isBlank(ceResNo)) {
            cePoint.setCePointNo(String.valueOf(ceDevice.getId()));
        }
        cePoint.setCePointName(ceResName);
        cePoint.setIsSettlement(0);
        // 设置用能类型
        CeResourceSortDto ceResourceSortDto = ceResourceSortService.queryCeResourceSortById(ceDeviceRequest.getCeResSortNoId());
        cePoint.setCePointType(ceResourceSortDto.getCeResType());
        cePoint.setParentId(ceDevice.getParentCeResId());
        cePoint.setCePointProps(new CePointPropsJsonObject());
        cePoint.setMeasPointIdList(meterList);
        cePointService.save(cePoint);

        // 4、如果关联表计集合不为空就新增用能点表计关联表
        if (CollectionUtil.isNotEmpty(meterList)) {
            List<CePointMeter> cePointMeters = new ArrayList<>();
            for (String aLong : meterList) {
                CePointMeter cePointMeter = new CePointMeter();
                cePointMeter.setCePointId(cePoint.getId());
                cePointMeter.setDevMeterId(Long.valueOf(aLong));
                cePointMeters.add(cePointMeter);
            }
            cePointMeterService.saveBatch(cePointMeters);
        }

        // 5、新增用能资源表
        CeResource ceResource = new CeResource();
        ceResource.setId(ceDevice.getId());
        ceResource.setCeResClass(CeResClassEnum.DEVICE.getValue());
        ceResource.setCeResStatus("20");
        // 设置排序序号
        ceResource.setSortSn(Integer.valueOf(sortSn));
        // 设置设备编号
        ceResource.setCeResNo(ceResNo);
        if (StrUtil.isBlank(ceResNo)) {
            ceResource.setCeResNo(String.valueOf(ceDevice.getId()));
        }
        // 设置用能设备名称
        ceResource.setCeResName(ceResName);
        ceResource.setCeResDesc(ceResName);
        ceResource.setCeResAbbr(ceResName);
        ceResource.setOrgNo(orgNo);
        if (StrUtil.isBlank(ceResNo)) {
            ceResource.setCeResNo(String.valueOf(ceDevice.getId()));
        }
        ceResourceService.addCeResource(ceResource, ceDeviceRequest.getCeResSortNo());
        return ceResource.getId().toString();
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean updateDeviceById(UpdateCeDeviceRequest ceDeviceRequest) {
        // 1、修改用能设备
        CeDevice ceDevice = new CeDevice();
        JsonNode ceCntrProps = ceDeviceRequest.getCeResourceProps();
        CeResourceProps resourceData = createResourceData(ceDeviceRequest.getCeResSortNo());
        ceDevice.setCeDevProps(resourceData.savaConvertFields(ceCntrProps));
        BeanUtils.copyProperties(ceDeviceRequest, ceDevice);
        ceDevice.setId(Long.valueOf(ceDeviceRequest.getId()));
        updateById(ceDevice);

        // 2、将一些公共的字段从json里面抽取出来
        JsonNode ceResourceProps = ceDeviceRequest.getCeResourceProps();
        String ceResName = ceResourceProps.get("ceResName").asText();
        JsonNode sortSn1 = ceResourceProps.get("sortSn");
        String sortSn = sortSn1 == null || "".equals(sortSn1.asText()) || "null".equals(sortSn1.asText()) ? "1" : sortSn1.asText();
        JsonNode ceResNo1 = ceResourceProps.get("ceResNo");
        String ceResNo = ceResNo1 == null ? "" : ceResNo1.asText();
        // 获取关联表计
        JsonNode correlTableMeter = ceResourceProps.get("correlTableMeter");
        // 转换成List
        // 将correlTableMeter 转为 LIST<Long>
        List<String> meterList = new ArrayList<>();
        if (correlTableMeter != null) {
            if (correlTableMeter.isArray()) {
                for (Iterator<JsonNode> it = correlTableMeter.elements(); it.hasNext(); ) {
                    meterList.add(it.next().asText());
                }
            }
        }

        // 3、查询用能点
        LambdaQueryWrapper<CePoint> pointQueryWrapper = new LambdaQueryWrapper<>();
        pointQueryWrapper
                .eq(CePoint::getCeResId, ceDeviceRequest.getId());
        CePoint cePoint = cePointService.getOne(pointQueryWrapper);

        // 4、修改用能点
        cePoint.setCePointNo(ceResNo);
        if (StrUtil.isBlank(ceResNo)) {
            cePoint.setCePointNo(String.valueOf(ceDevice.getId()));
        }
        cePoint.setCePointName(ceResName);
        cePoint.setMeasPointIdList(meterList);
        cePointService.updateById(cePoint);

        // 5、先删除用能点量测表计关系
        cePointMeterService.removeByCePointIds(Collections.singletonList(cePoint.getId()));

        // 6、重新添加用能点量测表计关系
        if (CollectionUtil.isNotEmpty(meterList)) {
            List<CePointMeter> cePointMeters = new ArrayList<>();
            for (String aLong : meterList) {
                CePointMeter cePointMeter = new CePointMeter();
                cePointMeter.setCePointId(cePoint.getId());
                cePointMeter.setDevMeterId(Long.valueOf(aLong));
                cePointMeters.add(cePointMeter);
            }
            cePointMeterService.saveBatch(cePointMeters);
        }

        // 7、修改用能资源表
        CeResource ceResource = new CeResource();
        BeanUtils.copyProperties(ceDeviceRequest, ceResource);
        ceResource.setOrgNo(AuthUtils.getOrgNo());
        ceResource.setId(Long.valueOf(ceDeviceRequest.getId()));
        // 设置排序序号
        ceResource.setSortSn(Integer.valueOf(sortSn));
        // 设置设备编号
        ceResource.setCeResNo(ceResNo);
        if (StrUtil.isBlank(ceResNo)) {
            ceResource.setCeResNo(String.valueOf(ceDevice.getId()));
        }
        // 设置用能设备名称
        ceResource.setCeResName(ceResName);
        ceResource.setCeResDesc(ceResName);
        ceResource.setCeResAbbr(ceResName);
        ceResource.setCeResClass(CeResClassEnum.DEVICE.getValue());
        return ceResourceService.updateCeResource(ceResource, ceDeviceRequest.getCeResSortNo());
    }

    @Override
    public CeDeviceVo getDeviceById(String id) {
        CeDevice ceDevice = ceDeviceMapper.selectById(id);
        CeResource ceResource = ceResourceService.getById(id);
        if (ceResource == null) {
            throw BizException.of("该设备已被删除");
        }
        CeDeviceDto ceDeviceDto = new CeDeviceDto();
        BeanUtils.copyProperties(ceDevice, ceDeviceDto);
        BeanUtils.copyProperties(ceResource, ceDeviceDto);

        // 获取并网关联表记
        CeResourceProps ceDevProps = ceDeviceDto.getCeDevProps();
        JSONObject jsonObject = JSONUtil.parseObj(ceDevProps);
        List<String> correlTableMeter = (List<String>) jsonObject.get("correlTableMeter");
        if (CollectionUtil.isNotEmpty(correlTableMeter)) {
            // 调用iot接口获取表记信息
            R<List<GmDevMeter>> devMeterIdList = remoteIotService.getDevMeterIdList(correlTableMeter);
            log.info("调用iot接口获取表记信息:{}", devMeterIdList.getCode());
            if (CollectionUtil.isNotEmpty(devMeterIdList.getData())) {
                List<GmDevMeter> data = devMeterIdList.getData();
                // 使用map方法，简化映射
                List<String> devMeterNos = data
                        .stream()
                        .map(GmDevMeter::getDevMeterNo)
                        .collect(Collectors.toList());
                jsonObject.set("correlTableMeterName", devMeterNos);
            }
        }

        // 关联间隔回显
        String inter = (String) jsonObject.get("inter");
        if (StrUtil.isNotEmpty(inter)) {
            LambdaQueryWrapper<CeResource> resourceQueryWrapper = new LambdaQueryWrapper<>();
            resourceQueryWrapper
                    .eq(CeResource::getId, inter);
            CeResource ceResourceServiceById = ceResourceService.getOne(resourceQueryWrapper);
            if (ceResourceServiceById != null) {
                jsonObject.set("interName", ceResourceServiceById.getCeResName());
            } else {
                jsonObject.set("inter", new ArrayList<>());
            }
        }

        CeDeviceVo ceDeviceVo = new CeDeviceVo();
        BeanUtils.copyProperties(ceDeviceDto, ceDeviceVo);
        ceDeviceVo.setCeResourceProps(jsonObject);
        return ceDeviceVo;
    }

    @Override
    public IPage<CeDeviceVo> listPagedDevices(PagedDevicesRequest request) {
        IPage<CeDeviceVo> result = new Page<>();

        Page<CeDevice> page = page(new Page<>(request.getPageNumber(), request.getPageSize()));

        if (CollectionUtil.isNotEmpty(page.getRecords())) {
            List<CeDevice> ceDevices = page.getRecords();
            List<CeDeviceVo> ceDeviceVos = new ArrayList<>();
            for (CeDevice ceDevice : ceDevices) {
                CeDeviceVo ceDeviceVo = new CeDeviceVo();
                BeanUtils.copyProperties(ceDevice, ceDeviceVo);
                ceDeviceVos.add(ceDeviceVo);
            }
            result.setRecords(ceDeviceVos);

            // 根据Vo列表的ID查询关联的资源信息
            List<Long> ids = ceDeviceVos.stream().map(CeDeviceVo::getId).collect(Collectors.toList());
            List<CeResource> ceResources = ceResourceService.listByIds(ids);

            // 将资源信息转换为Map，以ID为键
            Map<Long, CeResource> ceResourceMap = ceResources.stream().collect(Collectors.toMap(CeResource::getId, ceResource -> ceResource));
            // 将资源信息合并到Vo对象中
            ceDeviceVos.forEach(ceDeviceVo -> {
                CeResource ceResource = ceResourceMap.get(ceDeviceVo.getId());
                BeanUtils.copyProperties(ceResource, ceDeviceVo);
            });
        }

        result.setTotal(page.getTotal());
        result.setPages(page.getPages());
        result.setCurrent(page.getCurrent());
        result.setSize(page.getSize());
        return result;
    }

    @Override
    public List<IntervalVo> searchIntervals(String keyWord) {
        // 根据用户ID查询间隔信息
        Long userId = AuthUtils.getUserId();
        List<IntervalsWithParentInfoDto> intervals = ceDeviceMapper.searchIntervals(userId, AuthUtils.getOrgNo(), keyWord);

        // 将查询到的间隔信息按配电室ID进行分组
        Map<String, List<IntervalsWithParentInfoDto>> distributionRoomMap =
                intervals.stream().collect(Collectors.groupingBy(IntervalsWithParentInfoDto::getDistributionRoomId));

        // 将配电室分组信息转换为IntervalVo对象列表
        List<IntervalVo> result = distributionRoomMap.entrySet().stream()
                .map(distributionRoomEntry -> {
                    IntervalVo distributionRoomVo = new IntervalVo();
                    distributionRoomVo.setId(distributionRoomEntry.getKey());
                    distributionRoomVo.setCeResName(distributionRoomEntry.getValue().get(0).getDistributionRoomName());

                    // 按配电柜ID对间隔信息进行分组
                    Map<String, List<IntervalsWithParentInfoDto>> cabinetMap =
                            distributionRoomEntry.getValue().stream().collect(Collectors.groupingBy(IntervalsWithParentInfoDto::getCabinetId));

                    // 将配电柜分组信息转换为IntervalVo对象列表
                    List<IntervalVo> cabinetVos = cabinetMap.entrySet().stream()
                            .map(cabinetEntry -> {
                                IntervalVo cabinetVo = new IntervalVo();
                                cabinetVo.setId(cabinetEntry.getKey());
                                cabinetVo.setCeResName(cabinetEntry.getValue().get(0).getCabinetName());

                                // 将配电柜内的间隔信息转换为IntervalVo对象列表
                                List<IntervalVo> intervalVos = cabinetEntry.getValue().stream()
                                        .map(intervalDto -> {
                                            IntervalVo intervalVo = new IntervalVo();
                                            intervalVo.setId(intervalDto.getId());
                                            intervalVo.setCeResName(intervalDto.getCeResName());
                                            return intervalVo;
                                        })
                                        .collect(Collectors.toList());

                                cabinetVo.setIntervalVos(intervalVos);
                                return cabinetVo;
                            })
                            .collect(Collectors.toList());

                    distributionRoomVo.setIntervalVos(cabinetVos);
                    return distributionRoomVo;
                })
                .collect(Collectors.toList());
        return result;
    }

}




