package com.gaea.iesms.bm.archive.controller;


import com.gaea.base.core.R;
import com.gaea.iesms.bm.archive.model.request.cePart.CePartRequest;
import com.gaea.iesms.core.feign.request.archive.EnergyRegionPageRequest;
import com.gaea.iesms.bm.archive.model.request.cePart.UpdateCePartRequest;
import com.gaea.iesms.bm.archive.model.response.dto.cePart.CePartDto;
import com.gaea.iesms.bm.archive.model.response.dto.cePart.CePartPageDto;
import com.gaea.iesms.core.feign.response.archive.CePartPageVo;
import com.gaea.iesms.bm.archive.service.CePartService;
import com.gaea.iesms.core.feign.response.archive.CePartVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @author JIE
 * @version 1.0
 * @description: 用能区域档案管理
 * @date 2023/3/20 14:18
 */
@Api(tags = "用能区域档案管理")
@RestController
@RequestMapping("/cePart")
public class CePartController {

    @Resource
    private CePartService cePartService;

    @ApiOperation(value = "增加用能区域档案档案", notes = "返回用能区域主键id")
    @PostMapping("/addPart")
    public R<String> addPart(@RequestBody CePartRequest cePartRequest) {
        // 调用增加方法
        return R.ok(cePartService.addCePart(cePartRequest));
    }

    @ApiOperation(value = "修改用能区域档案 ")
    @PutMapping("/updatePart")
    public R<Boolean> updatePart(@RequestBody UpdateCePartRequest request) {
        Boolean aBoolean = cePartService.updateEnergyRegionByArchiveId(request);
        return R.ok(aBoolean);
    }

    @ApiParam(name = "id", value = "用能区域档案主键ID", required = true)
    @ApiOperation(value = "查询单个用能区域详细信息")
    @GetMapping("/getPartByArchiveId")
    public R<CePartVo> getPartByArchiveId(@RequestParam("id") String id) {
        CePartVo cePartVo = cePartService.getEnergyRegionDetailByArchiveId(id);
        return R.ok(cePartVo);
    }

    @ApiOperation(value = "分页查询区域档案")
    @GetMapping("/listPagedUserProfiles")
    public R<CePartPageVo> listPagedUserProfiles(EnergyRegionPageRequest energyRegionPageRequest) {
        CePartPageDto cePartPageDto = cePartService.listPagedEnergyRegions(energyRegionPageRequest);
        // 数据拷贝
        CePartPageVo cePartPageVo = new CePartPageVo();
        List<CePartVo> cePartVoList = new ArrayList<>();
        // 获取用能区域档案数据
        List<CePartDto> cePartDtoList = cePartPageDto.getCePartDtoList();
        // 数据拷贝
        for (CePartDto cePartDto : cePartDtoList) {
            CePartVo cePartVo = new CePartVo();
            BeanUtils.copyProperties(cePartDto, cePartVo);
            cePartVoList.add(cePartVo);
        }
        cePartPageVo.setCePartVoList(cePartVoList);
        cePartPageVo.setTotal(cePartPageDto.getTotal());
        return R.ok(cePartPageVo);
    }
}
