package com.gaea.iesms.bm.archive.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gaea.iesms.bm.archive.model.request.ceContainer.CeContainerByResClassAndTypeQueryRequest;
import com.gaea.iesms.bm.archive.model.request.ceContainer.ContainerListRequest;
import com.gaea.iesms.bm.archive.model.response.dto.ceContainer.CeContainerDto;
import com.gaea.iesms.bm.archive.model.response.dto.cePart.CePartPageDto;
import com.gaea.iesms.bm.archive.model.response.dto.ceResource.EnergyResourceTypeDto;
import com.gaea.iesms.core.model.entity.archive.CeContainer;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author JIE
 * @description 针对表【ce_container(用能容器 )】的数据库操作Mapper
 * @createDate 2023-02-20 09:41:47
 * @Entity com.gaea.iesms.core.model.entity.archive.CeContainer
 */
@Mapper
public interface CeContainerMapper extends BaseMapper<CeContainer> {

    /**
     * 查询所有用能容器档案
     *
     * @param: page 分页参数
     * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.gaea.iesms.bm.archive.model.response.dto.ceContainer.CeContainerDto>
     * @author JIE
     * @date: 2024/2/26 11:33
     */
    IPage<CeContainerDto> listPageContainer(@Param("param") ContainerListRequest request,
                                            @Param("page") Page<CeContainerDto> page);


    /**
     * 根据上级用能资源id,用能资源类别和用能资源类型 获取用能容器
     *
     * @param: request
     * @return: java.util.List<com.gaea.iesms.bm.archive.model.response.dto.ceResource.EnergyResourceTypeDto>
     * @author JIE
     * @date: 2024/2/26 11:33
     */
    List<EnergyResourceTypeDto> queryCeContainerByCeResClassAndCeResType(CeContainerByResClassAndTypeQueryRequest request);
}




