package com.gaea.iesms.bm.archive.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.gaea.iesms.core.feign.dto.DevMeterIdAndCeResIdDto;
import com.gaea.iesms.core.model.entity.archive.CePointMeter;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 用能点量测表计关系
 *
 * @author JIE
 * @version 1.0
 * @date 2024/1/31 10:17
 */
@Mapper
public interface CePointMeterMapper extends BaseMapper<CePointMeter> {

    /**
     * 根据用能资源Id 获取量测表计ID集合
     *
     * @param ceResIds 用能资源ID集合
     * @return 量测表计ID集合
     * @author JIE
     * @date: 2023/11/28 15:31
     */
    List<DevMeterIdAndCeResIdDto> getDevMeterIdListByCeResIds(@Param("ceResIds") List<Long> ceResIds);

    /**
     * 物理删除用能点和表计关系
     *
     * @param: cePointId
     * @return: int
     * @author JIE
     * @date: 2023/12/6 9:14
     */
    int removeByCePointIds(@Param("cePointIds") List<Long> cePointIds);
}