package com.gaea.iesms.bm.archive.model.response.dto.CePoint;

import com.gaea.iesms.core.model.core.IesmsNormalEntity;
import lombok.Data;

import java.util.List;

/**
 * 用能点DTO类，用于在服务层和控制层交互的数据传输对象
 *
 * @author Jie
 */
@Data
public class CePointDto extends IesmsNormalEntity {

    /**
     * 系统单位编号
     */
    private String orgNo;

    /**
     * 用能点编号
     */
    private String cePointNo;

    /**
     * 用能客户标识
     */
    private Long ceCustId;

    /**
     * 用能资源标识
     */
    private Long ceResId;

    /**
     * 用能资源类别
     * 1 - 用能客户；
     * 2 - 用能区域；
     * 3 - 用能容器；
     * 4 - 用能设备；
     */
    private Integer ceResClass;

    /**
     * 用能点名称
     */
    private String cePointName;

    /**
     * 用能点分类
     * 1 – 用电；
     * 2 – 用水；
     * 3 – 用气；
     * 4 – 用热；
     * 5 - 用汽；
     */
    private Integer cePointSort;

    /**
     * 是否结算
     */
    private Integer isSettlement;

    /**
     * 用能点层级
     */
    private Integer cePointLevel;

    /**
     * 上级用能点标识
     */
    private Long parentId;

    /**
     * 量测点集合
     */
    private List<Long> measPointIdList;

    /**
     * 量测计算公式
     */
    private String measCalcRule;

    /**
     * 用能点属性集
     */
    private String cePointProps;

}
