package com.gaea.iesms.bm.archive.model.response.dto.ceCust;


import com.gaea.iesms.core.model.enums.archive.CeCustTypeEnum;
import com.gaea.iesms.core.model.enums.archive.CeResClassEnum;
import com.gaea.iesms.core.model.enums.archive.CeResStatusEnum;
import com.gaea.iesms.core.model.jsonobject.archive.CeCustBizpropsJsonObject;
import com.gaea.iesms.core.model.jsonobject.archive.CeCustPropsJsonObject;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 用能客户 用能资源子表
 *
 * @TableName ce_cust
 */
@Data
public class CeCustDto implements Serializable {

    /**
     * 用能资源标识 SnowflakeId
     */
    private String id;

    /**
     * 用能客户类型
     *
     * @see CeCustTypeEnum
     */
    private Integer ceCustType;

    /**
     * 用能客户证件号码
     */
    private String ceCustCredNo;

    /**
     * 用能客户证件附件
     */
    private String ceCustCredAttach;

    /**
     * 用能客户地址
     */
    private String ceCustAddr;

    /**
     * 用能客户属性集
     */
    private CeCustPropsJsonObject ceCustProps;

    /**
     * 用能客户业务属性集
     */
    private CeCustBizpropsJsonObject ceCustBizprops;

    /**
     * 行业分类
     */
    private String tradeCode;

    /**
     * 区域编码
     */
    private String adcode;

    /**
     * 城市编码
     */
    private String citycode;

    /**
     * 经度
     */
    private BigDecimal longitude;

    /**
     * 纬度
     */
    private BigDecimal latitude;

    /**
     * 用能资源类别 1 - 用能客户；
     * 2 - 用能区域；
     * 3 - 用能容器；
     * 4 - 用能设备;
     *
     * @see CeResClassEnum
     */
    private Integer ceResClass;

    /**
     * 用能资源编号
     */
    private String ceResNo;

    /**
     * 用能资源状态 编码CE_RES_STATUS：
     *
     * @see CeResStatusEnum
     */
    private String ceResStatus;

    /**
     * 用能资源名称
     */
    private String ceResName;

    /**
     * 用能资源简称
     */
    private String ceResAbbr;

    /**
     * 用能资源说明
     */
    private String ceResDesc;

    /**
     * 用电容量
     */
    private BigDecimal elecCapacity;

    /**
     * 电压等级 编码CE_VOLTAGE_CLASS
     */
    private String voltageClass;

    /**
     * 系统单位编号
     */
    private String orgNo;

    /**
     * 系统单位名称
     */
    private String orgName;


    /**
     * 排序序号
     */
    private Integer sortSn;

    /**
     * 是否有效
     */
    private Boolean isValid;

    /**
     * 创建人 系统用户表用户编号字段（user_no）
     */
    private String creator;

    /**
     * 创建时间 为0表示为空
     */
    private Long gmtCreate;

    /**
     * 更新人 系统用户表用户编号字段（user_no）
     */
    private String modifier;

    /**
     * 更新时间 为0表示为空
     */
    private Long gmtModified;

    /**
     * 失效人 系统用户表用户编号字段（user_no）
     */
    private String invalider;

    /**
     * 失效时间 为0表示为空
     */
    private Long gmtInvalid;

    /**
     * 版本号 用于乐观锁
     */
    private Integer version;

    private static final long serialVersionUID = 1L;
}