package com.gaea.iesms.bm.archive.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gaea.iesms.bm.archive.mapper.CePointMeterMapper;
import com.gaea.iesms.bm.archive.service.CePointMeterService;
import com.gaea.iesms.core.feign.dto.DevMeterIdAndCeResIdDto;
import com.gaea.iesms.core.model.entity.archive.CePointMeter;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 用能点量测表计关系
 *
 * @author JIE
 * @version 1.0
 * @date 2024/1/31 10:18
 */
@Service
public class CePointMeterServiceImpl extends ServiceImpl<CePointMeterMapper, CePointMeter> implements CePointMeterService {

    @Resource
    private CePointMeterMapper cePointMeterMapper;

    @Override
    public List<DevMeterIdAndCeResIdDto> getDevMeterIdListByCeResIds(List<Long> ceResIds) {
        return cePointMeterMapper.getDevMeterIdListByCeResIds(ceResIds);
    }

    @Override
    public int removeByCePointIds(List<Long> cePointId) {
        return cePointMeterMapper.removeByCePointIds(cePointId);
    }
}
