package com.gaea.iesms.bm.common.Enum;

import com.gaea.base.core.IBaseEnum;
import lombok.Getter;

/**
 * @author tupz
 * @version 1.0
 * @date 2021/10/8 15:52
 */
@Getter
public enum SmsTypeEnum implements IBaseEnum<Integer> {
//    0：订单回答后12小时通知
//    1：视频咨询倒计时5分钟通知用户进入房间
//    2：下单后短信通知
//    3：咨询时用户追问通知咨询老师
//    4：视频超时退款通知用户
//    5：客户取消短信通知服务老师
//    6：服务老师取消订单
//    7：服务老师接单，等待视频开始
//    90：验证码
//    91：新建用户验证码
//    92：新建服务老师等信息。
    /**
     * 0 - 验证码
     */
    SMS_ANS(0, "订单回答后12小时通知"),

    /**
     * 1
     */
    SMS_INROOM(1, "视频咨询倒计时5分钟通知用户进入房间"),

    /**
     * 2
     */
    SMS_NOTIC(2, "下单后短信通知"),

    /**
     * 3
     */
    SMS_ANS_TWO(3, "咨询时用户追问通知咨询老师"),

    /**
     * 3
     */
    SMS_C_CANCLE(5, "客户取消短信通知服务老师"),

    /**
     * 3
     */
    SMS_B_CANCLE(6, "服务老师取消订单"),

    /**
     * 10
     */
    SMS_SERVICES_DD(10, "服务到店提醒"),

    /**
     * 11
     */
    SMS_SERVICES_SM(11, "上门提醒"),

    /**
     * 12
     */
    SMS_SERVICES_CANCLE(12, "服务老师取消预约"),

    /**
     * 13
     */
    SMS_SERVICES_UPDTIME(13, "客户修改预约时间"),

    /**
     * 90
     */
    SMS_IDENTIFY(90, "登录短信验证码"),

    /**
     * 91
     */
    SMS_IDENTIFY_LOGIN(91, "新建用户短信验证码"),

    /**
     * 3
     */
    SMS_CONSULT(3, "下单后短信通知");

    private final Integer value;
    private final String name;

    SmsTypeEnum(final Integer value, final String name) {
        this.value = value;
        this.name = name;
    }

    /**
     * 根据code获取去value
     * @param code
     * @return
     */
    public static String getNameByValue(Integer code){
        for(SmsTypeEnum smsTypeEnum:SmsTypeEnum.values()){
            if(code.equals(smsTypeEnum.getValue())){
                return smsTypeEnum.getName();
            }
        }
        return  null;
    }

    @Override
    public Integer getValue() {
        return value;
    }

    @Override
    public String getName() {
        return name;
    }
}
