package com.gaea.iesms.bm.common.config;

import com.zaxxer.hikari.HikariDataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2022/5/10
 */
@Configuration
@Order(Ordered.HIGHEST_PRECEDENCE)
@SuppressWarnings("all")
@ConditionalOnProperty(name = "spring.datasource.hikari.system.driver-class-name", havingValue = "com.mysql.cj.jdbc.Driver")
public class SystemDataSourceConfig {

    @Bean(name = "systemDataSource")
    @Qualifier("systemDataSource")
    @ConfigurationProperties(prefix = "spring.datasource.hikari.system")
    DataSource systemDataSource() {
        return DataSourceBuilder.create().type(HikariDataSource.class).build();
    }

    @Bean(name = "systemTransactionManager")
    @Qualifier("systemTransactionManager")
    public DataSourceTransactionManager systemTransactionManager(@Qualifier("systemDataSource") DataSource systemDataSource) {
        return new DataSourceTransactionManager(systemDataSource);
    }
}
