package com.gaea.iesms.bm.common.config;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.sql.DataSource;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2022/5/10
 */
@Configuration
@Order(Ordered.HIGHEST_PRECEDENCE + 1)
@SuppressWarnings("all")
@ConditionalOnProperty(name = "spring.datasource.hikari.system.driver-class-name", havingValue = "com.mysql.cj.jdbc.Driver")
public class SystemJdbcTemplateConfig {

    @Bean(name = "systemJdbcTemplate")
    @Qualifier("systemJdbcTemplate")
    JdbcTemplate systemJdbcTemplate(@Qualifier("systemDataSource") DataSource systemDataSource) {
        return new JdbcTemplate(systemDataSource);
    }
}
