package com.gaea.iesms.bm.common.model;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * @author tupz
 * @version 1.0
 * @date 2021/10/8 15:05
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class LogSms implements Serializable {
    private static final long serialVersionUID = 4551556040735084237L;
    /**
     * 主键标识
     * SnowflakeId
     */
    @TableId(type = IdType.AUTO)
    protected Integer id;

    private String smsPhone;

    /**
     *  短信类型 参考SmsTypeEnum
     */
    private Integer operationType;

    /**
     *  短信说明 参考SmsTypeEnum
     */
    private String operationDesc;

    private String content;

    private Integer contentId;

    /**
     * 短信发送状态，根据接口返回得到
     */
    private String status;

    /**
     * 创建时间;为0表示为空
     */
    @TableField(fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createdTime;
}
