package com.gaea.iesms.bm.common.controller.weather;

import com.gaea.base.core.R;
import com.gaea.iesms.bm.common.model.configVo.LogisticsReturn;
import com.gaea.iesms.bm.common.util.LogisticsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author tupz
 * @version 1.0
 * 物流信息相关
 * @date 2021/10/9 18:17
 */
@RestController
@RequestMapping(value = "/weather")
public class WeatherController {
    private static final Logger LOGGER = LoggerFactory.getLogger(WeatherController.class);
    @Resource
    private LogisticsUtil logisticsUtil;

    @GetMapping("/getWeather")
    /**
    * @Description: (summary ="根据物流单号和物流公司获取物流详情", description = "根据物流单号和物流公司获取物流详情")
    * @Param: [no, type]
    * @return: Result
    * @Author: tupz
    * @Date: 2024/9/5 8:54
    */
    public R getLogisticsDetail(@RequestParam("no") String no, @RequestParam(value = "type",required = false) String type) {
        try{
            LogisticsReturn re = logisticsUtil.getLogisticsInfo(no,type);
            return R.ok(re);
        }catch(Exception e){
            e.printStackTrace();
            return R.failure().msg("根据物流单号和物流公司获取物流详情失败");
        }
    }
}
