package com.gaea.iesms.bm.common.model.configVo;

import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * 阿里云市场调用必备vo
 * @author tupz
 * @version 1.0
 * @date 2021/10/8 15:05
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class LogisticsResult implements Serializable {
    private static final long serialVersionUID = 4551556040735084237L;
    // 是否本人签收【不准 可能物管帮收】
    private String issign;
    //运单编号
    private String number;
//    快递投递状态码(deliverystatus)
//    状态码 说明
//    0快递收件(揽件)
//    1在途中
//    2正在派件
//    3已签收
//    4 派送失败（无法联系到收件人或客户要求择日派送，地址不详或手机号不清）
//    5疑难件（收件人拒绝签收，地址有误或不能送达派送区域，收费等原因无法正常派送）
//    6退件签收
    private String deliverystatus;
    // 快递公司名称
    private String expName;
    // 快递公司电话
    private String expPhone;
    // 快递公司官网
    private String expSite;
    // 快递公司编码
    // 举例  JD--京东  ZTO-中通  STO--申通 SFEXPRESS--顺丰  YTO--圆通  YUNDA--韵达  FEDEX--联邦快递
    private String type;
    // 结果集
    private List<LogisticsList> list;
}
