package com.gaea.iesms.bm.common.util;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONUtil;
import com.gaea.iesms.bm.common.config.AliMarketConfig;
import com.gaea.iesms.bm.common.model.configVo.LogisticsReturn;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author tupz
 * @version 1.0
 * @date 2022/4/27 10:47
 */
@Component
public class LogisticsUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogisticsUtil.class);
    @Autowired
    private AliMarketConfig aliMarketConfig;

    /**
     *
     * @param no----快递单号，顺丰特殊 需要快递单号:收件人或者寄件人手机后四位，如xxxx:4405
     * @param type -- 快递公司字母简写 填写后查询速度更快
     * @return
     * @throws Exception
     */
    public LogisticsReturn getLogisticsInfo(String no, String type) throws Exception{
        String host = "https://" + aliMarketConfig.getLogistics().getHost();
        String path = aliMarketConfig.getLogistics().getPath();
        LOGGER.info("调用获取物流信息接口url为=========" + host + path + "?" + no);
        String method = "GET";
        String appcode = aliMarketConfig.getLogistics().getAppcode();
        java.util.Map<java.lang.String, java.lang.String> headers = new HashMap<String, String>();
        //最后在header中的格式(中间是英文空格)为Authorization:APPCODE 83359fd73fe94948385f570e3c139105
        headers.put("Authorization", "APPCODE " + appcode);
        Map<String, String> querys = new HashMap<java.lang.String, java.lang.String>();
        querys.put("no", no);
        if(StrUtil.isNotEmpty(type)){
            querys.put("type", type);
        }

        /**
         * 重要提示如下:
         * HttpUtils请从
         * https://github.com/aliyun/api-gateway-demo-sign-java/blob/master/src/main/java/com/aliyun/api/gateway/demo/util/HttpUtils.java
         * 下载
         *
         * 相应的依赖请参照
         * https://github.com/aliyun/api-gateway-demo-sign-java/blob/master/pom.xml
         */
        HttpResponse res = HttpUtils.doGet(host, path, method, headers, querys);
        String jsonStr = EntityUtils.toString(res.getEntity());
        // 转换成pojo
        LogisticsReturn re = JSONUtil.toBean(jsonStr, LogisticsReturn.class);

        return re;
    }


}
