package com.gaea.iesms.bm.common.util;

import cn.hutool.Hutool;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONUtil;
import com.gaea.iesms.bm.common.config.SmsConfig;
import com.gaea.iesms.bm.common.model.request.SmsSendRequest;
import com.gaea.iesms.bm.common.model.response.SmsSendResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

/**
* @Description: SmsUtil
* @Param: 
* @return: 
* @Author: tupz
* @Date: 2024/9/14 10:46
*/
@Component
public class SmsUtil {
    public static final String charset = "utf-8";

    @Autowired
    private SmsConfig smsConfig;

    public static void main(String[] args) throws Exception {
        //请求地址请登录253云通讯自助通平台查看或者询问您的商务负责人获取
        String smsSingleRequestServerUrl = "http://smssh1.253.com/msg/send/json";
        // 短信内容
        String msg = "【立客见】你好,你的验证码是123456";
        //手机号码
        String phone = "13777844405";
        //状态报告
        String report= "true";

        String username= "N1635767";
        String pas = "oCqHIPcFizf068";
        SmsSendRequest smsSingleRequest = new SmsSendRequest();
        smsSingleRequest.setAccount(username);
        smsSingleRequest.setPassword(pas);
        smsSingleRequest.setMsg(msg);
        smsSingleRequest.setPhone(phone);
        smsSingleRequest.setReport(report);
        String requestJson = JSONUtil.toJsonStr(smsSingleRequest);
        String response = sendSmsByPost(smsSingleRequestServerUrl, requestJson);
        SmsSendResponse smsSingleResponse = JSONUtil.toBean(response, SmsSendResponse.class);
        System.out.println(smsSingleResponse.toString());
    }

    public String sendSms(String message, String phone,int type) throws Exception{
        //状态报告
        String report= "true";
        SmsSendRequest smsSingleRequest = new SmsSendRequest();
        smsSingleRequest.setAccount(smsConfig.getUsername());
        smsSingleRequest.setPassword(smsConfig.getPassword());
        // 组装内容--90,91为验证码
        if(type == 90 || type == 91){
            message = "【立客见】您的短信验证码为：" + message;
        }
        smsSingleRequest.setMsg(message);
        smsSingleRequest.setPhone(phone);
        smsSingleRequest.setReport(report);
        String requestJson = JSONUtil.toJsonStr(smsSingleRequest);
        System.out.println("【立客见】短信发送信息为: " + requestJson);
        String response = sendSmsByPost(smsConfig.getUrl(), requestJson);
        SmsSendResponse smsSingleResponse = JSONUtil.toBean(response, SmsSendResponse.class);
        System.out.println("sms response is :" + smsSingleResponse);
        return smsSingleResponse.getCode();
    }

    /**
     *
     * @Description
     * @param path
     * @param postContent
     * @return String
     * @throws
     */
    public static String sendSmsByPost(String path, String postContent) {
        URL url = null;
        try {
            url = new URL(path);
            HttpURLConnection httpURLConnection = (HttpURLConnection) url.openConnection();
            httpURLConnection.setRequestMethod("POST");// 提交模式
            httpURLConnection.setConnectTimeout(10000);//连接超时 单位毫秒
            httpURLConnection.setReadTimeout(10000);//读取超时 单位毫秒
            // 发送POST请求必须设置如下两行
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.setRequestProperty("Content-Type", "application/json");

            httpURLConnection.connect();
            OutputStream os=httpURLConnection.getOutputStream();
            os.write(postContent.getBytes("UTF-8"));
            os.flush();
            StringBuilder sb = new StringBuilder();
            int httpRspCode = httpURLConnection.getResponseCode();
            if (httpRspCode == HttpURLConnection.HTTP_OK) {
                // 开始获取数据
                BufferedReader br = new BufferedReader(
                        new InputStreamReader(httpURLConnection.getInputStream(), "utf-8"));
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                br.close();
                return sb.toString();
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}
