package com.gaea.iesms.bm.common;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;

/**
* @Param:
* @return:
* @Author: tupz
* @Date: 2024/9/4 19:06
*/
@EnableDiscoveryClient
@EnableFeignClients(basePackages = "com.gaea.iesms.core.feign.**")
@SpringBootApplication(scanBasePackages = {"com.gaea.iesms.bm.common.**",  "com.gaea.spring.cloud.starter.**"})
public class CommonStarter {
    public static void main(final String... args) {
        try {
            SpringApplication.run(CommonStarter.class, args);
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
}
