package com.gaea.iesms.bm.common.Enum;

import com.gaea.base.core.IBaseEnum;
import lombok.Getter;

/**
 * 查询快递接口返回状态码
 * @author tupz
 * @version 1.0
 * @date 2021/10/8 15:52
 */
@Getter
public enum LogisticsStatusEnum implements IBaseEnum<Integer> {
    /**
     * 0 - 查询正常
     */
    LOGISTICS_OK(0, "查询正常"),

    /**
     * 201 快递单号错误
     */
    LOGISTICS_NO_ERROR(201, "快递单号错误"),

    /**
     * 203 快递公司不存在
     */
    LOGISTICS_EXP_NOTEXSIT(203, "快递公司不存在"),

    /**
     * 204 快递公司识别失败
     */
    LOGISTICS_EXP_ERROR(204, "快递公司识别失败"),

    /**
     * 205 没有信息；单号错误 (一个单号对应多个快递公司，请求须指定快递公司)
     */
    LOGISTICS_NO_MUL(205, "没有信息；单号错误 (一个单号对应多个快递公司，请求须指定快递公司)"),

    /**
     * 207 该单号被限制，错误单号；一个单号对应多个快递公司，请求须指定快递公司
     */
    LOGISTICS_NO_LIMIT(207, "该单号被限制，错误单号；一个单号对应多个快递公司，请求须指定快递公司");


    private final Integer value;
    private final String name;

    LogisticsStatusEnum(final Integer value, final String name) {
        this.value = value;
        this.name = name;
    }

    /**
     * 根据code获取去value
     * @param code
     * @return
     */
    public static String getNameByValue(Integer code){
        for(LogisticsStatusEnum smsTypeEnum: LogisticsStatusEnum.values()){
            if(code.equals(smsTypeEnum.getValue())){
                return smsTypeEnum.getName();
            }
        }
        return  null;
    }
    @Override
    public Integer getValue() {
        return value;
    }

    @Override
    public String getName() {
        return name;
    }
}
