package com.gaea.iesms.bm.common.controller.oss;

import com.gaea.base.core.R;
import com.gaea.iesms.bm.common.controller.sms.SmsSendController;
import com.gaea.iesms.bm.common.util.OssUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;

/**
* @Description: OssController
* @Param:
* @return:
* @Author: tupz
* @Date: 2024/9/14 10:42
*/
@RestController
@RequestMapping(value = "/oss")
public class OssController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmsSendController.class);
    @Resource
    private OssUtil ossUtil;

    @PostMapping("/uploadToOss")
    public R uploadToOss(@RequestParam("file") MultipartFile newfile) {
        try{
            String res = ossUtil.uploadObject2OSS("likejian",newfile.getInputStream(),newfile.getOriginalFilename());
            return R.ok(res);
        }catch(Exception e){
            e.printStackTrace();
            return R.failure().msg("上传图片失败");
        }
    }
}
