package com.gaea.iesms.bm.common.util;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSClientBuilder;
import com.gaea.iesms.bm.common.config.OssConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.InputStream;

/**
* @Description: OssUtil
* @Param:
* @return: 
* @Author: tupz
* @Date: 2024/9/14 10:46
*/
@Component
public class OssUtil {
    private static final String contentType = "image/";
    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private OssConfig ossConfig;

    public String uploadObject2OSS(String folderName, InputStream inputStream,
                                    String fileName) {
        String url = null;
        OSS ossClient=getOSSClient(ossConfig);
        try {
            String newFileName = folderName+ "/"+ String.valueOf(System.currentTimeMillis()) + "/" + fileName;
           // ObjectMetadata metadata = new ObjectMetadata();
            //如果没有扩展名则填默认值application/octet-stream
            //metadata.setContentType(getcontentType(fileName.substring(fileName.lastIndexOf("."))));
            ossClient.putObject(ossConfig.getBucketname(), newFileName, inputStream);
            url=generateFilePath(ossConfig.getBucketname(), newFileName);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            ossClient.shutdown();
        }
        return url;
    }

    public static OSS getOSSClient(OssConfig oosConfig){
        return new OSSClientBuilder().build(oosConfig.getEndpoint(),oosConfig.getKeyid(),oosConfig.getKeysecret());
    }

    private static String generateFilePath(String bucketName, String fileName) {
        return "https://" + bucketName + ".oss-cn-hangzhou.aliyuncs.com/" + fileName;
    }

    /**
     * 删除文件
     * @param
     * @param filePath
     * @throws Exception
     */
    public void deleteFile(String filePath)throws Exception
    {
        OSSClient ossClient = new OSSClient(ossConfig.getEndpoint(), ossConfig.getKeyid(),ossConfig.getKeysecret());
        boolean exist = ossClient.doesObjectExist(ossConfig.getBucketname(), filePath);
        if (!exist) {
            logger.debug("文件不存在,filePath={}"+filePath);
        }
        logger.debug("删除文件,filePath={}"+filePath);
        ossClient.deleteObject(ossConfig.getBucketname(), filePath);
    }
    public static String getcontentType(String FilenameExtension) {
        if (FilenameExtension.equalsIgnoreCase(".bmp")) {
            return "image/bmp";
        }
        if (FilenameExtension.equalsIgnoreCase(".gif")) {
            return "image/gif";
        }
        if (FilenameExtension.equalsIgnoreCase(".jpeg") ||
                FilenameExtension.equalsIgnoreCase(".jpg") ||
                FilenameExtension.equalsIgnoreCase(".png")) {
            return "image/jpg";
        }
        if (FilenameExtension.equalsIgnoreCase(".html")) {
            return "text/html";
        }
        if (FilenameExtension.equalsIgnoreCase(".txt")) {
            return "text/plain";
        }
        if (FilenameExtension.equalsIgnoreCase(".vsd")) {
            return "application/vnd.visio";
        }
        if (FilenameExtension.equalsIgnoreCase(".pptx") ||
                FilenameExtension.equalsIgnoreCase(".ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (FilenameExtension.equalsIgnoreCase(".docx") ||
                FilenameExtension.equalsIgnoreCase(".doc")) {
            return "application/msword";
        }
        if (FilenameExtension.equalsIgnoreCase(".xml")) {
            return "text/xml";
        }

        if (FilenameExtension.equalsIgnoreCase(".mp4")) {
            return "text/mp4";
        }
        return "image/jpg";
    }

}
