package com.gaea.iesms.bm.datacenter.constant;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-04
 */
public enum DevRunStatusEnum {

    /**
     *
     */
    NOTGOTORUN(10, "未投运"),
    GOTORUN(20, "投运"),
    PAUSERUN(30, "暂停"),
    STOPRUN(40, "停运");

    private int status;
    private String name;

    DevRunStatusEnum(int status, String name) {
        this.status = status;
        this.name = name;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static DevRunStatusEnum getNameByStatus(int status) {
        for(DevRunStatusEnum devRunStatusEnum : values()) {
            if(status == devRunStatusEnum.getStatus()) {
                return devRunStatusEnum;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "DevRunStatusEnum{" +
            "status=" + status +
            ", name='" + name + '\'' +
            '}';
    }

}
