package com.gaea.iesms.bm.datacenter.controller;

import com.gaea.base.core.R;
import com.gaea.iesms.core.model.entity.datacenter.MeasDataCumFreezeCurveDo;
import com.gaea.iesms.core.model.entity.datacenter.MeasDataInsFreezeCurveDo;
import com.gaea.iesms.bm.datacenter.service.MeasDataStoreService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: lifeng.du
 * @email: xxx@xx.com
 * @date: 2023/4/18 13:41
 */
@Api(tags = "量测数据存储服务")
@RestController
@RequestMapping("/measDataStore")
public class MeasDataStoreController {

    @Autowired
    private MeasDataStoreService measDataStoreService;

    /**
     * 更新一行数据，如果原行不存在，会新写入一行。
     * 更新操作包括写入某列、删除某列和删除某列的某一版本。
     *
     * @param measPointId
     *          量测点标识
     * @param measItemCode
     *          量测项编码
     * @param measDataInfo
     *          量测数据信息
     */
    @ApiOperation(value = "更新最新数据measDataLatest")
    @PostMapping("/updateMeasDataLatest")
    public R updateMeasDataLatest(@RequestParam("measPointId")  Long measPointId,@RequestParam("measItemCode")  String measItemCode,@RequestParam("measDataInfo")  Map<String, Object> measDataInfo) {
        measDataStoreService.updateMeasDataLatest(measPointId,measItemCode,measDataInfo);
        return R.ok();
    }


    /**
     * 批量更新数据
     *
     * @param batchMeasDataInfosMap
     *          批量量测数据信息Map
     */
    @ApiOperation(value = "批量更新数据")
    @PostMapping("/batchUpdateMeasDataLatest")
    public R batchUpdateMeasDataLatest(@RequestBody   Map<String, Map<String, Map<String, Object>>> batchMeasDataInfosMap) {
        measDataStoreService.batchUpdateMeasDataLatest(batchMeasDataInfosMap);
        return R.ok();
    }


    /**
     * 删除一行数据
     *
     * @param measPointId
     *          量测点标识
     * @param measItemCode
     *          量测项编码
     */
    @ApiOperation(value = "删除一行数据")
    @PostMapping("/deleteMeasDataLatest")
    public R deleteMeasDataLatest(@RequestParam("measPointId") Long measPointId,@RequestParam("measItemCode")  String measItemCode) {
        measDataStoreService.deleteMeasDataLatest(measPointId,measItemCode);
        return R.ok();
    }


    /**
     *  更新统计数据
     * @param measPointId
     * @param measItemCode
     * @param gmtMeasFreeze
     * @param measDataValue
     * @param measDataRate
     * @param measDataSource
     * @param gmtMeasData
     * @param freezeMode
     * @return
     */
    @ApiOperation(value = "更新统计数据")
    @PostMapping("/insertOrUpdateMeasDataCumFreezeCurve")
    public R insertOrUpdateMeasDataCumFreezeCurve(@RequestParam("measPointId") Long measPointId,@RequestParam("measItemCode") String measItemCode,@RequestParam("gmtMeasFreeze") long gmtMeasFreeze,@RequestParam("measDataValue") BigDecimal measDataValue,@RequestParam("measDataRate") BigDecimal measDataRate,@RequestParam("measDataSource") int measDataSource,@RequestParam("gmtMeasData") long gmtMeasData,@RequestParam("freezeMode") int freezeMode) {
        measDataStoreService.insertOrUpdateMeasDataCumFreezeCurve(measPointId,measItemCode,gmtMeasFreeze,measDataValue,measDataRate,measDataSource,gmtMeasData,freezeMode);
        return R.ok();
    }

    /**
     * 批量更新统计数据
     * @param measDataCumFreezeCurveDoList
     * @return
     */
    @ApiOperation(value = "批量更新统计数据")
    @PostMapping("/batchInsertOrUpdateMeasDataCumFreezeCurve")
    public R batchInsertOrUpdateMeasDataCumFreezeCurve(@RequestParam("measDataCumFreezeCurveDoList") List<MeasDataCumFreezeCurveDo> measDataCumFreezeCurveDoList) {
        measDataStoreService.batchInsertOrUpdateMeasDataCumFreezeCurve(measDataCumFreezeCurveDoList);
        return R.ok();
    }

    /**
     * 瞬时量数据
     * @param measPointId
     * @param measItemCode
     * @param gmtMeasFreeze
     * @param measDataValue
     * @param measDataRate
     * @param measDataSource
     * @param gmtMeasData
     * @param freezeMode
     * @return
     */
    @ApiOperation(value = "新增瞬时量数据")
    @PostMapping("/insertOrUpdateMeasDataInsFreezeCurve")
    public R insertOrUpdateMeasDataInsFreezeCurve(@RequestParam("measPointId") Long measPointId,@RequestParam("measItemCode") String measItemCode,@RequestParam("gmtMeasFreeze") long gmtMeasFreeze, @RequestParam("measDataValue") BigDecimal measDataValue,@RequestParam("measDataRate")  BigDecimal measDataRate, @RequestParam("measDataSource") int measDataSource,@RequestParam("gmtMeasData") long gmtMeasData,@RequestParam("freezeMode") int freezeMode) {
        measDataStoreService.insertOrUpdateMeasDataInsFreezeCurve(measPointId,measItemCode,gmtMeasFreeze,measDataValue,measDataRate,measDataSource,gmtMeasData,freezeMode);
        return R.ok();
    }


    /**
     * 批量新增瞬时量数据
     * @param measDataInsFreezeCurveDoList
     * @return
     */
    @ApiOperation(value = "批量新增瞬时量数据")
    @PostMapping("/batchInsertOrUpdateMeasDataInsFreezeCurve")
    public R batchInsertOrUpdateMeasDataInsFreezeCurve(@RequestParam("measDataInsFreezeCurveDoList") List<MeasDataInsFreezeCurveDo> measDataInsFreezeCurveDoList) {
        measDataStoreService.batchInsertOrUpdateMeasDataInsFreezeCurve(measDataInsFreezeCurveDoList);
        return R.ok();
    }


}
