package com.gaea.iesms.bm.datacenter.model.request;

import com.gaea.iesms.bm.datacenter.model.response.RunAccessGatewayQueryResponse;
import com.gaea.iesms.core.feign.request.datacenter.BaseRequest;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-04
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RunAccessGatewayQueryRequest implements BaseRequest<RunAccessGatewayQueryResponse> {

    private static final long serialVersionUID = -8227129285719950717L;

    /**
     * 接入设备标识Set
     * 可以为空
     */
    private Set<Long> devAccessIdSet;

    /**
     * 系统单位编号Set
     * 可以为空
     */
    private Set<String> orgNoSet;

    /**
     * 接入设备分类编号Set
     * 可以为空
     */
    private Set<String> devAccessSortNoSet;

    /**
     * 接入设备编号Set
     * 可以为空
     */
    private Set<String> devAccessNoSet;

    /**
     * 接入网关设备所属产品Set
     * 可以为空
     */
    private Set<String> productKeySet;

    /**
     * 接入网关设备客户端标识Set
     * 可以为空
     */
    private Set<String> clientIdSet;

    /**
     * 上行通讯规约Set
     * 可以为空
     */
    private Set<String> upcommProtoSet;

    /**
     * 上行通讯规约版本Set
     * 可以为空
     */
    private Set<String> upcommProtoVerSet;

    /**
     * 上行通讯逻辑地址Set
     * 可以为空
     */
    private Set<String> upcommLogicAddrSet;

    /**
     * 生命周期状态Set
     * 可以为空
     */
    private Set<String> lifeStateSet;

    /**
     * 运行状态Set
     * 可以为空
     */
    private Set<String> runStatusSet;

    /**
     * 是否在线
     * 可以为空，为空表示全部，包括在线和不在线
     */
    private Boolean online;

    /**
     * 接入设备名称（模糊查询）
     * 可以为空
     * 说明：不允许单独使用，需与上述条件组合使用
     */
    private String devAccessNameFuzzy;

    /**
     * 上行通讯逻辑地址（模糊查询）
     * 可以为空
     * 说明：不允许单独使用，需与上述条件组合使用
     */
    private String upcommLogicAddrFuzzy;

    @Override
    public Class<RunAccessGatewayQueryResponse> getResponseClass() {
        return RunAccessGatewayQueryResponse.class;
    }

}
