package com.gaea.iesms.bm.datacenter.service;

import com.gaea.base.core.R;
import com.gaea.iesms.core.feign.request.datacenter.*;
import com.gaea.iesms.core.feign.response.datacenter.RunAccessGatewayNameAndDescUpdateResponse;
import com.gaea.iesms.core.feign.response.datacenter.*;
import com.gaea.iesms.core.model.entity.datacenter.RunMeasPointDo;
import com.gaea.iesms.bm.datacenter.model.request.*;
import com.gaea.iesms.bm.datacenter.model.response.*;

import java.util.List;

/**
 * 接入设备管理
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
public interface AccessMgmtService {

    /**
     * 查询接入网关设备资产
     *
     * @param devAccessGatewayQueryRequest
     *          接入网关设备资产查询请求
     * @return  接入网关设备资产查询回应
     */
    DevAccessGatewayQueryResponse queryDevAccessGateway(DevAccessGatewayQueryRequest devAccessGatewayQueryRequest);

    /**
     * 单个获取运行接入网关设备
     *
     * @param getRequest
     *          运行接入网关设备单个获取请求
     * @return  运行接入网关设备单个获取回应
     */
    RunAccessGatewayGetResponse getRunAccessGateway(RunAccessGatewayGetRequest getRequest);

    /**
     * 单个修改运行接入网关设备
     *  修改接入网关设备名称、说明
     *
     * @param runAccessGatewayNameAndDescUpdateRequest
     *          运行接入网关设备修改获取请求
     * @return  运行接入网关设备修改获取回应
     */
    RunAccessGatewayNameAndDescUpdateResponse updateRunAccessGatewayNameAndDesc(RunAccessGatewayNameAndDescUpdateRequest runAccessGatewayNameAndDescUpdateRequest);

    /**
     * 单个修改运行接入网关设备
     *  修改接入网关设备运行状态
     *
     * @param runAccessGatewayRunStatusUpdateRequest
     *          运行接入网关设备修改运行状态请求
     * @return  运行接入网关设备修改运行状态回应
     */
    RunAccessGatewayRunStatusUpdateResponse updateRunAccessGatewayRunStatus(RunAccessGatewayRunStatusUpdateRequest runAccessGatewayRunStatusUpdateRequest);

    /**
     * 单个修改运行接入网关设备
     *  修改接入网关设备运行工况信息
     *
     * @param runAccessGatewayOpsInfoUpdateRequest
     *          运行接入网关设备修改运行工况信息请求
     * @return  运行接入网关设备修改运行工况信息回应
     */
    RunAccessGatewayOpsInfoUpdateResponse updateRunAccessGatewayOpsInfo(RunAccessGatewayOpsInfoUpdateRequest runAccessGatewayOpsInfoUpdateRequest);

    /**
     * 单个修改运行接入网关设备
     *  设置接入网关设备下线信息
     *
     * @param runAccessGatewayOfflineSetRequest
     *          运行接入网关设备设置下线信息
     * @return  运行接入网关设备设置下线信息
     */
    RunAccessGatewayOfflineSetResponse setRunAccessGatewayOffline(RunAccessGatewayOfflineSetRequest runAccessGatewayOfflineSetRequest);

    /**
     * 单个运行接入网关设备添加到系统单位
     *
     * @param runAccessGatewayAddToOrgRequest
     *          单个运行接入网关设备添加到系统单位请求
     * @return  单个运行接入网关设备添加到系统单位回应
     */
    RunAccessGatewayAddToOrgResponse addToOrgRunAccessGateway(RunAccessGatewayAddToOrgRequest runAccessGatewayAddToOrgRequest);

    /**
     * 单个运行接入网关设备从系统单位中删除
     *
     * @param runAccessGatewayDeleteFromOrgRequest
     *          单个运行接入网关设备从系统单位中删除请求
     * @return  单个运行接入网关设备从系统单位中删除回应
     */
    RunAccessGatewayDeleteFromOrgResponse deleteFromOrgRunAccessGateway(RunAccessGatewayDeleteFromOrgRequest runAccessGatewayDeleteFromOrgRequest);

    /**
     * 查询运行接入网关设备
     *
     * @param queryRequest
     *          运行接入网关设备查询请求
     * @return  运行接入网关设备查询回应
     */
    RunAccessGatewayQueryResponse queryRunAccessGateway(RunAccessGatewayQueryRequest queryRequest);

    /**
     * 单个获取运行量测点
     *
     * @param getRequest
     *          运行量测点单个获取请求
     * @return  运行量测点单个获取回应
     */
    RunMeasPointGetResponse getRunMeasPoint(RunMeasPointGetRequest getRequest);



    /**
     *
     *寻找单个网关下所有运行量测点数据
     * @param accessGatewayId
     *
     * @return  运行量测点获取回应
     */
    List<RunMeasPointDo> getRunMeasPointList(String  accessGatewayId);

    /**
     * 单个修改运行量测点
     *  修改名称、说明
     *
     * @param runMeasPointNameAndDescUpdateRequest
     *          运行量测点单个获取请求
     * @return  运行量测点单个获取回应
     */
    RunMeasPointNameAndDescUpdateResponse updateRunMeasPointNameAndDesc(RunMeasPointNameAndDescUpdateRequest runMeasPointNameAndDescUpdateRequest);

    /**
     * 单个修改运行量测点
     *  修改名称、说明
     *
     * @param runMeasPointOpsInfoUpdateRequest
     *          运行量测点单个获取请求
     * @return  运行量测点单个获取回应
     */
    RunMeasPointOpsInfoUpdateResponse updateRunMeasPointOpsInfo(RunMeasPointOpsInfoUpdateRequest runMeasPointOpsInfoUpdateRequest);

    /**
     * 批量修改运行量测点
     *
     * @param runMeasPointOpsInfoBatchUpdateRequest
     *          运行量测点单个获取请求
     * @return  运行量测点单个获取回应
     */
    RunMeasPointOpsInfoBatchUpdateResponse batchUpdateRunMeasPointOpsInfo(RunMeasPointOpsInfoBatchUpdateRequest runMeasPointOpsInfoBatchUpdateRequest);


    /**
     * 处理终端在线，表计不在线
     * @param mac
     * @return
     */
    R<BrushMeterResponse> brushMeter(String mac, String key,String topic);

    /**
     * 根据终端地址获取
     * @return
     */
    RunMeasPointListResponse getRunMeasPointListBySn(String sn);

    void editMeter(EditMeterRequest editMeterRequest);

    void delTermMeter(Long runMeasPointId);
}
