package com.gaea.iesms.bm.datacenter.service;


import com.gaea.iesms.core.feign.request.datacenter.*;
import com.gaea.iesms.core.feign.response.datacenter.MeasStatInsMonthGetResponse;
import com.gaea.iesms.core.feign.response.datacenter.*;

import java.util.List;

/**
 * 量测统计数据
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
public interface MeasStatService {

    /**
     * 获取瞬时量日统计数据（单个日期）
     * @param measStatInsDayGetRequest
     *          获取瞬时量日统计数据请求
     * @return  获取瞬时量日统计数据回应
     */
    MeasStatInsDayGetResponse getMeasStatInsDay(MeasStatInsDayGetRequest measStatInsDayGetRequest);


    /**
     * 获取瞬时量日统计数据（日期范围）
     * @param measStatInsDayGetRangeRequest
     *          获取瞬时量日统计数据请求
     * @return  获取瞬时量日统计数据回应
     */
    MeasStatInsDayGetRangeResponse getRangeMeasStatInsDay(MeasStatInsDayGetRangeRequest measStatInsDayGetRangeRequest);


    /**
     * 获取瞬时量月统计数据（单个月份）
     * @param measStatInsMonthGetRequest
     *          获取瞬时量月统计数据请求
     * @return  获取瞬时量月统计数据回应
     */
    MeasStatInsMonthGetResponse getMeasStatInsMonth(MeasStatInsMonthGetRequest measStatInsMonthGetRequest);

    /**
     * 获取瞬时量月统计数据（月份范围）
     * @param measStatInsMonthGetRangeRequest
     *          获取瞬时量月统计数据请求
     * @return  获取瞬时量月统计数据回应
     */
    MeasStatInsMonthGetRangeResponse getRangeMeasStatInsMonth(MeasStatInsMonthGetRangeRequest measStatInsMonthGetRangeRequest);


    /**
     * 获取瞬时量年统计数据（单个年份）
     * @param measStatInsYearGetRequest
     *          获取瞬时量年统计数据请求
     * @return  获取瞬时量年统计数据回应
     */
    MeasStatInsYearGetResponse getMeasStatInsYear(MeasStatInsYearGetRequest measStatInsYearGetRequest);


    /**
     * 获取瞬时量年统计数据（年份范围）
     * @param measStatInsYearGetRangeRequest
     *          获取瞬时量年统计数据请求
     * @return  获取瞬时量年统计数据回应
     */
    MeasStatInsYearGetRangeResponse getRangeMeasStatInsYear(MeasStatInsYearGetRangeRequest measStatInsYearGetRangeRequest);

    /**
     * 获取累计量日统计数据（单个日期）
     * @param measStatCumDayGetRequest
     *          获取累计量日统计数据请求
     * @return  获取累计量日统计数据回应
     */
    MeasStatCumDayGetResponse getMeasStatCumDay(MeasStatCumDayGetRequest measStatCumDayGetRequest);

    /**
     * 获取累计量日统计数据（日期范围）
     * @param measStatCumDayGetRangeRequest
     *          获取累计量日统计数据请求
     * @return  获取累计量日统计数据回应
     */
    MeasStatCumDayGetRangeResponse getRangeMeasStatCumDay(MeasStatCumDayGetRangeRequest measStatCumDayGetRangeRequest);

    /**
     * 获取累计量月统计数据（单个月份）
     * @param measStatCumMonthGetRequest
     *          获取累计量月统计数据请求
     * @return  获取累计量月统计数据回应
     */
    MeasStatCumMonthGetResponse getMeasStatCumMonth(MeasStatCumMonthGetRequest measStatCumMonthGetRequest);

    /**
     * 批量获取累计量月统计数据（单个月份）
     * @param measStatCumMonthBatchGetRequest
     *          获取累计量月统计数据请求
     * @return  获取累计量月统计数据回应
     */
    MeasStatCumMonthBatchGetResponse batchGetMeasStatCumMonth(MeasStatCumMonthBatchGetRequest measStatCumMonthBatchGetRequest);

    /**
     * 获取累计量月统计数据（月份范围）
     * @param measStatCumMonthGetRangeRequest
     *          获取累计量月统计数据请求
     * @return  获取累计量月统计数据回应
     */
    MeasStatCumMonthGetRangeResponse getRangeMeasStatCumMonth(MeasStatCumMonthGetRangeRequest measStatCumMonthGetRangeRequest);

    /**
     * 获取累计量年统计数据（单个年份）
     * @param measStatCumYearGetRequest
     *          获取累计量年统计数据请求
     * @return  获取累计量年统计数据回应
     */
    MeasStatCumYearGetResponse getMeasStatCumYear(MeasStatCumYearGetRequest measStatCumYearGetRequest);


    /**
     * 获取累计量年统计数据（年份范围）
     * @param measStatCumYearGetRangeRequest
     *          获取累计量年统计数据请求
     * @return  获取累计量年统计数据回应
     */
    MeasStatCumYearGetRangeResponse getRangeMeasStatCumYear(MeasStatCumYearGetRangeRequest measStatCumYearGetRangeRequest);

    /**
     * 获取瞬时量月统计数据（单个月份） 批量
     * @param measStatInsMonthBatchGetRequest
     *          获取瞬时量月统计数据请求
     * @return  获取瞬时量月统计数据回应
     */
    List<MeasStatInsMonthGetResponse> batchGetMeasStatInsMonth(MeasStatInsMonthBatchGetRequest measStatInsMonthBatchGetRequest);

    /**
     * 获取瞬时量年统计数据（单个年份）批量
     * @param measStatInsYearBatchGetRangeRequest
     *          获取瞬时量年统计数据请求
     * @return  获取瞬时量年统计数据回应
     */
    List<MeasStatInsYearGetResponse> batchGetMeasStatInsYear(MeasStatInsYearBatchGetRequest measStatInsYearBatchGetRangeRequest);

    /**
     * 批量获取瞬时量日统计数据（单个日期）
     * @param measStatInsDayBatchGetRequest
     *          获取瞬时量日统计数据请求
     * @return  获取瞬时量日统计数据回应
     */
    List<MeasStatInsDayGetResponse> batchGetMeasStatInsDay(MeasStatInsDayBatchGetRequest measStatInsDayBatchGetRequest);

    /**
     * 批量获取瞬时量日统计数据（日期范围）
     * @param measStatInsDayBatchGetRangeRequest
     *          获取瞬时量日统计数据请求
     * @return  获取瞬时量日统计数据回应
     */
    List<MeasStatInsDayGetRangeResponse> batchGetRangeMeasStatInsDay(MeasStatInsDayBatchGetRangeRequest measStatInsDayBatchGetRangeRequest);

    /**
     * 批量获取瞬时量月统计数据（月份范围）
     * @param measStatInsMonthBtachGetRangeRequest
     *          获取瞬时量月统计数据请求
     * @return  获取瞬时量月统计数据回应
     */
    List<MeasStatInsMonthGetRangeResponse> batchGetRangeMeasStatInsMonth(MeasStatInsMonthBtachGetRangeRequest measStatInsMonthBtachGetRangeRequest);

    /**
     * 批量获取瞬时量年统计数据（年份范围）
     * @param measStatInsYearBatchGetRangeRequest
     *          获取瞬时量年统计数据请求
     * @return  获取瞬时量年统计数据回应
     */
    List<MeasStatInsYearGetRangeResponse> batchGetRangeMeasStatInsYear(MeasStatInsYearBatchGetRangeRequest measStatInsYearBatchGetRangeRequest);

    /**
     * 批量获取累计量日统计数据（日期范围）
     * @param measStatCumDayBatchGetRangeRequest
     *          获取累计量日统计数据请求
     * @return  获取累计量日统计数据回应
     */
    List<MeasStatCumDayGetRangeResponse> batchGetRangeMeasStatCumDay(MeasStatCumDayBatchGetRangeRequest measStatCumDayBatchGetRangeRequest);

    /**
     * 批量获取累计量月统计数据（月份范围）
     * @param measStatCumMonthBatchGetRangeRequest
     *          获取累计量月统计数据请求
     * @return  获取累计量月统计数据回应
     */
    List<MeasStatCumMonthGetRangeResponse> batchGetRangeMeasStatCumMonth(MeasStatCumMonthBatchGetRangeRequest measStatCumMonthBatchGetRangeRequest);

    /**
     * 批量获取累计量年统计数据（年份范围）
     * @param measStatCumYearBatchGetRangeRequest
     *          获取累计量年统计数据请求
     * @return  获取累计量年统计数据回应
     */
    List<MeasStatCumYearGetRangeResponse> batchGetRangeMeasStatCumYear(MeasStatCumYearBatchGetRangeRequest measStatCumYearBatchGetRangeRequest);
}
