package com.gaea.iesms.bm.datacenter.controller;

import com.gaea.base.core.R;
import com.gaea.iesms.core.feign.request.datacenter.MeasStatInsMonthGetRequest;
import com.gaea.iesms.core.feign.response.datacenter.MeasStatInsMonthGetResponse;
import com.gaea.iesms.core.feign.request.datacenter.MeasStatInsDayGetRequest;
import com.gaea.iesms.core.feign.response.datacenter.MeasStatInsDayGetResponse;
import com.gaea.iesms.bm.datacenter.service.MeasStatService;
import com.gaea.iesms.core.feign.request.datacenter.*;
import com.gaea.iesms.core.feign.response.datacenter.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Set;

/**
 * @description:
 * @author: lifeng.du
 * @email: xxx@xx.com
 * @date: 2023/4/18 10:30
 */
@Api(tags = "量测统计数据")
@RestController
@RequestMapping("/measStat")
public class MeasStatController {

    @Autowired
    private MeasStatService measStatService;


    /**
     * 获取瞬时量日统计数据（单个日期）
     * @param measStatInsDayGetRequest
     *          获取瞬时量日统计数据请求
     * @return  获取瞬时量日统计数据回应
     */
    @ApiOperation(value = "获取瞬时量日统计数据（单个日期）")
    @PostMapping("/getMeasStatInsDay")
    public R<MeasStatInsDayGetResponse> getMeasStatInsDay(@RequestBody MeasStatInsDayGetRequest measStatInsDayGetRequest) {
        MeasStatInsDayGetResponse response=measStatService.getMeasStatInsDay(measStatInsDayGetRequest);
        return R.ok(response);
    }

    /**
     * 批量获取瞬时量日统计数据（单个日期）
     * @param measStatInsDayBatchGetRequest
     *          获取瞬时量日统计数据请求
     * @return  获取瞬时量日统计数据回应
     */
    @ApiOperation(value = "获取瞬时量日统计数据（单个日期）")
    @PostMapping("/batchGetMeasStatInsDay")
    public R<List<MeasStatInsDayGetResponse>> batchGetMeasStatInsDay(@RequestBody MeasStatInsDayBatchGetRequest measStatInsDayBatchGetRequest) {
        List<MeasStatInsDayGetResponse> response=measStatService.batchGetMeasStatInsDay(measStatInsDayBatchGetRequest);
        return R.ok(response);
    }

    /**
     * 获取瞬时量日统计数据（日期范围）
     * @param measStatInsDayGetRangeRequest
     *          获取瞬时量日统计数据请求
     * @return  获取瞬时量日统计数据回应
     */
    @ApiOperation(value = "获取瞬时量日统计数据（日期范围）")
    @PostMapping("/getRangeMeasStatInsDay")
    public R<MeasStatInsDayGetRangeResponse> getRangeMeasStatInsDay(@RequestBody MeasStatInsDayGetRangeRequest measStatInsDayGetRangeRequest) {
        MeasStatInsDayGetRangeResponse response=measStatService.getRangeMeasStatInsDay(measStatInsDayGetRangeRequest);
        return R.ok(response);
    }


    /**
     * 批量获取瞬时量日统计数据（日期范围）
     * @param measStatInsDayBatchGetRangeRequest
     *          获取瞬时量日统计数据请求
     * @return  获取瞬时量日统计数据回应
     */
    @ApiOperation(value = "批量获取瞬时量日统计数据（日期范围）")
    @PostMapping("/batchGetRangeMeasStatInsDay")
    public R<List<MeasStatInsDayGetRangeResponse>> batchGetRangeMeasStatInsDay(@RequestBody MeasStatInsDayBatchGetRangeRequest measStatInsDayBatchGetRangeRequest) {
        List<MeasStatInsDayGetRangeResponse> response=measStatService.batchGetRangeMeasStatInsDay(measStatInsDayBatchGetRangeRequest);
        return R.ok(response);
    }

    /**
     * 获取瞬时量月统计数据（单个月份）
     * @param measStatInsMonthGetRequest
     *          获取瞬时量月统计数据请求
     * @return  获取瞬时量月统计数据回应
     */
    @ApiOperation(value = "获取瞬时量月统计数据（单个月份））")
    @PostMapping("/getMeasStatInsMonth")
    public R<MeasStatInsMonthGetResponse> getMeasStatInsMonth(@RequestBody MeasStatInsMonthGetRequest measStatInsMonthGetRequest) {
        MeasStatInsMonthGetResponse response=measStatService.getMeasStatInsMonth(measStatInsMonthGetRequest);
        return R.ok(response);
    }

    /**
     * 获取瞬时量月统计数据（单个月份） 批量
     * @param measStatInsMonthBatchGetRequest
     *          获取瞬时量月统计数据请求
     * @return  获取瞬时量月统计数据回应
     */
    @ApiOperation(value = "获取瞬时量月统计数据（单个月份））批量")
    @PostMapping("/batchGetMeasStatInsMonth")
    public R<List<MeasStatInsMonthGetResponse>> batchGetMeasStatInsMonth(@RequestBody MeasStatInsMonthBatchGetRequest measStatInsMonthBatchGetRequest) {
        List<MeasStatInsMonthGetResponse> response=measStatService.batchGetMeasStatInsMonth(measStatInsMonthBatchGetRequest);
        return R.ok(response);
    }



    /**
     * 获取瞬时量月统计数据（月份范围）
     * @param measStatInsMonthGetRangeRequest
     *          获取瞬时量月统计数据请求
     * @return  获取瞬时量月统计数据回应
     */
    @ApiOperation(value = "获取瞬时量月统计数据（月份范围）")
    @PostMapping("/getRangeMeasStatInsMonth")
    public R<MeasStatInsMonthGetRangeResponse> getRangeMeasStatInsMonth(@RequestBody MeasStatInsMonthGetRangeRequest measStatInsMonthGetRangeRequest) {
        MeasStatInsMonthGetRangeResponse response=measStatService.getRangeMeasStatInsMonth(measStatInsMonthGetRangeRequest);
        return R.ok(response);
    }


    /**
     * 批量获取瞬时量月统计数据（月份范围）
     * @param measStatInsMonthBtachGetRangeRequest
     *          获取瞬时量月统计数据请求
     * @return  获取瞬时量月统计数据回应
     */
    @ApiOperation(value = "批量获取瞬时量月统计数据（月份范围）")
    @PostMapping("/batchGetRangeMeasStatInsMonth")
    public R<List<MeasStatInsMonthGetRangeResponse>> batchGetRangeMeasStatInsMonth(@RequestBody MeasStatInsMonthBtachGetRangeRequest measStatInsMonthBtachGetRangeRequest) {
        List<MeasStatInsMonthGetRangeResponse> response=measStatService.batchGetRangeMeasStatInsMonth(measStatInsMonthBtachGetRangeRequest);
        return R.ok(response);
    }

    /**
     * 获取瞬时量年统计数据（单个年份）
     * @param measStatInsYearGetRequest
     *          获取瞬时量年统计数据请求
     * @return  获取瞬时量年统计数据回应
     */
    @ApiOperation(value = "获取瞬时量年统计数据（单个年份）")
    @PostMapping("/getMeasStatInsYear")
    public R<MeasStatInsYearGetResponse> getMeasStatInsYear(@RequestBody MeasStatInsYearGetRequest measStatInsYearGetRequest) {
        MeasStatInsYearGetResponse response=measStatService.getMeasStatInsYear(measStatInsYearGetRequest);
        return R.ok(response);
    }


    /**
     * 获取瞬时量年统计数据（单个年份）批量
     * @param measStatInsYearBatchGetRangeRequest
     *          获取瞬时量年统计数据请求
     * @return  获取瞬时量年统计数据回应
     */
    @ApiOperation(value = "批量获取瞬时量年统计数据（单个年份）")
    @PostMapping("/batchGetMeasStatInsYear")
    public R<List<MeasStatInsYearGetResponse>> batchGetMeasStatInsYear(@RequestBody MeasStatInsYearBatchGetRequest measStatInsYearBatchGetRangeRequest) {
        List<MeasStatInsYearGetResponse> response=measStatService.batchGetMeasStatInsYear(measStatInsYearBatchGetRangeRequest);
        return R.ok(response);
    }

    /**
     * 获取瞬时量年统计数据（年份范围）
     * @param measStatInsYearGetRangeRequest
     *          获取瞬时量年统计数据请求
     * @return  获取瞬时量年统计数据回应
     */
    @ApiOperation(value = "获取瞬时量年统计数据（年份范围）")
    @PostMapping("/getRangeMeasStatInsYear")
    public R<MeasStatInsYearGetRangeResponse> getRangeMeasStatInsYear(@RequestBody MeasStatInsYearGetRangeRequest measStatInsYearGetRangeRequest) {
        MeasStatInsYearGetRangeResponse response=measStatService.getRangeMeasStatInsYear(measStatInsYearGetRangeRequest);
        return R.ok(response);
    }

    /**
     * 批量获取瞬时量年统计数据（年份范围）
     * @param measStatInsYearBatchGetRangeRequest
     *          获取瞬时量年统计数据请求
     * @return  获取瞬时量年统计数据回应
     */
    @ApiOperation(value = "批量获取瞬时量年统计数据（年份范围）")
    @PostMapping("/batchGetRangeMeasStatInsYear")
    public R<List<MeasStatInsYearGetRangeResponse>> batchGetRangeMeasStatInsYear(@RequestBody MeasStatInsYearBatchGetRangeRequest measStatInsYearBatchGetRangeRequest) {
        List<MeasStatInsYearGetRangeResponse> response=measStatService.batchGetRangeMeasStatInsYear(measStatInsYearBatchGetRangeRequest);
        return R.ok(response);
    }


    /**
     * 获取累计量日统计数据（单个日期）
     * @param measStatCumDayGetRequest
     *          获取累计量日统计数据请求
     * @return  获取累计量日统计数据回应
     */
    @ApiOperation(value = "获取累计量日统计数据（单个日期）")
    @PostMapping("/getMeasStatCumDay")
    public R<MeasStatCumDayGetResponse> getMeasStatCumDay(@RequestBody MeasStatCumDayGetRequest measStatCumDayGetRequest) {
        MeasStatCumDayGetResponse response=measStatService.getMeasStatCumDay(measStatCumDayGetRequest);
        return R.ok(response);
    }


    /**
     * 获取累计量日统计数据（日期范围）
     * @param measStatCumDayGetRangeRequest
     *          获取累计量日统计数据请求
     * @return  获取累计量日统计数据回应
     */
    @ApiOperation(value = "获取累计量日统计数据（日期范围）")
    @PostMapping("/getRangeMeasStatCumDay")
    public R<MeasStatCumDayGetRangeResponse> getRangeMeasStatCumDay(@RequestBody MeasStatCumDayGetRangeRequest measStatCumDayGetRangeRequest) {
        MeasStatCumDayGetRangeResponse response=measStatService.getRangeMeasStatCumDay(measStatCumDayGetRangeRequest);
        return R.ok(response);
    }


    /**
     * 批量获取累计量日统计数据（日期范围）
     * @param measStatCumDayBatchGetRangeRequest
     *          获取累计量日统计数据请求
     * @return  获取累计量日统计数据回应
     */
    @ApiOperation(value = "批量获取累计量日统计数据（日期范围）")
    @PostMapping("/batchGetRangeMeasStatCumDay")
    public R<List<MeasStatCumDayGetRangeResponse>> batchGetRangeMeasStatCumDay(@RequestBody MeasStatCumDayBatchGetRangeRequest measStatCumDayBatchGetRangeRequest) {
        List<MeasStatCumDayGetRangeResponse> response=measStatService.batchGetRangeMeasStatCumDay(measStatCumDayBatchGetRangeRequest);
        return R.ok(response);
    }


    /**
     * 获取累计量月统计数据（单个月份）
     * @param measStatCumMonthGetRequest
     *          获取累计量月统计数据请求
     * @return  获取累计量月统计数据回应
     */
    @ApiOperation(value = "获取累计量月统计数据（单个月份）")
    @PostMapping("/getMeasStatCumMonth")
    public R<MeasStatCumMonthGetResponse> getMeasStatCumMonth(@RequestBody MeasStatCumMonthGetRequest measStatCumMonthGetRequest) {
        MeasStatCumMonthGetResponse response=measStatService.getMeasStatCumMonth(measStatCumMonthGetRequest);
        return R.ok(response);
    }

    /**
     * 批量获取累计量月统计数据（单个月份）
     * @param measStatCumMonthBatchGetRequest
     *          获取累计量月统计数据请求
     * @return  获取累计量月统计数据回应
     */
    @ApiOperation(value = "获取累计量月统计数据（单个月份）")
    @PostMapping("/batchGetMeasStatCumMonth")
    public R<MeasStatCumMonthBatchGetResponse> batchGetMeasStatCumMonth(@RequestBody MeasStatCumMonthBatchGetRequest measStatCumMonthBatchGetRequest) {
        MeasStatCumMonthBatchGetResponse response=measStatService.batchGetMeasStatCumMonth(measStatCumMonthBatchGetRequest);
        return R.ok(response);
    }

    /**
     * 获取累计量统计量（时间范围） 差值
     * @param measPointIdSet
     * @param measItemCodeSet
     * @param dateMeasStatStart
     * @param dateMeasStatEnd
     * @return
     */
    @ApiOperation(value = "获取累计量统计量（时间范围）")
    @GetMapping("/batchGetMeasStatCumDiff")
    public R<MeasStatCumBatchGetDiffResponse> batchGetMeasStatCumDiff(@RequestParam("measPointIdSet") Set<Long> measPointIdSet
            , @RequestParam("measItemCodeSet") Set<String> measItemCodeSet
            , @RequestParam("dateMeasStatStart") long dateMeasStatStart
            , @RequestParam("dateMeasStatEnd") long dateMeasStatEnd) {
        MeasStatCumBatchGetDiffResponse response = measStatService.batchGetMeasStatCumDiff(measPointIdSet,measItemCodeSet,dateMeasStatStart,dateMeasStatEnd);
        return R.ok(response);
    }


    /**
     * 获取累计量月统计数据（月份范围）
     * @param measStatCumMonthGetRangeRequest
     *          获取累计量月统计数据请求
     * @return  获取累计量月统计数据回应
     */
    @ApiOperation(value = "获取累计量月统计数据（月份范围）")
    @PostMapping("/getRangeMeasStatCumMonth")
    public R<MeasStatCumMonthGetRangeResponse> getRangeMeasStatCumMonth(@RequestBody MeasStatCumMonthGetRangeRequest measStatCumMonthGetRangeRequest) {
        MeasStatCumMonthGetRangeResponse response=measStatService.getRangeMeasStatCumMonth(measStatCumMonthGetRangeRequest);
        return R.ok(response);
    }

    /**
     * 批量获取累计量月统计数据（月份范围）
     * @param measStatCumMonthBatchGetRangeRequest
     *          获取累计量月统计数据请求
     * @return  获取累计量月统计数据回应
     */
    @ApiOperation(value = "批量获取累计量月统计数据（月份范围）")
    @PostMapping("/batchGetRangeMeasStatCumMonth")
    public R<List<MeasStatCumMonthGetRangeResponse>> batchGetRangeMeasStatCumMonth(@RequestBody MeasStatCumMonthBatchGetRangeRequest measStatCumMonthBatchGetRangeRequest) {
        List<MeasStatCumMonthGetRangeResponse> response=measStatService.batchGetRangeMeasStatCumMonth(measStatCumMonthBatchGetRangeRequest);
        return R.ok(response);
    }

    /**
     * 获取累计量年统计数据（单个年份）
     * @param measStatCumYearGetRequest
     *          获取累计量年统计数据请求
     * @return  获取累计量年统计数据回应
     */
    @ApiOperation(value = "获取累计量年统计数据（单个年份）")
    @PostMapping("/getMeasStatCumYear")
    public R<MeasStatCumYearGetResponse> getMeasStatCumYear(@RequestBody MeasStatCumYearGetRequest measStatCumYearGetRequest) {
        MeasStatCumYearGetResponse response=measStatService.getMeasStatCumYear(measStatCumYearGetRequest);
        return R.ok(response);
    }


    /**
     * 获取累计量年统计数据（年份范围）
     * @param measStatCumYearGetRangeRequest
     *          获取累计量年统计数据请求
     * @return  获取累计量年统计数据回应
     */
    @ApiOperation(value = "获取累计量年统计数据（年份范围）")
    @PostMapping("/getRangeMeasStatCumYear")
    public R<MeasStatCumYearGetRangeResponse> getRangeMeasStatCumYear(@RequestBody MeasStatCumYearGetRangeRequest measStatCumYearGetRangeRequest) {
        MeasStatCumYearGetRangeResponse response=measStatService.getRangeMeasStatCumYear(measStatCumYearGetRangeRequest);
        return R.ok(response);
    }

    /**
     * 批量获取累计量年统计数据（年份范围）
     * @param measStatCumYearBatchGetRangeRequest
     *          获取累计量年统计数据请求
     * @return  获取累计量年统计数据回应
     */
    @ApiOperation(value = "批量获取累计量年统计数据（年份范围）")
    @PostMapping("/batchGetRangeMeasStatCumYear")
    public R<List<MeasStatCumYearGetRangeResponse>> batchGetRangeMeasStatCumYear(@RequestBody MeasStatCumYearBatchGetRangeRequest measStatCumYearBatchGetRangeRequest) {
        List<MeasStatCumYearGetRangeResponse> response=measStatService.batchGetRangeMeasStatCumYear(measStatCumYearBatchGetRangeRequest);
        return R.ok(response);
    }

}
