package com.gaea.iesms.bm.datacenter.model.request;

import com.gaea.iesms.bm.datacenter.model.response.RunMeasPointNameAndDescUpdateResponse;
import com.gaea.iesms.core.feign.request.datacenter.BaseRequest;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-04
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RunMeasPointNameAndDescUpdateRequest implements BaseRequest<RunMeasPointNameAndDescUpdateResponse> {

    private static final long serialVersionUID = 7954434637912161648L;

    /**
     * 量测点标识
     */
    private Long measPointId;

    /**
     * 接入量测设备名称
     */
    private String newAccessMeasureName;

    /**
     * 接入量测设备说明
     */
    private String newAccessMeasureDesc;

    @Override
    public Class<RunMeasPointNameAndDescUpdateResponse> getResponseClass() {
        return RunMeasPointNameAndDescUpdateResponse.class;
    }

}
