package com.gaea.iesms.bm.datacenter.task.Schedule;

import com.alibaba.fastjson.JSONObject;
import com.easesource.commons.util.DateUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;

import com.gaea.iesms.bm.datacenter.model.request.RunAccessGatewayQueryRequest;
import com.gaea.iesms.bm.datacenter.model.response.RunAccessGatewayQueryResponse;
import com.gaea.iesms.bm.datacenter.service.AccessMgmtService;
import com.gaea.iesms.bm.datacenter.service.MeasDataService;
import com.gaea.iesms.bm.datacenter.service.MeasDataStoreService;
import com.gaea.iesms.core.feign.request.datacenter.MeasDataLatestBatchGetRequest;
import com.gaea.iesms.core.feign.request.datacenter.RunAccessGatewayGetRequest;
import com.gaea.iesms.core.feign.response.datacenter.*;
import com.gaea.iesms.core.model.entity.datacenter.MeasDataInsFreezeCurveDo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 瞬时曲线定时任务
 */
//@DisallowConcurrentExecution //加上就是不是高并发
@Component(value = "measDataInsFreezeCurveAutoTask")
public class MeasDataInsFreezeCurveAutoTask implements Job {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static final String[] MEAS_ITEM_CODE_ARRAY = new String[] {
            "gen_watt_ua",
            "gen_watt_ub",
            "gen_watt_uc",
            "gen_watt_uab",
            "gen_watt_ubc",
            "gen_watt_uca",
            "gen_watt_kvp",
            "gen_watt_kvn",
            "gen_watt_kvz",
            "gen_watt_ua_deviation",
            "gen_watt_ub_deviation",
            "gen_watt_uc_deviation",
            "gen_watt_u_fluctuate",
            "gen_watt_ua_max_1min",
            "gen_watt_ua_min_1min",
            "gen_watt_ub_max_1min",
            "gen_watt_ub_min_1min",
            "gen_watt_uc_max_1min",
            "gen_watt_uc_min_1min",
            "gen_watt_ia",
            "gen_watt_ib",
            "gen_watt_ic",
            "gen_watt_il",
            "gen_watt_in0",
            "gen_watt_inp",
            "gen_watt_inn",
            "gen_watt_in",
            "gen_watt_acpt",
            "gen_watt_acpa",
            "gen_watt_acpb",
            "gen_watt_acpc",
            "gen_watt_rept",
            "gen_watt_repa",
            "gen_watt_repb",
            "gen_watt_repc",
            "gen_watt_appt",
            "gen_watt_appa",
            "gen_watt_appb",
            "gen_watt_appc",
            "gen_watt_pft",
            "gen_watt_pfa",
            "gen_watt_pfb",
            "gen_watt_pfc",
            "gen_watt_f",
            "gen_watt_tempa",
            "gen_watt_tempb",
            "gen_watt_tempc",
            "gen_watt_tempn",
            "gen_watt_upv1",
            "gen_watt_upv2",
            "gen_watt_upv3",
            "gen_watt_upv4",
            "gen_watt_upv5",
            "gen_watt_upv6",
            "gen_watt_upv7",
            "gen_watt_upv8",
            "gen_watt_upv9",
            "gen_watt_upv10",
            "gen_watt_upv11",
            "gen_watt_upv12",
            "gen_watt_upv13",
            "gen_watt_upv14",
            "gen_watt_upv15",
            "gen_watt_upv16",
            "gen_watt_upv17",
            "gen_watt_upv18",
            "gen_watt_upv19",
            "gen_watt_upv20",
            "gen_watt_upv21",
            "gen_watt_upv22",
            "gen_watt_upv23",
            "gen_watt_upv24",
            "gen_watt_upv25",
            "gen_watt_upv26",
            "gen_watt_upv27",
            "gen_watt_upv28",
            "gen_watt_upv29",
            "gen_watt_upv30",
            "gen_watt_upv31",
            "gen_watt_upv32",
            "gen_watt_ur1",
            "gen_watt_ur2",
            "gen_watt_ur3",
            "gen_watt_ur4",
            "gen_watt_ur5",
            "gen_watt_ur6",
            "gen_watt_ur7",
            "gen_watt_ur8",
            "gen_watt_ur9",
            "gen_watt_ur10",
            "gen_watt_ur11",
            "gen_watt_ur12",
            "gen_watt_ur13",
            "gen_watt_ur14",
            "gen_watt_ur15",
            "gen_watt_ur16",
            "gen_watt_ipv1",
            "gen_watt_ipv2",
            "gen_watt_ipv3",
            "gen_watt_ipv4",
            "gen_watt_ipv5",
            "gen_watt_ipv6",
            "gen_watt_ipv7",
            "gen_watt_ipv8",
            "gen_watt_ipv9",
            "gen_watt_ipv10",
            "gen_watt_ipv11",
            "gen_watt_ipv12",
            "gen_watt_ipv13",
            "gen_watt_ipv14",
            "gen_watt_ipv15",
            "gen_watt_ipv16",
            "gen_watt_ipv17",
            "gen_watt_ipv18",
            "gen_watt_ipv19",
            "gen_watt_ipv20",
            "gen_watt_ipv21",
            "gen_watt_ipv22",
            "gen_watt_ipv23",
            "gen_watt_ipv24",
            "gen_watt_ipv25",
            "gen_watt_ipv26",
            "gen_watt_ipv27",
            "gen_watt_ipv28",
            "gen_watt_ipv29",
            "gen_watt_ipv30",
            "gen_watt_ipv31",
            "gen_watt_ipv32",
            "gen_watt_ir1",
            "gen_watt_ir2",
            "gen_watt_ir3",
            "gen_watt_ir4",
            "gen_watt_ir5",
            "gen_watt_ir6",
            "gen_watt_ir7",
            "gen_watt_ir8",
            "gen_watt_ir9",
            "gen_watt_ir10",
            "gen_watt_ir11",
            "gen_watt_ir12",
            "gen_watt_ir13",
            "gen_watt_ir14",
            "gen_watt_ir15",
            "gen_watt_ir16",
            "gen_watt_ppv1",
            "gen_watt_ppv2",
            "gen_watt_ppv3",
            "gen_watt_ppv4",
            "gen_watt_ppv5",
            "gen_watt_ppv6",
            "gen_watt_ppv7",
            "gen_watt_ppv8",
            "gen_watt_ppv9",
            "gen_watt_ppv10",
            "gen_watt_ppv11",
            "gen_watt_ppv12",
            "gen_watt_ppv13",
            "gen_watt_ppv14",
            "gen_watt_ppv15",
            "gen_watt_ppv16",
            "gen_watt_ppv17",
            "gen_watt_ppv18",
            "gen_watt_ppv19",
            "gen_watt_ppv20",
            "gen_watt_ppv21",
            "gen_watt_ppv22",
            "gen_watt_ppv23",
            "gen_watt_ppv24",
            "gen_watt_ppv25",
            "gen_watt_ppv26",
            "gen_watt_ppv27",
            "gen_watt_ppv28",
            "gen_watt_ppv29",
            "gen_watt_ppv30",
            "gen_watt_ppv31",
            "gen_watt_ppv32",
            "gen_watt_phz",
            "gen_watt_tempivt",
            /*"gen_watt_tempbus",*/
            "gen_watt_ubus",
            "gen_watt_ibus",
            "gen_watt_pbus",
            "gen_watt_pr1",
            "gen_watt_pr2",
            "gen_watt_pr3",
            "gen_watt_pr4",
            "gen_watt_pr5",
            "gen_watt_pr6",
            "gen_watt_pr7",
            "gen_watt_pr8",
            "gen_watt_pr9",
            "gen_watt_pr10",
            "gen_watt_pr11",
            "gen_watt_pr12",
            "gen_watt_pr13",
            "gen_watt_pr14",
            "gen_watt_pr15",
            "gen_watt_pr16",
            "gen_watt_ubp1",
            "gen_watt_ibp1",
            "gen_watt_pbp1",
            "gen_watt_tbp1",
            "gen_watt_socbp1",
            "gen_watt_sohbp1",
            "gen_watt_cibp1",
            "gen_watt_ubp2",
            "gen_watt_ibp2",
            "gen_watt_pbp2",
            "gen_watt_tbp2",
            "gen_watt_socbp2",
            "gen_watt_sohbp2",
            "gen_watt_cibp2",
            "gen_watt_ubp3",
            "gen_watt_ibp3",
            "gen_watt_pbp3",
            "gen_watt_tbp3",
            "gen_watt_socbp3",
            "gen_watt_sohbp3",
            "gen_watt_cibp3",
            "gen_watt_ubp4",
            "gen_watt_ibp4",
            "gen_watt_pbp4",
            "gen_watt_tbp4",
            "gen_watt_socbp4",
            "gen_watt_sohbp4",
            "gen_watt_cibp4",
            "gen_watt_ubp5",
            "gen_watt_ibp5",
            "gen_watt_pbp5",
            "gen_watt_tbp5",
            "gen_watt_socbp5",
            "gen_watt_sohbp5",
            "gen_watt_cibp5",
            "gen_watt_ubp6",
            "gen_watt_ibp6",
            "gen_watt_pbp6",
            "gen_watt_tbp6",
            "gen_watt_socbp6",
            "gen_watt_sohbp6",
            "gen_watt_cibp6",
            "gen_watt_ubp7",
            "gen_watt_ibp7",
            "gen_watt_pbp7",
            "gen_watt_tbp7",
            "gen_watt_socbp7",
            "gen_watt_sohbp7",
            "gen_watt_cibp7",
            "gen_watt_ubp8",
            "gen_watt_ibp8",
            "gen_watt_pbp8",
            "gen_watt_tbp8",
            "gen_watt_socbp8",
            "gen_watt_sohbp8",
            "gen_watt_cibp8",
            "gen_watt_ubp9",
            "gen_watt_ibp9",
            "gen_watt_pbp9",
            "gen_watt_tbp9",
            "gen_watt_socbp9",
            "gen_watt_sohbp9",
            "gen_watt_cibp9",
            "gen_watt_ubp10",
            "gen_watt_ibp10",
            "gen_watt_pbp10",
            "gen_watt_tbp10",
            "gen_watt_socbp10",
            "gen_watt_sohbp10",
            "gen_watt_cibp10",
            "gen_watt_ubp11",
            "gen_watt_ibp11",
            "gen_watt_pbp11",
            "gen_watt_tbp11",
            "gen_watt_socbp11",
            "gen_watt_sohbp11",
            "gen_watt_cibp11",
            "gen_watt_ubp12",
            "gen_watt_ibp12",
            "gen_watt_pbp12",
            "gen_watt_tbp12",
            "gen_watt_socbp12",
            "gen_watt_sohbp12",
            "gen_watt_cibp12",
            "gen_watt_pbt",
            "gen_watt_socbt",
            "gen_watt_sohbt",
            "gen_watt_drivt",
            "gen_watt_effivt",
            "gen_metenv_temp_c01",
            "gen_metenv_temp_c02",
            "gen_metenv_temp_c03",
            "gen_metenv_temp_c04",
            "gen_metenv_temp_c05",
            "gen_metenv_temp_c06",
            "gen_metenv_temp_c07",
            "gen_metenv_temp_c08",
            "gen_metenv_temp_c09",
            "gen_metenv_temp_c10",
            "gen_metenv_temp_c11",
            "gen_metenv_temp_c12",
            "gen_metenv_temp_c13",
            "gen_metenv_temp_c14",
            "gen_metenv_temp_c15",
            "gen_metenv_temp_c16",
            "gen_metenv_temp_c17",
            "gen_metenv_temp_c18",
            "gen_metenv_temp_c19",
            "gen_metenv_temp_c20",
            "gen_metenv_temp_c21",
            "gen_metenv_temp_c22",
            "gen_metenv_temp_c23",
            "gen_metenv_temp_c24",
            "gen_metenv_temp_c25",
            "gen_metenv_temp_c26",
            "gen_metenv_temp_c27",
            "gen_metenv_temp_c28",
            "gen_metenv_temp_c29",
            "gen_metenv_temp_c30",
            "gen_metenv_temp_c31",
            "gen_metenv_temp_c32",
            "gen_metenv_temp_c33",
            "gen_metenv_temp_c34",
            "gen_metenv_temp_c35",
            "gen_metenv_temp_c36",
            "gen_metenv_temp_c37",
            "gen_metenv_temp_c38",
            "gen_metenv_temp_c39",
            "gen_metenv_temp_c40",
            "gen_metenv_temp_c41",
            "gen_metenv_temp_c42",
            "gen_metenv_temp_c43",
            "gen_metenv_temp_c44",
            "gen_metenv_temp_c45",
            "gen_metenv_temp_c46",
            "gen_metenv_temp_c47",
            "gen_metenv_temp_c48",
            "gen_metenv_temp_c49",
            "gen_metenv_temp_c50",
            "gen_metenv_temp_c51",
            "gen_metenv_temp_c52",
            "gen_metenv_temp_c53",
            "gen_metenv_temp_c54",
            "gen_metenv_temp_c55",
            "gen_metenv_temp_c56",
            "gen_metenv_temp_c57",
            "gen_metenv_temp_c58",
            "gen_metenv_temp_c59",
            "gen_metenv_temp_c60",
            /*"gen_heat_hpower",*/
            "gen_heat_wflow",
            "gen_heat_tempws",
            "gen_heat_tempwb",
            "gen_metenv_solirra",
            "gen_metenv_humidity",
            "gen_metenv_temp",
            "gen_metenv_noise",
            "gen_metenv_pm25",
            "gen_metenv_pm10",
            "gen_metenv_pressure",
            "gen_metenv_lux",
            "gen_metenv_co2",
            "gen_metenv_humman_count",
            "gen_metenv_humman_temp_avg",
            "gen_metenv_humman_temp_max",
            "gen_metenv_humman_temp_min",
            "gen_metenv_thermal_temp_avg",
            "gen_metenv_thermal_temp_max",
            "gen_metenv_thermal_temp_min",
            "gen_watt_wp_acpt",
            "gen_watt_wp_i",
            "gen_watt_wp_u",
            "gen_aircond_temp_setting",
            "gen_aircond_temp_return_air",
            "gen_chilled_water_temp_outlet",
            "gen_chilled_water_temp_inlet",
            "gen_cooling_water_temp_outlet",
            "gen_cooling_water_temp_inlet",
            "gen_aircond_cur_load",
            "gen_aircond_cur_load_rate",
            "gen_chilled_water_flow_outlet",
            "gen_chilled_water_flow_inlet",
            "gen_cold_engine_control",
            "gen_aircond_temp_cold_setting",
            "gen_aircond_mode_switch",
            "gen_aircond_temp_heat_setting",
            "gen_watt_acpt_tr",
            "gen_watt_acpt_sr",
            "gen_watt_aircond_acpt",
            "gen_watt_fridge_acpt",
            "gen_watt_television_acpt",
            "gen_watt_washer_acpt",
            "gen_watt_wave_acpt",
            "gen_watt_wave_acpa",
            "gen_watt_wave_acpb",
            "gen_watt_wave_acpc",
            "gen_watt_wave_rept",
            "gen_watt_wave_repa",
            "gen_watt_wave_repb",
            "gen_watt_wave_repc",
            "gen_watt_wave_appt",
            "gen_watt_wave_appa",
            "gen_watt_wave_appb",
            "gen_watt_wave_appc",
            "gen_watt_wave_pft",
            "gen_watt_wave_pfa",
            "gen_watt_wave_pfb",
            "gen_watt_wave_pfc",
            "gen_watt_wave_ia",
            "gen_watt_wave_ib",
            "gen_watt_wave_ic",
            "gen_watt_ia_hc03",
            "gen_watt_ib_hc03",
            "gen_watt_ic_hc03",
            "gen_watt_ia_hc05",
            "gen_watt_ib_hc05",
            "gen_watt_ic_hc05",
            "gen_watt_ia_hc07",
            "gen_watt_ib_hc07",
            "gen_watt_ic_hc07",
            "gen_watt_ia_hc09",
            "gen_watt_ib_hc09",
            "gen_watt_ic_hc09",
            "gen_watt_wave_anglea",
            "gen_watt_wave_angleb",
            "gen_watt_wave_anglec",
            "gen_watt_anglea_hc03",
            "gen_watt_angleb_hc03",
            "gen_watt_anglec_hc03",
            "gen_watt_anglea_hc05",
            "gen_watt_angleb_hc05",
            "gen_watt_anglec_hc05",
            "gen_watt_anglea_hc07",
            "gen_watt_angleb_hc07",
            "gen_watt_anglec_hc07",
            "gen_watt_anglea_hc09",
            "gen_watt_angleb_hc09",
            "gen_watt_anglec_hc09",
            "gen_watt_fre",
            "gen_watt_di1",
            "gen_watt_di2",
            "gen_watt_di3",
            "gen_watt_di4",
            "gen_watt_di5",
            "gen_watt_di6",
            "gen_watt_di7",
            "gen_watt_di8",
            "gen_watt_di9",
            "gen_watt_di10",
            "gen_watt_di11",
            "gen_watt_di12",
            "gen_watt_di13",
            "gen_watt_di14",
            "gen_watt_di15",
            "gen_watt_di16",
            "gen_watt_di17",
            "gen_watt_di18",
            "gen_watt_di19",
            "gen_watt_di20",
            "gen_watt_di21",
            "gen_watt_di22",
            "gen_watt_di23",
            "gen_watt_di24",
            "gen_watt_di25",
            "gen_watt_di26",
            "gen_watt_di27",
            "gen_watt_di28",
            "gen_watt_di29",
            "gen_watt_di30",
            "gen_watt_di31",
            "gen_watt_di32",
            "jf_max",
            "jf_avg",
            "jf_fuis",
            "cy_map_data",
            "lw_max",
            "lw_avg",
            "gen_watt_res",
            "gen_on_tempa",
            "gen_on_tempb",
            "gen_on_tempc",
            "gen_under_tempa",
            "gen_under_tempb",
            "gen_under_tempc",
            "gen_cable_tempa",
            "gen_cable_tempb",
            "gen_cable_tempc",
            "change_is_disStatus",
            "run_status",
            "soc_one",
            "soc_tow",
            "soc_three",
            "one_first_order_alarm",
            "one_secondary_alarm",
            "one_three_level_alarm",
            "tow_first_order_alarm",
            "tow_second_level_alarm",
            "tow_three_level_alarm",
            "three_first_order_alarm",
            "three_second_level_alarm",
            "three_three_level_alarm",
            "seven_status",
            "six_status",
            "by_pass_one_status",
            "ab_communication_voltage",
            "bc_communication_voltage",
            "ca_communication_voltage",
            "a_item_electric_current",
            "b_item_electric_current",
            "c_item_electric_current",
            "ac_frequency",
            "a_phase_ac_active_power",
            "b_phase_ac_active_power",
            "c_phase_ac_active_power",
            "ahase_ac_reactive_power",
            "bhase_ac_reactive_power",
            "chase_ac_reactive_power",
            "a_phase_ac_apparent_power",
            "b_phase_ac_apparent_power",
            "c_phase_ac_apparent_power",
            "a_phase_ac_power_factor",
            "b_phase_ac_power_factor",
            "c_phase_ac_power_factor",
            "and_off_grid_mode",
            "energy_scheduling_model",
            "starting_mode",
            "power_factor_setting",
            "active_power_settings",
            "reactive_power_settings",
            "dc_control_mode",
            "dc_power_setting",
            "dc_lower_limit_voltage",
            "discharge_termination_voltage",
            "equalizing_voltage",
            "charging_cutoff_current",
            "maximum_charging_current",
            "maximum_discharge_current",
            "system_boot",
            "system_shutdown",
            "one_power",
            "one_voltage",
            "one_elcnt",
            "one_all_charging",
            "one_dis_charging",
            "one_dc_control_mode",
            "one_dc_current_setting",
            "one_dc_power_setting",
            "tow_power",
            "tow_voltage",
            "tow_elcnt",
            "tow_all_charging",
            "tow_dis_charging",
            "tow_dc_control_mode",
            "tow_dc_current_setting",
            "tow_dc_power_setting",
            "three_power",
            "three_voltage",
            "three_one_elcnt",
            "three_all_charging",
            "three_dis_charging",
            "three_dc_control_mode",
            "three_dc_current_setting",
            "three_dc_power_setting",
            "actual_empty_voltage",
            "actualempty_change_is_dis_status",
            "actualempty_power",
            "empty_positive_active_total",
            "empty_total_inverse_active_power",
            "fan_actual_voltage",
            "fan_change_is_dis_status",
            "fan_actual_power",
            "fan_positive_active_total",
            "fan_total_inverse_active_power",
            "dcdc_voltage",
            "dcdc_elcnt"
    };

    @Resource(name = "accessMgmtService")
    private AccessMgmtService accessMgmtService;

    @Resource(name = "measDataService")
    private MeasDataService measDataService;

    @Resource(name = "measDataStoreService")
    private MeasDataStoreService measDataStoreService;

    @Resource(name = "pool")
    private ThreadPoolExecutor poolExecutor;

    public MeasDataInsFreezeCurveAutoTask() {
    }

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap dataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        Set<String> orgNoSet = (Set<String>) dataMap.get("orgNoSet");
        logger.info(">>>>>>> orgNoSet >>>> {}", JSONObject.toJSON(orgNoSet));
        Date now = new Date();
        final long gmtFreeze = DateConvertUtils.convertFromString(DateConvertUtils.convertToString(now, "yyyy-MM-dd HH:mm"), "yyyy-MM-dd HH:mm").getTime();
        for(String orgNo : orgNoSet) {
            RunAccessGatewayQueryResponse runAccessGatewayQueryResponse = accessMgmtService.queryRunAccessGateway(new RunAccessGatewayQueryRequest(null, Sets.newHashSet(orgNo), null, null, null, null, null, null, null, null, null, null, null, null));
            if(runAccessGatewayQueryResponse.isSuccess() && runAccessGatewayQueryResponse.getRunAccessGatewayList().size() > 0) {
                for(final RunAccessGatewayVo runAccessGatewayVo : runAccessGatewayQueryResponse.getRunAccessGatewayList()) {
                    poolExecutor.execute(new FreezeTask(gmtFreeze, runAccessGatewayVo));
                }
            }
        }
    }

    private class FreezeTask implements Runnable {

        private final long gmtFreeze;
        private final RunAccessGatewayVo runAccessGatewayVo;

        public FreezeTask(long gmtFreeze, RunAccessGatewayVo runAccessGatewayVo) {
            this.gmtFreeze = gmtFreeze;
            this.runAccessGatewayVo = runAccessGatewayVo;
        }

        @Override
        public void run() {
            try {
                RunAccessGatewayGetResponse runAccessGatewayGetResponse = accessMgmtService.getRunAccessGateway(new RunAccessGatewayGetRequest(runAccessGatewayVo.getId(), null, null, null, null, null, null, null));
                if(runAccessGatewayGetResponse.isSuccess() && runAccessGatewayGetResponse.getRunMeasPointList().size() > 0) {
                    Set<Long> measPointIdSet = runAccessGatewayGetResponse.getRunMeasPointList().stream().map(RunMeasPointVo::getId).collect(Collectors.toSet());
                    MeasDataLatestBatchGetRequest measDataLatestBatchGetRequest = new MeasDataLatestBatchGetRequest();
                    measDataLatestBatchGetRequest.setMeasPointIdSet(measPointIdSet);
                    measDataLatestBatchGetRequest.setMeasItemCodeSet(new HashSet<>(Arrays.asList(MEAS_ITEM_CODE_ARRAY)));
                    measDataLatestBatchGetRequest.setGmtMeasDataLatest(DateUtils.addMonths(new Date(), -6).getTime());
                    MeasDataLatestBatchGetResponse measDataLatestBatchGetResponse = measDataService.batchGetMeasDataLatest(measDataLatestBatchGetRequest);
                    if(measDataLatestBatchGetResponse!=null) {
                        Map<Long, Map<String, MeasDataLatestInfo>> batchMeasDataMap = measDataLatestBatchGetResponse.getBatchMeasDataMap();
                        if(batchMeasDataMap != null) {
                            List<MeasDataInsFreezeCurveDo> measDataInsFreezeCurveDoList = Lists.newArrayList();
                            batchMeasDataMap.forEach((measPointId, measDataMap) -> {
                                measDataMap.forEach((measItemCode, measDataLatestInfo) -> {
                                    long interval = (gmtFreeze - measDataLatestInfo.getGmtMeasDataLatest());
                                    if(interval >= 60 * 60 * 1000) {
                                        measDataLatestInfo.setMeasDataValue(new BigDecimal("0.0"));
                                        measDataLatestInfo.setGmtMeasDataLatest(gmtFreeze);
                                        measDataLatestInfo.setMeasDataSource(4);
                                        measDataStoreService.updateMeasDataLatest(measPointId, measItemCode, JsonConvertUtils.convertFromString(JsonConvertUtils.convertToString(measDataLatestInfo), Map.class));
                                    }
                                    MeasDataInsFreezeCurveDo measDataInsFreezeCurveDo = new MeasDataInsFreezeCurveDo();
                                    measDataInsFreezeCurveDo.setMeasPointId(measPointId);
                                    measDataInsFreezeCurveDo.setMeasItemCode(measItemCode);
                                    measDataInsFreezeCurveDo.setGmtMeasFreeze(gmtFreeze);
                                    measDataInsFreezeCurveDo.setMeasDataValue((BigDecimal) measDataLatestInfo.getMeasDataValue());
                                    measDataInsFreezeCurveDo.setMeasDataRate(new BigDecimal("1.0"));
                                    measDataInsFreezeCurveDo.setMeasDataSource(0);
                                    measDataInsFreezeCurveDo.setGmtMeasData(measDataLatestInfo.getGmtMeasDataLatest());
                                    measDataInsFreezeCurveDo.setFreezeMode(0);
                                    measDataInsFreezeCurveDo.setGmtCreate(System.currentTimeMillis());
                                    measDataInsFreezeCurveDo.setGmtModified(System.currentTimeMillis());
                                    measDataInsFreezeCurveDoList.add(measDataInsFreezeCurveDo);
                                });
                                //logger.info("ins数据 >>>终端id：{} 量测点标识 {} 量测项id： {}", runAccessGatewayVo.getId(), measDataMap.keySet(), measPointId);
                            });
                            List<List<MeasDataInsFreezeCurveDo>> partList = Lists.partition(measDataInsFreezeCurveDoList, 50);
                            for (List<MeasDataInsFreezeCurveDo> list : partList) {
                                measDataStoreService.batchInsertOrUpdateMeasDataInsFreezeCurve(list);
                                Thread.sleep(10);
                            }
                            //partList.forEach(list -> measDataStoreService.batchInsertOrUpdateMeasDataInsFreezeCurve(list));
                        }
                    }
                }
                Thread.sleep(10); //让任务执行慢点
            }
            catch(InterruptedException e) {
                logger.error(e.getMessage(), e.fillInStackTrace());
            }
        }

        public long getGmtFreeze() {
            return gmtFreeze;
        }

        public RunAccessGatewayVo getRunAccessGatewayVo() {
            return runAccessGatewayVo;
        }

        @Override
        public String toString() {
            return "FreezeTask{" +
                    "gmtFreeze=" + gmtFreeze +
                    ", runAccessGatewayVo=" + runAccessGatewayVo +
                    '}';
        }
    }

}