package com.gaea.iesms.bm.datacenter.model.request;

import com.gaea.iesms.bm.datacenter.model.response.RunAccessGatewayRunStatusUpdateResponse;
import com.gaea.iesms.core.feign.request.datacenter.BaseRequest;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-04
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RunAccessGatewayRunStatusUpdateRequest implements BaseRequest<RunAccessGatewayRunStatusUpdateResponse> {

    private static final long serialVersionUID = -3016938452002699074L;

    /**
     * 接入设备标识 devAccessId
     * 或
     * 系统单位编号 orgNo && 接入设备分类编号 devAccessSortNo && 接入设备编号 devAccessNo
     * 或
     * 接入网关设备所属产品 productKey && 接入网关设备客户端标识 clientId
     * 或
     * 接入网关设备所属产品 productKey && 上行通讯规约 upcommProto && 上行通讯规约 upcommLogicAddr
     *
     * 以上三组必须选择一组参数
     *
     */
    private Long devAccessId;
    private String orgNo;
    private String devAccessSortNo;
    private String devAccessNo;
    private String productKey;
    private String clientId;
    private String upcommProto;
    private String upcommLogicAddr;

    /**
     * @see DevRunStatusEnum
     */
    private int runStatus;

    @Override
    public Class<RunAccessGatewayRunStatusUpdateResponse> getResponseClass() {
        return RunAccessGatewayRunStatusUpdateResponse.class;
    }

}
