package com.gaea.iesms.bm.datacenter.service.impl;

import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.gaea.iesms.bm.datacenter.utils.DataWarehouse;
import com.gaea.iesms.core.model.entity.datacenter.GmDevMeterSynchronizerDo;
import com.gaea.iesms.core.model.entity.datacenter.MeasDataCumFreezeCurveDo;
import com.gaea.iesms.core.model.entity.datacenter.MeasDataInsFreezeCurveDo;
import com.gaea.iesms.core.model.entity.datacenter.MeasDataLatestDo;
import com.gaea.iesms.bm.datacenter.mapper.MeasDataCumFreezeCurveDao;
import com.gaea.iesms.bm.datacenter.mapper.MeasDataInsFreezeCurveDao;
import com.gaea.iesms.bm.datacenter.mapper.MeasDataLatestSynchronizerDao;
import com.gaea.iesms.bm.datacenter.model.response.MeasDataLatestVo;
import com.gaea.iesms.bm.datacenter.service.AbstractBaseService;
import com.gaea.iesms.bm.datacenter.service.MeasDataStoreService;
import com.gaea.iesms.bm.datacenter.utils.MeasLatestOperator;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 *
 * @author Nick Zhang
 */
@Service(value = "measDataStoreService")
public class MeasDataStoreServiceImpl extends AbstractBaseService implements MeasDataStoreService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private MeasDataCumFreezeCurveDao measDataCumFreezeCurveDao;

    @Resource
    private MeasDataInsFreezeCurveDao measDataInsFreezeCurveDao;

    @Resource
    private MeasDataLatestSynchronizerDao measDataLatestSynchronizerDao;

    @Resource
    private DataWarehouse dataWarehouse;

    @Override
    public void updateMeasDataLatest(Long measPointId, String measItemCode, Map<String, Object> measDataInfo) {
        //MeasDataLatestVo measDataLatestVo = redisOperator.getMeasDataLatest(measPointId, measItemCode);
        MeasDataLatestVo measDataLatestVo = DataWarehouse.getMeasDataLatest(measPointId, measItemCode);
        GmDevMeterSynchronizerDo gmDevMeterSynchronizerDo = measDataLatestSynchronizerDao.getRate(measPointId);
        if (measDataLatestVo == null) {
            measDataLatestVo = new MeasDataLatestVo();
            measDataLatestVo.setId(datacenterDataIdGenerator.nextId());
            if (gmDevMeterSynchronizerDo != null) {
                measDataLatestVo.setSelfRate(gmDevMeterSynchronizerDo.getSelfRate());
                measDataLatestVo.setCtRate(gmDevMeterSynchronizerDo.getCtRate());
                measDataLatestVo.setPtRate(gmDevMeterSynchronizerDo.getPtRate());
            }
            measDataLatestVo.setGmtCreate(System.currentTimeMillis());
        }
        if (gmDevMeterSynchronizerDo != null) {
            measDataLatestVo.setSelfRate(gmDevMeterSynchronizerDo.getSelfRate());
            measDataLatestVo.setCtRate(gmDevMeterSynchronizerDo.getCtRate());
            measDataLatestVo.setPtRate(gmDevMeterSynchronizerDo.getPtRate());
        }
        measDataLatestVo.setMeasPointId(measPointId);
        measDataLatestVo.setMeasItemCode(measItemCode);
        measDataLatestVo.setMeasDataInfo(JsonConvertUtils.convertToString(measDataInfo));
        measDataLatestVo.setGmtModified(System.currentTimeMillis());
        DataWarehouse.updateMeasDataLatest(measDataLatestVo);
    }

    @Override
    public void batchUpdateMeasDataLatest(Map<String, Map<String, Map<String, Object>>> batchMeasDataInfosMap) {
        if(batchMeasDataInfosMap == null) {
            return;
        }
        Map<String, Map<String, Object>> batchmap = Maps.newHashMap();
        Set<String> measPointIdSet = batchMeasDataInfosMap.keySet();
        Set<String> measItemCodeSet = Sets.newHashSet();
        for(String measPointId : batchMeasDataInfosMap.keySet()) {
//            System.out.println( batchMeasDataInfosMap.get(measPointId));
            Map<String, Map<String, Object>> insideMap = batchMeasDataInfosMap.get(measPointId);
            if(insideMap != null) {
                for(String measItemCode : insideMap.keySet()) {
                    measItemCodeSet.add(measItemCode);
                    Map<String, Object> measDataInfo = insideMap.get(measItemCode);
                    if(measDataInfo != null) {
                        batchmap.put(measPointId + "#" + measItemCode, measDataInfo);
                    }
                }
            }
        }
        List<MeasDataLatestDo> measDataLatestDoList = Lists.newArrayList();
        if(measPointIdSet.size() > 0 && measItemCodeSet.size() > 0) {
            measDataLatestDoList = DataWarehouse.getListByMeasPointIdSetAndMeasItemCodeSet(measPointIdSet, measItemCodeSet);
        }
        List<MeasDataLatestDo> results = Lists.newArrayList();
        Map<String, MeasDataLatestDo> batchmap2 = Maps.newHashMap();
        if (measDataLatestDoList != null) {
            measDataLatestDoList.forEach(measDataLatestDo -> batchmap2.put(measDataLatestDo.getMeasPointId() + "#" + measDataLatestDo.getMeasItemCode(), measDataLatestDo));
        }

        batchmap.forEach((k, v) -> {
            if (batchmap2.size() == 0) {
                String[] ss = k.split("#");
                MeasDataLatestDo md = null;
                if(ss.length == 2) {
                    md = new MeasDataLatestDo();
                    md.setId(datacenterDataIdGenerator.nextId());
                    md.setMeasPointId(Long.valueOf(ss[0]));
                    md.setMeasItemCode(ss[1]);
                    md.setMeasDataInfo(JsonConvertUtils.convertToString(v));
                    md.setGmtCreate(System.currentTimeMillis());
                    md.setGmtModified(System.currentTimeMillis());
                }
                if(md != null) {
                    results.add(md);
                }

            } else {
                MeasDataLatestDo md = batchmap2.get(k);
                if(md != null) {
                    md.setMeasDataInfo(JsonConvertUtils.convertToString(v));
                    md.setGmtModified(System.currentTimeMillis());
                }
                else {
                    String[] ss = k.split("#");
                    if(ss.length == 2) {
                        md = new MeasDataLatestDo();
                        md.setId(datacenterDataIdGenerator.nextId());
                        md.setMeasPointId(Long.valueOf(ss[0]));
                        md.setMeasItemCode(ss[1]);
                        md.setMeasDataInfo(JsonConvertUtils.convertToString(v));
                        md.setGmtCreate(System.currentTimeMillis());
                        md.setGmtModified(System.currentTimeMillis());
                    }
                }
                if(md != null) {
                    results.add(md);
                }
            }

        });
        if(results.size() > 0) {
            for (MeasDataLatestDo latestDo : results) {
                dataWarehouse.insertmeasLatest(latestDo);
            }
        }
    }

    @Override
    public void deleteMeasDataLatest(Long measPointId, String measItemCode) {
        DataWarehouse.deleteByMeasPointIdAndMeasItemCode(measPointId, measItemCode);
    }

    @Override
    public void insertOrUpdateMeasDataCumFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze, BigDecimal measDataValue, BigDecimal measDataRate, int measDataSource, long gmtMeasData, int freezeMode) {
        MeasDataCumFreezeCurveDo measDataCumFreezeCurveDo = new MeasDataCumFreezeCurveDo();
        measDataCumFreezeCurveDo.setId(datacenterDataIdGenerator.nextId());
        measDataCumFreezeCurveDo.setMeasPointId(measPointId);
        measDataCumFreezeCurveDo.setMeasItemCode(measItemCode);
        measDataCumFreezeCurveDo.setGmtMeasFreeze(gmtMeasFreeze);
        measDataCumFreezeCurveDo.setMeasDataValue(measDataValue);
        measDataCumFreezeCurveDo.setMeasDataRate(measDataRate);
        measDataCumFreezeCurveDo.setMeasDataSource(measDataSource);
        measDataCumFreezeCurveDo.setGmtMeasData(gmtMeasData);
        measDataCumFreezeCurveDo.setFreezeMode(freezeMode);
        measDataCumFreezeCurveDo.setGmtCreate(System.currentTimeMillis());
        measDataCumFreezeCurveDo.setGmtModified(System.currentTimeMillis());
        measDataCumFreezeCurveDao.insert(measDataCumFreezeCurveDo);
    }

    @Override
    public void batchInsertOrUpdateMeasDataCumFreezeCurve(List<MeasDataCumFreezeCurveDo> measDataCumFreezeCurveDoList) {
        List<MeasDataCumFreezeCurveDo> results = Lists.newArrayList();
        measDataCumFreezeCurveDoList.forEach(m -> {
            if(m.getId() == null || m.getId() == 0L) {
                m.setId(datacenterDataIdGenerator.nextId());
                results.add(m);
            }
        });
        measDataCumFreezeCurveDao.batchInsertOrUpdate(results);
    }


    @Override
    public void insertOrUpdateMeasDataInsFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze, BigDecimal measDataValue, BigDecimal measDataRate, int measDataSource, long gmtMeasData, int freezeMode) {
        MeasDataInsFreezeCurveDo measDataInsFreezeCurveDo = new MeasDataInsFreezeCurveDo();
        measDataInsFreezeCurveDo.setId(datacenterDataIdGenerator.nextId());
        measDataInsFreezeCurveDo.setMeasPointId(measPointId);
        measDataInsFreezeCurveDo.setMeasItemCode(measItemCode);
        measDataInsFreezeCurveDo.setGmtMeasFreeze(gmtMeasFreeze);
        measDataInsFreezeCurveDo.setMeasDataValue(measDataValue);
        measDataInsFreezeCurveDo.setMeasDataRate(measDataRate);
        measDataInsFreezeCurveDo.setMeasDataSource(measDataSource);
        measDataInsFreezeCurveDo.setGmtMeasData(gmtMeasData);
        measDataInsFreezeCurveDo.setFreezeMode(freezeMode);
        measDataInsFreezeCurveDo.setGmtCreate(System.currentTimeMillis());
        measDataInsFreezeCurveDo.setGmtModified(System.currentTimeMillis());
        measDataInsFreezeCurveDao.insert(measDataInsFreezeCurveDo);
    }

    @Override
    public void batchInsertOrUpdateMeasDataInsFreezeCurve(List<MeasDataInsFreezeCurveDo> measDataInsFreezeCurveDoList) {
        List<MeasDataInsFreezeCurveDo> results = Lists.newArrayList();
        measDataInsFreezeCurveDoList.forEach(m -> {
            if(m.getId() == null || m.getId() == 0L) {
                m.setId(datacenterDataIdGenerator.nextId());
                results.add(m);
            }
        });
        measDataInsFreezeCurveDao.batchInsertOrUpdate(results);
    }


}
