package com.gaea.iesms.bm.datacenter.utils;


import com.gaea.iesms.bm.datacenter.mapper.MeasDataLatestSynchronizerDao;
import com.gaea.iesms.bm.datacenter.model.response.MeasDataLatestVo;
import com.gaea.iesms.core.model.entity.datacenter.GmDevMeterSynchronizerDo;
import com.gaea.iesms.core.model.entity.datacenter.MeasDataLatestDo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 数据仓
 */
@Component
@Slf4j
public class DataWarehouse {



    @Resource
    private MeasDataLatestSynchronizerDao measDataLatestSynchronizerDao;


    /**
     * map存储
     */
    private static final ConcurrentHashMap<Long, ConcurrentHashMap<String, MeasDataLatestVo>> dataMap = new ConcurrentHashMap<>(2500);

    public static MeasDataLatestVo getMeasDataLatest(Long measPointId, String measItemCode) {
        Map<String, MeasDataLatestVo> map = dataMap.getOrDefault(measPointId, null);
        if (map != null) {
            return map.getOrDefault(measItemCode, null);
        }
        return null;
    }

    public static void updateMeasDataLatest(MeasDataLatestVo measDataLatestVo) {
        ConcurrentHashMap<String, MeasDataLatestVo> map = dataMap.getOrDefault(measDataLatestVo.getMeasPointId(), null);
        if (map != null) {
            if (map.containsKey(measDataLatestVo.getMeasItemCode())) {
                map.replace(measDataLatestVo.getMeasItemCode(), measDataLatestVo);
            } else {
                map.put(measDataLatestVo.getMeasItemCode(), measDataLatestVo);
            }
            dataMap.replace(measDataLatestVo.getMeasPointId(), map);
        } else {
            map = new ConcurrentHashMap<>();
            map.put(measDataLatestVo.getMeasItemCode(), measDataLatestVo);
            dataMap.put(measDataLatestVo.getMeasPointId(), map);
        }
    }

    public static List<MeasDataLatestDo> getListByMeasPointIdSetAndMeasItemCodeSet(Set<String> measPointIdSet, Set<String> measItemCodeSet) {
        List<MeasDataLatestDo> list = new ArrayList<>();
        for (String measPointId : measPointIdSet) {
            Map<String, MeasDataLatestVo> map = dataMap.getOrDefault(measPointId, null);
            if (map != null) {
                map.forEach((key, value) -> {
                    if (measItemCodeSet.contains(key)) {
                        MeasDataLatestDo latestDo = new MeasDataLatestDo();
                        latestDo.setId(value.getId());
                        latestDo.setMeasPointId(value.getMeasPointId());
                        latestDo.setMeasItemCode(value.getMeasItemCode());
                        latestDo.setMeasDataInfo(value.getMeasDataInfo());
                        latestDo.setGmtCreate(value.getGmtCreate());
                        latestDo.setGmtModified(value.getGmtModified());
                        list.add(latestDo);
                    }
                });
            }
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    public static void deleteByMeasPointIdAndMeasItemCode(Long measPointId, String measItemCode) {
        ConcurrentHashMap<String, MeasDataLatestVo> map = dataMap.getOrDefault(measPointId, null);
        if (measPointId != null) {
            map.remove(measItemCode);
        }

    }

    public static List<MeasDataLatestVo> getMeasDataLatestVoListByMeasPointIdSetAndMeasItemCodeSet(Set<Long> newHashSet, Set<String> measItemCodeSet, Long gmtMeasDataLatest) {
        List<MeasDataLatestVo> list = new ArrayList<>();
        for (Long measPointId : newHashSet) {
            Map<String, MeasDataLatestVo> map =  dataMap.getOrDefault(measPointId, null);
            if (map != null) {
                map.forEach((key, value) -> {
                    if (measItemCodeSet.contains(key)) {
                        if (gmtMeasDataLatest != null && gmtMeasDataLatest > 0) {
                            if (value.getGmtModified() > gmtMeasDataLatest) {
                                list.add(value);
                            }
                        } else {
                            list.add(value);
                        }
                    }
                });
            }
        }
        if (list.size() == 0) {
            return null;
        }
        return list;

    }

    public void insertmeasLatest(MeasDataLatestDo latestDo) {
        ConcurrentHashMap<String, MeasDataLatestVo> map = dataMap.getOrDefault(latestDo.getMeasPointId(), null);
        if (map != null) {
            MeasDataLatestVo vo = map.getOrDefault(latestDo.getMeasItemCode(), null);
            if (vo != null) {
                vo.setMeasDataInfo(latestDo.getMeasDataInfo());
                vo.setGmtModified(latestDo.getGmtModified());
                updateVoRate(vo);
                map.replace(latestDo.getMeasItemCode(), vo);
                dataMap.replace(latestDo.getMeasPointId(), map);
            } else {
                MeasDataLatestVo measDataLatestVo = doToMeasDataLatestVo(latestDo);
                map.put(measDataLatestVo.getMeasItemCode(), measDataLatestVo);
                dataMap.replace(measDataLatestVo.getMeasPointId(), map);
            }
        } else {
            MeasDataLatestVo measDataLatestVo = doToMeasDataLatestVo(latestDo);
            map = new ConcurrentHashMap<>();
            map.put(measDataLatestVo.getMeasItemCode(), measDataLatestVo);
            dataMap.put(measDataLatestVo.getMeasPointId(), map);
        }
    }



    public MeasDataLatestVo doToMeasDataLatestVo(MeasDataLatestDo latestDo) {
        MeasDataLatestVo vo = new MeasDataLatestVo();
        vo.setId(latestDo.getId());
        vo.setMeasPointId(latestDo.getMeasPointId());
        vo.setMeasItemCode(latestDo.getMeasItemCode());
        vo.setMeasDataInfo(latestDo.getMeasDataInfo());
        vo.setGmtCreate(latestDo.getGmtCreate());
        vo.setGmtModified(latestDo.getGmtModified());
        updateVoRate(vo);
        return vo;
    }


    public void updateVoRate(MeasDataLatestVo vo) {
        GmDevMeterSynchronizerDo gmDevMeterSynchronizerDo = measDataLatestSynchronizerDao.getRate(vo.getMeasPointId());
        if (gmDevMeterSynchronizerDo != null) {
            vo.setSelfRate(gmDevMeterSynchronizerDo.getSelfRate());
            vo.setCtRate(gmDevMeterSynchronizerDo.getCtRate());
            vo.setPtRate(gmDevMeterSynchronizerDo.getPtRate());
        }
    }

}
