package com.gaea.iesms.bm.datacenter.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.gaea.base.core.R;
import com.gaea.iesms.core.feign.request.datacenter.*;
import com.gaea.iesms.core.feign.request.datacenter.GmDevTermRegisterRequest;
import com.gaea.iesms.core.feign.request.datacenter.GmDevTermModifyRequest;
import com.gaea.iesms.core.feign.request.datacenter.GmDevTermCancelRequest;
import com.gaea.iesms.core.feign.response.datacenter.*;
import com.gaea.iesms.core.model.entity.datacenter.RunMeasPointDo;
import com.gaea.iesms.bm.datacenter.service.AccessMgmtService;
import com.gaea.iesms.bm.datacenter.service.DevAccessRegisterService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @description: 接入设备注册服务
 * @author: lifeng.du
 * @email: xxx@xx.com
 * @date: 2023/4/18 9:47
 */
@Api(tags = "接入设备注册服务")
@RestController
@RequestMapping("/devAccessRegister")
public class DevAccessRegisterController {

    @Autowired
    private DevAccessRegisterService devAccessRegisterService;

    @Autowired
    private AccessMgmtService accessMgmtService;


    /**
     * 查詢终端
     * @param getRequest
     * @return
     */
    @ApiOperation(value = "查詢终端")
    @PostMapping("/getRegisteredDevAccessGateway")
    public R<RegisteredDevAccessGatewayGetResponse> getRegisteredDevAccessGateway(@RequestBody RegisteredDevAccessGatewayGetRequest getRequest) {
        RegisteredDevAccessGatewayGetResponse response=devAccessRegisterService.getRegisteredDevAccessGateway(getRequest);
        return R.ok(response);
    }


    /**
     *
     * @param registerRequest
     * @return
     */
    @ApiOperation(value = "新增终端")
    @PostMapping("/registerNewDevAccessGateway")
    public R<NewDevAccessGatewayRegisterResponse> registerNewDevAccessGateway(@RequestBody NewDevAccessGatewayRegisterRequest registerRequest) {
        NewDevAccessGatewayRegisterResponse response=devAccessRegisterService.registerNewDevAccessGateway(registerRequest);
        return R.ok(response);
    }

    /**
     * 新增终端
     * @param gmDevTermRegisterRequest
     * @return
     */
    @ApiOperation(value = "新增终端")
    @PostMapping("/registerGmDevTerm")
    public R<GmDevTermRegisterResponse> registerGmDevTerm(@RequestBody GmDevTermRegisterRequest gmDevTermRegisterRequest) {
        return devAccessRegisterService.registerGmDevTerm(gmDevTermRegisterRequest);
    }


    /**
     * 编辑终端
     * @param modifyRequest
     * @return
     */
    @ApiOperation(value = "编辑终端")
    @PostMapping("/modifyGmDevTerm")
    public R<GmDevTermModifyResponse> modifyGmDevTerm(@RequestBody GmDevTermModifyRequest modifyRequest) {
        return devAccessRegisterService.modifyGmDevTerm(modifyRequest);
    }


    /**
     * 删除终端
     * @param cancelRequest
     * @return
     */
    @ApiOperation(value = "删除终端")
    @PostMapping("/cancelGmDevTerm")
    public R<GmDevTermCancelResponse> cancelGmDevTerm(@RequestBody GmDevTermCancelRequest cancelRequest) {
        R<GmDevTermCancelResponse> response=devAccessRegisterService.cancelGmDevTerm(cancelRequest);
        return response;
    }


    /**
     *新增表计终端关系
     * @param addTermMeterRequest
     * @return
     */
    @ApiOperation(value="新增表计终端关系")
    @PostMapping("/addTermMeter")
    public R<BrushMeterResponse> addTermMeter(@RequestBody AddTermMeterRequest addTermMeterRequest) {

        addTermMeterRequest.setDevMeterNo(addTermMeterRequest.getDevMeterAddr());
        addTermMeterRequest.setDevTermNo(addTermMeterRequest.getDevTermAddr());
        //获取原存在表计
        RunMeasPointListResponse runMeasPointListResponse=accessMgmtService.getRunMeasPointListBySn(addTermMeterRequest.getDevTermNo());
        List<RunMeasPointVo> runMeasPointList=runMeasPointListResponse.getRunMeasPointList();
        List<RunMeasPointVo> measCommAddrList = runMeasPointList.stream().filter(runMeasPointVo -> runMeasPointVo.getMeasCommAddr().equals(addTermMeterRequest.getDevMeterNo())).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(measCommAddrList)) {
            R<BrushMeterResponse> flag = accessMgmtService.brushMeter(addTermMeterRequest.getDevTermNo(), addTermMeterRequest.getDevMeterNo(),null, addTermMeterRequest.getDevMeterCommProto());
            return flag;
        }
        BrushMeterResponse brushMeterResponse=new BrushMeterResponse();
        brushMeterResponse.setRunMeasPointId(measCommAddrList.get(0).getId());
        brushMeterResponse.setAccessMeasureId(measCommAddrList.get(0).getAccessMeasureId());
        return R.ok(brushMeterResponse);
    }


    /**
     * 获取同步数据
     * @param accessGatewayId
     * @return
     */
    @ApiOperation(value="获取同步数据")
    @GetMapping("/getRunMeasPointList")
    public R getRunMeasPointList(@RequestParam("accessGatewayId") String accessGatewayId) {
        List<RunMeasPointDo> runMeasPointList = accessMgmtService.getRunMeasPointList(accessGatewayId);
        return R.ok(runMeasPointList);
    }



    /**
     * 处理终端在线，表计不在线
     * @param mac
     * @return
     */
    @ApiOperation(value="处理终端在线，表计不在线")
    @PostMapping("/brushMeter")
    public R brushMeter(@RequestParam("mac") String mac,@RequestParam("key") String key,@RequestParam("topic") String topic) {
        accessMgmtService.brushMeter(mac,key,topic,null);
        return R.ok();
    }


    /**
     * 根据终端地址获取
     * @return
     */
    @ApiOperation(value="根据终端地址获取")
        @GetMapping("/getRunMeasPointListBySn")
    public R<RunMeasPointListResponse> getRunMeasPointListBySn(@RequestParam("sn") String sn) {
        RunMeasPointListResponse runMeasPointListResponse = accessMgmtService.getRunMeasPointListBySn(sn);
        return R.ok(runMeasPointListResponse);
    }


    /**
     *
     * @param editMeterRequest
     * @return
     */
    @ApiOperation(value="修改表计信息")
    @PostMapping("/editMeter")
    public R editMeter(@RequestBody EditMeterRequest editMeterRequest) {
         accessMgmtService.editMeter(editMeterRequest);
        return R.ok();
    }


    /**
     * 拆除表计
     * @param runMeasPointId
     * @return
     */
    @ApiOperation(value="拆除表计")
    @PostMapping("/delTermMeter")
    public R delTermMeter(@RequestParam("runMeasPointId") Long runMeasPointId) {
        accessMgmtService.delTermMeter(runMeasPointId);
        return R.ok();
    }











}
