package com.gaea.iesms.bm.datacenter.controller;

import com.gaea.base.core.R;
import com.gaea.iesms.core.feign.request.datacenter.MeasDataCumFreezeCurveGetRangeRequest;
import com.gaea.iesms.core.feign.response.datacenter.MeasDataCumFreezeCurveGetRangeResponse;
import com.gaea.iesms.bm.datacenter.service.MeasDataService;
import com.gaea.iesms.core.feign.request.datacenter.*;
import com.gaea.iesms.core.feign.response.datacenter.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @description:量测数据
 * @author: lifeng.du
 * @email: xxx@xx.com
 * @date: 2023/4/18 14:42
 */
@RestController
@RequestMapping("/measData")
@Api(tags = "量测点数据接口")
public class MeasDataController {

    @Autowired
    private MeasDataService measDataService;

    /**
     * 获取量测点最新数据
     * @param measDataLatestGetRequest
     * @return
     */
    @PostMapping("/getMeasDataLatest")
    @ApiOperation(value = "获取量测点最新数据")
    public R<MeasDataLatestGetResponse> getMeasDataLatest(@RequestBody MeasDataLatestGetRequest measDataLatestGetRequest) {
        MeasDataLatestGetResponse response = measDataService.getMeasDataLatest(measDataLatestGetRequest);
        return R.ok(response);
    }

    /**
     * 批量获取量测点最新数据
     * @param measDataLatestBatchGetRequest
     * @return
     */
    @PostMapping("/batchGetMeasDataLatest")
    @ApiOperation(value = "批量获取量测点最新数据")
    public R<MeasDataLatestBatchGetResponse> batchGetMeasDataLatest(@RequestBody MeasDataLatestBatchGetRequest measDataLatestBatchGetRequest) {
        MeasDataLatestBatchGetResponse response = measDataService.batchGetMeasDataLatest(measDataLatestBatchGetRequest);
        return R.ok(response);
    }

    /**
     * 获取瞬时量曲线数据（时间点）
     * @param measDataInsFreezeCurveGetRequest
     * @return
     */
    @PostMapping("/getMeasDataInsFreezeCurve")
    @ApiOperation(value = "获取瞬时量曲线数据（时间点）")
    public R<MeasDataInsFreezeCurveGetResponse> getMeasDataInsFreezeCurve(@RequestBody MeasDataInsFreezeCurveGetRequest measDataInsFreezeCurveGetRequest) {
        MeasDataInsFreezeCurveGetResponse response = measDataService.getMeasDataInsFreezeCurve(measDataInsFreezeCurveGetRequest);
        return R.ok(response);
    }

    /**
     * 获取瞬时量曲线数据（时间范围）
     * @param measDataInsFreezeCurveGetRangeRequest
     * @return
     */
    @PostMapping("/getRangeMeasDataInsFreezeCurve")
    @ApiOperation(value = "获取瞬时量曲线数据（时间范围）")
    public R<MeasDataInsFreezeCurveGetRangeResponse> getRangeMeasDataInsFreezeCurve(@RequestBody MeasDataInsFreezeCurveGetRangeRequest measDataInsFreezeCurveGetRangeRequest) {
        MeasDataInsFreezeCurveGetRangeResponse response = measDataService.getRangeMeasDataInsFreezeCurve(measDataInsFreezeCurveGetRangeRequest);
        return R.ok(response);
    }

    /**
     * 批量获取瞬时量曲线数据（时间范围）
     * @param measDataInsFreezeCurveGetRangeRequestList
     * @return
     */
    @PostMapping("/getRangeMeasDataInsFreezeCurveList")
    @ApiOperation(value = "批量获取瞬时量曲线数据（时间范围）")
    public R<MeasDataInsFreezeCurveGetRangeListResponse> getRangeMeasDataInsFreezeCurveList(@RequestBody List<MeasDataInsFreezeCurveGetRangeRequest> measDataInsFreezeCurveGetRangeRequestList) {
        MeasDataInsFreezeCurveGetRangeListResponse response = measDataService.getRangeMeasDataInsFreezeCurveList(measDataInsFreezeCurveGetRangeRequestList);
        return R.ok(response);
    }

    /**
     * 获取累计量曲线数据（时间点）
     * @param measDataCumFreezeCurveGetRequest
     * @return
     */
    @PostMapping("/getMeasDataCumFreezeCurve")
    @ApiOperation(value = "获取累计量曲线数据（时间点）")
    public R<MeasDataCumFreezeCurveGetResponse> getMeasDataCumFreezeCurve(@RequestBody MeasDataCumFreezeCurveGetRequest measDataCumFreezeCurveGetRequest) {
        MeasDataCumFreezeCurveGetResponse response = measDataService.getMeasDataCumFreezeCurve(measDataCumFreezeCurveGetRequest);
        return R.ok(response);
    }

    /**
     * 批量（多量测点）获取累计量曲线数据（时间点）
     * @param measDataCumFreezeCurveBatchGetRequest
     * @return
     */
    @PostMapping("/batchGetMeasDataCumFreezeCurve")
    @ApiOperation(value = "批量（多量测点）获取累计量曲线数据（时间点）")
    public R<MeasDataCumFreezeCurveBatchGetResponse> batchGetMeasDataCumFreezeCurve(@RequestBody MeasDataCumFreezeCurveBatchGetRequest measDataCumFreezeCurveBatchGetRequest) {
        MeasDataCumFreezeCurveBatchGetResponse response = measDataService.batchGetMeasDataCumFreezeCurve(measDataCumFreezeCurveBatchGetRequest);
        return R.ok(response);
    }



    /**
     * 获取累计量曲线数据（时间范围）
     * @param measDataCumFreezeCurveGetRangeRequest
     *          获取累计量曲线数据请求
     * @return  获取累计量曲线数据回应
     */
    @PostMapping("/getRangeMeasDataCumFreezeCurve")
    @ApiOperation(value = "获取累计量曲线数据（时间范围）")
    public R getRangeMeasDataCumFreezeCurve(@RequestBody MeasDataCumFreezeCurveGetRangeRequest measDataCumFreezeCurveGetRangeRequest) {
        MeasDataCumFreezeCurveGetRangeResponse response = measDataService.getRangeMeasDataCumFreezeCurve(measDataCumFreezeCurveGetRangeRequest);
        return R.ok(response);
    }

    /**
     * 获取累计量曲线数据（时间范围）
     * @param measDataCumFreezeCurveBatchGetRangeRequest
     *          获取累计量曲线数据请求
     * @return  获取累计量曲线数据回应
     */
    @PostMapping("/batchGetRangeMeasDataCumFreezeCurve")
    @ApiOperation(value = "获取累计量曲线数据（时间范围）")
    public R batchGetRangeMeasDataCumFreezeCurve(@RequestBody MeasDataCumFreezeCurveBatchGetRangeRequest measDataCumFreezeCurveBatchGetRangeRequest) {
        List<MeasDataCumFreezeCurveGetRangeResponse> response = measDataService.batchGetRangeMeasDataCumFreezeCurve(measDataCumFreezeCurveBatchGetRangeRequest);
        return R.ok(response);
    }





    /**
     * 调用接口，获取数据并将相同数据项的数据求和，
     * 如果是电压，功率因数，温度则取最大值和最小值
     * gen_watt_u gen_watt_temp gen_watt_pf
     *
     * @param measItemCodeSet
     * @param measIdList
     * @return
     */
    @PostMapping("/getValueSum")
    @ApiOperation(value = "获取累计量曲线数据（时间范围）")
    public R getValueSum(@RequestParam("measItemCodeSet") Set<String> measItemCodeSet,@RequestParam("measIdList") Set<String> measIdList) {
        Map<String, BigDecimal> resultMap=measDataService.getValueSum(measItemCodeSet,measIdList);
        return R.ok(resultMap);
    }



}