package com.gaea.iesms.bm.datacenter.mapper;


import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.gaea.iesms.bm.datacenter.model.response.MeasDataLatestVo;
import com.gaea.iesms.core.model.entity.datacenter.MeasDataInsFreezeCurveDo;
import com.gaea.iesms.bm.datacenter.model.MeasDataInsFreezeCurveVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-08
 */
@Mapper
public interface MeasDataInsFreezeCurveDao extends CrudMapper<MeasDataInsFreezeCurveDo, Long> {

    /**
     * 批量更新
     * @param measDataInsFreezeCurveDoList
     *          瞬时量曲线数据实体列表
     * @return
     */
    int batchInsertOrUpdate(@Param("list") List<MeasDataInsFreezeCurveDo> measDataInsFreezeCurveDoList);

    /**
     * 通过量测点标识和量测项编码获取量测点最新数据实体
     *
     * @param measPointId
     *          量测点标识
     * @param measItemCode
     *          量测项编码
     * @param gmtMeasFreeze
     *          量测曲线时间
     * @return
     *          瞬时量曲线数据
     */
    MeasDataInsFreezeCurveDo getByMeasPointIdAndMeasItemCodeAndGmtMeasFreeze(@Param("measPointId") Long measPointId, @Param("measItemCode") String measItemCode, @Param("gmtMeasFreeze") long gmtMeasFreeze);

    /**
     * 通过量测点标识和量测项编码获取量测点最新数据视图
     *
     * @param measPointId
     *          量测点标识
     * @param measItemCode
     *          量测项编码
     * @param gmtMeasFreeze
     *          量测曲线时间
     * @return
     *          瞬时量曲线数据
     */
    MeasDataInsFreezeCurveVo getMeasDataInsFreezeCurveVoByMeasPointIdAndMeasItemCodeAndGmtMeasFreeze(@Param("measPointId") Long measPointId, @Param("measItemCode") String measItemCode, @Param("gmtMeasFreeze") long gmtMeasFreeze);

    /**
     * 查询结果个数
     *
     * @param params
     *          查询参数
     * @return
     *          查询结果个数
     */
    int getMeasDataInsFreezeCurveVoCount(@Param("params") Map<String, Object> params);

    /**
     * 查询结果列表
     *
     * @param params
     *          查询参数
     * @param sorter
     *          排序
     * @param pager
     *          分页
     * @return
     *          查询结果列表
     */
    List<MeasDataInsFreezeCurveVo> getMeasDataInsFreezeCurveVoList(@Param("params") Map<String, Object> params, @Param("sorter") Sorter sorter, @Param("pager") Pager pager);

    MeasDataInsFreezeCurveDo getMeasDataLatestJala(@Param("measPointId") Long measPointId, @Param("measItemCode")  String measItemCode);
}
