package com.gaea.iesms.bm.datacenter.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.easesource.commons.util.NumberUtils;
import com.easesource.commons.util.ObjectUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.bean.Sorter;
import com.gaea.iesms.bm.datacenter.mapper.*;
import com.gaea.iesms.bm.datacenter.utils.DataWarehouse;
import com.gaea.iesms.core.feign.request.datacenter.*;
import com.gaea.iesms.core.feign.response.datacenter.MeasDataCumFreezeCurveValue;
import com.gaea.iesms.core.feign.response.datacenter.*;
import com.gaea.iesms.bm.datacenter.model.MeasDataInsFreezeCurveVo;
import com.gaea.iesms.bm.datacenter.model.response.*;
import com.gaea.iesms.bm.datacenter.service.AbstractBaseService;
import com.gaea.iesms.bm.datacenter.service.MeasDataService;
import com.gaea.iesms.bm.datacenter.utils.MeasLatestOperator;
import com.gaea.iesms.core.model.entity.datacenter.MeasDataCumFreezeCurveDo;
import com.gaea.iesms.core.model.entity.datacenter.MeasDataInsFreezeCurveDo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 *
 * @author Nick Zhang
 */
@Service(value = "measDataService")
public class MeasDataServiceImpl extends AbstractBaseService implements MeasDataService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private MeasDataCumFreezeCurveDao measDataCumFreezeCurveDao;

    @Resource
    private MeasDataInsFreezeCurveDao measDataInsFreezeCurveDao;

    @Resource
    private MeasLatestOperator redisOperator;

    @Resource
    private RunMeasPointDao runMeasureDataDao;

    @Override
    public MeasDataLatestGetResponse getMeasDataLatest(MeasDataLatestGetRequest measDataLatestGetRequest) {
        if(measDataLatestGetRequest.getMeasItemCodeSet().size() == 0) {
            logger.warn("measItemCodeSet is empty");
        }
        MeasDataLatestGetResponse response = new MeasDataLatestGetResponse();
        Long measPointId = measDataLatestGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measDataLatestGetRequest.getMeasItemCodeSet();
        Map<String, MeasDataLatestInfo> measDataMap = Maps.newHashMap();
        List<MeasDataLatestVo> measDataLatestVoList = null;
        if(measItemCodeSet.size() > 0) {
            measDataLatestVoList = DataWarehouse.getMeasDataLatestVoListByMeasPointIdSetAndMeasItemCodeSet(Sets.newHashSet(measPointId), measItemCodeSet, measDataLatestGetRequest.getGmtMeasDataLatest());
        }
        if(CollectionUtil.isEmpty(measDataLatestVoList)){
            RunMeasPointVo runMeasPointJALAByMeasPointId = runMeasureDataDao.getRunMeasPointJALAByMeasPointId(measPointId);
            if (ObjectUtils.isNotEmpty(runMeasPointJALAByMeasPointId)){
                measDataLatestVoList=jalaMeasDataLatestVoList(measPointId,measItemCodeSet);
            }
        }
        if(measDataLatestVoList != null) {
            measDataLatestVoList.forEach(measDataLatestVo -> {
                //logger.info(" measDataLatestVo : " + JsonConvertUtils.convertToString(measDataLatestVo));
                String measItemCode = measDataLatestVo.getMeasItemCode();
                if(measDataLatestVo.getMeasDataInfo() != null) {
                    Map measDataInfoMap = JsonConvertUtils.convertFromString(measDataLatestVo.getMeasDataInfo(), Map.class);
                    String measDataClassName = (String) measDataInfoMap.get("measDataClass");
                    Class measDataClass = null;
                    Object measDataValue = null;
                    BigDecimal selfRate = measDataLatestVo.getSelfRate();
                    if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                        selfRate = new BigDecimal("1.0");
                    }
                    BigDecimal ctRate = measDataLatestVo.getCtRate();
                    if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                        ctRate = new BigDecimal("1.0");
                    }
                    BigDecimal ptRate = measDataLatestVo.getPtRate();
                    if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                        ptRate = new BigDecimal("1.0");
                    }
                    if(StringUtils.equals(measDataClassName, "java.math.BigDecimal")) {
                        measDataClass = java.math.BigDecimal.class;
                        measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).setScale(6, RoundingMode.HALF_UP);
                        if(measDataLatestGetRequest.getMeasDataSideType() == 1) {
                            //measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                            if(StringUtils.containsAny(measItemCode, "gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus")) {
                                // 电压 * PT
                                measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                            }
                            else if(StringUtils.containsAny(measItemCode, "gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus")) {
                                // 电流 * CT
                                measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).setScale(6, RoundingMode.HALF_UP);
                            }
                            else if(StringUtils.containsAny(measItemCode, "gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus")) {
                                // 功率 * CT * PT
                                measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                            }
                            else if(StringUtils.containsAny(measItemCode, "gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre")) {
                                // 电量 * CT * PT
                                measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                            }
                        }
                    }
                    else if(StringUtils.equals(measDataClassName, "java.lang.Boolean")) {
                        measDataClass = java.lang.Boolean.class;
                        measDataValue = Boolean.valueOf(measDataInfoMap.get("measDataValue").toString());
                    }
                    else if(StringUtils.equals(measDataClassName, "java.lang.String")) {
                        measDataClass = java.lang.String.class;
                        measDataValue = measDataInfoMap.get("measDataValue").toString();
                    }
                    else if(StringUtils.equals(measDataClassName, "java.lang.Integer")) {
                        measDataClass = java.lang.Integer.class;
                        measDataValue = Integer.valueOf(measDataInfoMap.get("measDataValue").toString());
                    }
                    else if(StringUtils.equals(measDataClassName, "java.lang.Long")) {
                        measDataClass = java.lang.Long.class;
                        measDataValue = Long.valueOf(measDataInfoMap.get("measDataValue").toString());
                    }
                    else if(StringUtils.equals(measDataClassName, "java.util.Date")) {
                        measDataClass = java.util.Date.class;
                        measDataValue = new Date(Long.parseLong(measDataInfoMap.get("measDataValue").toString()));
                    }
                    int measDataSource = NumberUtils.toInt(ObjectUtils.toStringDefaultEmpty(measDataInfoMap.get("measDataSource")), 0);
                    long gmtMeasDataLatest = NumberUtils.toLong(ObjectUtils.toStringDefaultEmpty(measDataInfoMap.get("gmtMeasDataLatest")), System.currentTimeMillis());
                    measDataMap.put(measItemCode, new MeasDataLatestInfo(measPointId, measItemCode, measDataClass, measDataValue, measDataSource, gmtMeasDataLatest, measDataLatestVo.getGmtCreate(), measDataLatestVo.getGmtModified()));
                }
            });
        }
        response.setMeasPointId(measPointId);
        response.setMeasDataMap(measDataMap);
        return response;
    }

    private List<MeasDataLatestVo> jalaMeasDataLatestVoList(Long measPointId, Set<String> measItemCodeSet) {
        List<MeasDataLatestVo> measDataLatestVoList = new ArrayList<>();
        for (String measItemCode : measItemCodeSet) {
            MeasDataLatestVo measDataLatestVo=new MeasDataLatestVo();
            //判断是累积量还是瞬时量
            String measType=runMeasureDataDao.getMeasItemType(measItemCode);
            if (measType.equals("INS")){
                MeasDataInsFreezeCurveDo measDataInsFreezeCurveDo =measDataInsFreezeCurveDao.getMeasDataLatestJala(measPointId,measItemCode);
                if (ObjectUtils.isNotEmpty(measDataInsFreezeCurveDo)){
                    measDataLatestVo.setId(measDataInsFreezeCurveDo.getId());
                    measDataLatestVo.setMeasItemCode(measItemCode);
                    measDataLatestVo.setMeasPointId(measDataInsFreezeCurveDo.getMeasPointId());
                    Map<String, Object> measDataInfoMap = new HashMap<>();
                    measDataInfoMap.put("measDataClass", "java.math.BigDecimal");
                    measDataInfoMap.put("measDataValue", measDataInsFreezeCurveDo.getMeasDataValue());
                    measDataLatestVo.setMeasDataInfo(JSONObject.toJSONString(measDataInfoMap));
                    measDataLatestVo.setGmtCreate(measDataInsFreezeCurveDo.getGmtMeasFreeze());
                    measDataLatestVo.setGmtModified(measDataInsFreezeCurveDo.getGmtMeasFreeze());
                    measDataLatestVoList.add(measDataLatestVo);
                }
            }else {
                MeasDataCumFreezeCurveDo measDataLatestJala = measDataCumFreezeCurveDao.getMeasDataLatestJala(measPointId, measItemCode);
                if (ObjectUtils.isNotEmpty(measDataLatestJala)){
                    measDataLatestVo.setId(measDataLatestJala.getId());
                    measDataLatestVo.setMeasItemCode(measItemCode);
                    measDataLatestVo.setMeasPointId(measDataLatestJala.getMeasPointId());
                    Map<String, Object> measDataInfoMap = new HashMap<>();
                    measDataInfoMap.put("measDataClass", "java.math.BigDecimal");
                    measDataInfoMap.put("measDataValue", measDataLatestJala.getMeasDataValue());
                    measDataLatestVo.setMeasDataInfo(JsonConvertUtils.convertToString(measDataInfoMap));
                    measDataLatestVo.setGmtCreate(measDataLatestJala.getGmtMeasFreeze());
                    measDataLatestVo.setGmtModified(measDataLatestJala.getGmtMeasFreeze());
                    measDataLatestVoList.add(measDataLatestVo);
                }
            }

        }
        return measDataLatestVoList;
    }

    @Override
    public MeasDataLatestBatchGetResponse batchGetMeasDataLatest(MeasDataLatestBatchGetRequest measDataLatestBatchGetRequest) {
        if(measDataLatestBatchGetRequest.getMeasItemCodeSet().size() == 0) {
            logger.warn("measItemCodeSet is empty");
        }
        MeasDataLatestBatchGetResponse response = new MeasDataLatestBatchGetResponse();
        Set<Long> measPointIdSet = measDataLatestBatchGetRequest.getMeasPointIdSet();
        Set<String> measItemCodeSet = measDataLatestBatchGetRequest.getMeasItemCodeSet();
        Map<Long, Map<String, MeasDataLatestInfo>> batchMeasDataMap = Maps.newHashMap();
        List<MeasDataLatestVo> results = null;
        if(measPointIdSet.size() > 0 && measItemCodeSet.size() > 0) {
            results = DataWarehouse.getMeasDataLatestVoListByMeasPointIdSetAndMeasItemCodeSet(measPointIdSet, measItemCodeSet, measDataLatestBatchGetRequest.getGmtMeasDataLatest());
        }
        if(results != null) {
            Map<Long, List<MeasDataLatestVo>> groupMeasPointIdResults = results.stream().collect(Collectors.groupingBy(MeasDataLatestVo::getMeasPointId));
            groupMeasPointIdResults.forEach((measPointId, list1) -> {
                Map<String, MeasDataLatestInfo> measDataMap = Maps.newHashMap();
                Map<String, List<MeasDataLatestVo>> groupMeasItemCodeResults = list1.stream().collect(Collectors.groupingBy(MeasDataLatestVo::getMeasItemCode));
                groupMeasItemCodeResults.forEach((measItemCode, list2) -> {
                    if(list2 != null && list2.size() > 0) {
                        MeasDataLatestVo measDataLatestVo = list2.get(0);
                        //logger.info(" measDataLatestVo : " + JsonConvertUtils.convertToString(measDataLatestVo));
                        if(measDataLatestVo != null && measDataLatestVo.getMeasDataInfo() != null) {
                            Map measDataInfoMap = JsonConvertUtils.convertFromString(measDataLatestVo.getMeasDataInfo(), Map.class);
                            String measDataClassName = (String) measDataInfoMap.get("measDataClass");
                            Class measDataClass = null;
                            Object measDataValue = null;
                            BigDecimal selfRate = measDataLatestVo.getSelfRate();
                            if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                                selfRate = new BigDecimal("1.0");
                            }
                            BigDecimal ctRate = measDataLatestVo.getCtRate();
                            if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                                ctRate = new BigDecimal("1.0");
                            }
                            BigDecimal ptRate = measDataLatestVo.getPtRate();
                            if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                                ptRate = new BigDecimal("1.0");
                            }
                            if(StringUtils.equals(measDataClassName, "java.math.BigDecimal")) {
                                measDataClass = java.math.BigDecimal.class;
                                measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).setScale(6, RoundingMode.HALF_UP);
                                if(measDataLatestBatchGetRequest.getMeasDataSideType() == 1) {
                                    //measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                                    if(StringUtils.containsAny(measItemCode, "gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus")) {
                                        // 电压 * PT
                                        measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                                    }
                                    else if(StringUtils.containsAny(measItemCode, "gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus")) {
                                        // 电流 * CT
                                        measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).setScale(6, RoundingMode.HALF_UP);
                                    }
                                    else if(StringUtils.containsAny(measItemCode, "gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus")) {
                                        // 功率 * CT * PT
                                        measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                                    }
                                    else if(StringUtils.containsAny(measItemCode, "gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre")) {
                                        // 电量 * CT * PT
                                        measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                                    }
                                }
                            }
                            else if(StringUtils.equals(measDataClassName, "java.lang.Boolean")) {
                                measDataClass = java.lang.Boolean.class;
                                measDataValue = Boolean.valueOf(measDataInfoMap.get("measDataValue").toString());
                            }
                            else if(StringUtils.equals(measDataClassName, "java.lang.String")) {
                                measDataClass = java.lang.String.class;
                                measDataValue = measDataInfoMap.get("measDataValue").toString();
                            }
                            else if(StringUtils.equals(measDataClassName, "java.lang.Integer")) {
                                measDataClass = java.lang.Integer.class;
                                measDataValue = Integer.valueOf(measDataInfoMap.get("measDataValue").toString());
                            }
                            else if(StringUtils.equals(measDataClassName, "java.util.Date")) {
                                measDataClass = java.util.Date.class;
                                measDataValue = new Date(Long.parseLong(measDataInfoMap.get("measDataValue").toString()));
                            }
                            int measDataSource = NumberUtils.toInt(ObjectUtils.toStringDefaultEmpty(measDataInfoMap.get("measDataSource")), 0);
                            long gmtMeasDataLatest = NumberUtils.toLong(ObjectUtils.toStringDefaultEmpty(measDataInfoMap.get("gmtMeasDataLatest")), System.currentTimeMillis());
                            measDataMap.put(measItemCode, new MeasDataLatestInfo(measPointId, measItemCode, measDataClass, measDataValue, measDataSource, gmtMeasDataLatest, measDataLatestVo.getGmtCreate(), measDataLatestVo.getGmtModified()));
                        }
                    }
                });
                batchMeasDataMap.put(measPointId, measDataMap);
            });
        }
        response.setBatchMeasDataMap(batchMeasDataMap);
        return response;
    }

    @Override
    public MeasDataInsFreezeCurveGetResponse getMeasDataInsFreezeCurve(MeasDataInsFreezeCurveGetRequest measDataInsFreezeCurveGetRequest) {
        MeasDataInsFreezeCurveGetResponse response = new MeasDataInsFreezeCurveGetResponse();
        Long measPointId = measDataInsFreezeCurveGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measDataInsFreezeCurveGetRequest.getMeasItemCodeSet();
        long gmtMeasFreeze = measDataInsFreezeCurveGetRequest.getGmtMeasFreeze();
        Map<String, MeasDataInsFreezeCurveValue> measDataMap = Maps.newHashMap();
        for(String measItemCode : measItemCodeSet) {
            MeasDataInsFreezeCurveVo measDataInsFreezeCurveVo = measDataInsFreezeCurveDao.getMeasDataInsFreezeCurveVoByMeasPointIdAndMeasItemCodeAndGmtMeasFreeze(measPointId, measItemCode, gmtMeasFreeze);
            if(measDataInsFreezeCurveVo != null) {
                BigDecimal selfRate = measDataInsFreezeCurveVo.getSelfRate();
                if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                    selfRate = new BigDecimal("1.0");
                }
                BigDecimal ctRate = measDataInsFreezeCurveVo.getCtRate();
                if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ctRate = new BigDecimal("1.0");
                }
                BigDecimal ptRate = measDataInsFreezeCurveVo.getPtRate();
                if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ptRate = new BigDecimal("1.0");
                }
                BigDecimal measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().setScale(6, BigDecimal.ROUND_HALF_UP);
                if(measDataInsFreezeCurveGetRequest.getMeasDataSideType() == 1) {
                    //measDataValue = measDataValue.multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                    if(StringUtils.containsAny(measItemCode, "gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus")) {
                        // 电压 * PT
                        measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                    else if(StringUtils.containsAny(measItemCode, "gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus")) {
                        // 电流 * CT
                        measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                    else if(StringUtils.containsAny(measItemCode, "gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus")) {
                        // 功率 * CT * PT
                        measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                }
                measDataMap.put(measItemCode, new MeasDataInsFreezeCurveValue(measPointId, measItemCode, gmtMeasFreeze, measDataValue, measDataInsFreezeCurveVo.getMeasDataRate().setScale(6, BigDecimal.ROUND_HALF_UP), measDataInsFreezeCurveVo.getMeasDataSource(), measDataInsFreezeCurveVo.getFreezeMode(), measDataInsFreezeCurveVo.getGmtMeasData(), measDataInsFreezeCurveVo.getGmtCreate(), measDataInsFreezeCurveVo.getGmtModified()));
            }
        }
        response.setMeasPointId(measPointId);
        response.setMeasDataMap(measDataMap);
        return response;
    }

    @Override
    public MeasDataInsFreezeCurveGetRangeResponse getRangeMeasDataInsFreezeCurve(MeasDataInsFreezeCurveGetRangeRequest measDataInsFreezeCurveGetRangeRequest) {
        MeasDataInsFreezeCurveGetRangeResponse response = new MeasDataInsFreezeCurveGetRangeResponse();
        Long measPointId = measDataInsFreezeCurveGetRangeRequest.getMeasPointId();
        Set<String> measItemCodeSet = measDataInsFreezeCurveGetRangeRequest.getMeasItemCodeSet();
        long gmtMeasFreezeStart = measDataInsFreezeCurveGetRangeRequest.getGmtMeasFreezeStart();
        long gmtMeasFreezeEnd = measDataInsFreezeCurveGetRangeRequest.getGmtMeasFreezeEnd();
        Map<String, List<MeasDataInsFreezeCurveValue>> measDataListMap = Maps.newHashMap();
        for(String measItemCode : measItemCodeSet) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("measPointId", measPointId);
            params.put("measItemCode", measItemCode);
            params.put("gmtMeasFreezeStart", gmtMeasFreezeStart);
            params.put("gmtMeasFreezeEnd", gmtMeasFreezeEnd);
            List<MeasDataInsFreezeCurveVo> measDataInsFreezeCurveList = measDataInsFreezeCurveDao.getMeasDataInsFreezeCurveVoList(params, new Sorter("gmt_meas_freeze", "ASC"), null);
            List<MeasDataInsFreezeCurveValue> measDataList = Lists.newArrayList();
            for(MeasDataInsFreezeCurveVo measDataInsFreezeCurveVo : measDataInsFreezeCurveList) {
                BigDecimal selfRate = measDataInsFreezeCurveVo.getSelfRate();
                if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                    selfRate = new BigDecimal("1.0");
                }
                BigDecimal ctRate = measDataInsFreezeCurveVo.getCtRate();
                if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ctRate = new BigDecimal("1.0");
                }
                BigDecimal ptRate = measDataInsFreezeCurveVo.getPtRate();
                if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ptRate = new BigDecimal("1.0");
                }
                BigDecimal measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().setScale(6, BigDecimal.ROUND_HALF_UP);
                if(measDataInsFreezeCurveGetRangeRequest.getMeasDataSideType() == 1) {
                    //measDataValue = measDataValue.multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                    if(StringUtils.containsAny(measItemCode, "gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus")) {
                        // 电压 * PT
                        measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                    else if(StringUtils.containsAny(measItemCode, "gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus")) {
                        // 电流 * CT
                        measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                    else if(StringUtils.containsAny(measItemCode, "gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus")) {
                        // 功率 * CT * PT
                        measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                }
                measDataList.add(new MeasDataInsFreezeCurveValue(measPointId, measItemCode, measDataInsFreezeCurveVo.getGmtMeasFreeze(), measDataValue, measDataInsFreezeCurveVo.getMeasDataRate().setScale(6, BigDecimal.ROUND_HALF_UP), measDataInsFreezeCurveVo.getMeasDataSource(), measDataInsFreezeCurveVo.getFreezeMode(), measDataInsFreezeCurveVo.getGmtMeasData(), measDataInsFreezeCurveVo.getGmtCreate(), measDataInsFreezeCurveVo.getGmtModified()));
            }
            measDataListMap.put(measItemCode, measDataList);
        }
        response.setMeasPointId(measPointId);
        response.setMeasDataListMap(measDataListMap);
        return response;
    }


    @Override
    public MeasDataInsFreezeCurveGetRangeListResponse getRangeMeasDataInsFreezeCurveList(List<MeasDataInsFreezeCurveGetRangeRequest> measDataInsFreezeCurveGetRangeRequestList) {
        MeasDataInsFreezeCurveGetRangeListResponse measDataInsFreezeCurveGetRangeListResponse=new MeasDataInsFreezeCurveGetRangeListResponse();
        List<MeasDataInsFreezeCurveGetRangeBaseResponse> responseList=new ArrayList<>();
        measDataInsFreezeCurveGetRangeRequestList.forEach(measDataInsFreezeCurveGetRangeRequest->{
            MeasDataInsFreezeCurveGetRangeBaseResponse response = new MeasDataInsFreezeCurveGetRangeBaseResponse();
            Long measPointId = measDataInsFreezeCurveGetRangeRequest.getMeasPointId();
            Set<String> measItemCodeSet = measDataInsFreezeCurveGetRangeRequest.getMeasItemCodeSet();
            long gmtMeasFreezeStart = measDataInsFreezeCurveGetRangeRequest.getGmtMeasFreezeStart();
            long gmtMeasFreezeEnd = measDataInsFreezeCurveGetRangeRequest.getGmtMeasFreezeEnd();
            Map<String, List<MeasDataInsFreezeCurveValue>> measDataListMap = Maps.newHashMap();
            for(String measItemCode : measItemCodeSet) {
                Map<String, Object> params = Maps.newHashMap();
                params.put("measPointId", measPointId);
                params.put("measItemCode", measItemCode);
                params.put("gmtMeasFreezeStart", gmtMeasFreezeStart);
                params.put("gmtMeasFreezeEnd", gmtMeasFreezeEnd);
                List<MeasDataInsFreezeCurveVo> measDataInsFreezeCurveList = measDataInsFreezeCurveDao.getMeasDataInsFreezeCurveVoList(params, new Sorter("gmt_meas_freeze", "ASC"), null);
                List<MeasDataInsFreezeCurveValue> measDataList = Lists.newArrayList();
                for(MeasDataInsFreezeCurveVo measDataInsFreezeCurveVo : measDataInsFreezeCurveList) {
                    BigDecimal selfRate = measDataInsFreezeCurveVo.getSelfRate();
                    if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                        selfRate = new BigDecimal("1.0");
                    }
                    BigDecimal ctRate = measDataInsFreezeCurveVo.getCtRate();
                    if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                        ctRate = new BigDecimal("1.0");
                    }
                    BigDecimal ptRate = measDataInsFreezeCurveVo.getPtRate();
                    if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                        ptRate = new BigDecimal("1.0");
                    }
                    BigDecimal measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().setScale(6, BigDecimal.ROUND_HALF_UP);
                    if(measDataInsFreezeCurveGetRangeRequest.getMeasDataSideType() == 1) {
                        //measDataValue = measDataValue.multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                        if(StringUtils.containsAny(measItemCode, "gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus")) {
                            // 电压 * PT
                            measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                        }
                        else if(StringUtils.containsAny(measItemCode, "gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus")) {
                            // 电流 * CT
                            measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                        }
                        else if(StringUtils.containsAny(measItemCode, "gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus")) {
                            // 功率 * CT * PT
                            measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                        }
                    }
                    measDataList.add(new MeasDataInsFreezeCurveValue(measPointId, measItemCode, measDataInsFreezeCurveVo.getGmtMeasFreeze(), measDataValue, measDataInsFreezeCurveVo.getMeasDataRate().setScale(6, BigDecimal.ROUND_HALF_UP), measDataInsFreezeCurveVo.getMeasDataSource(), measDataInsFreezeCurveVo.getFreezeMode(), measDataInsFreezeCurveVo.getGmtMeasData(), measDataInsFreezeCurveVo.getGmtCreate(), measDataInsFreezeCurveVo.getGmtModified()));
                }
                measDataListMap.put(measItemCode, measDataList);
            }
            response.setMeasPointId(measPointId);
            response.setMeasDataListMap(measDataListMap);

            if(logger.isDebugEnabled()) {
                logger.debug(" MeasDataInsFreezeCurveGetRangeResponse   : " + JsonConvertUtils.convertToString(response));
                logger.debug(" <<<<<<<< end getRangeMeasDataInsFreezeCurve <<<<<<<< ");
            }
            responseList.add(response);
        });
        measDataInsFreezeCurveGetRangeListResponse.setDataList(responseList);
        return measDataInsFreezeCurveGetRangeListResponse;
    }


    @Override
    public MeasDataCumFreezeCurveGetResponse getMeasDataCumFreezeCurve(MeasDataCumFreezeCurveGetRequest measDataCumFreezeCurveGetRequest) {
        MeasDataCumFreezeCurveGetResponse response = new MeasDataCumFreezeCurveGetResponse();
        Long measPointId = measDataCumFreezeCurveGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measDataCumFreezeCurveGetRequest.getMeasItemCodeSet();
        long gmtMeasFreeze = measDataCumFreezeCurveGetRequest.getGmtMeasFreeze();
        Map<String, MeasDataCumFreezeCurveValue> measDataMap = Maps.newHashMap();
        for(String measItemCode : measItemCodeSet) {
            MeasDataCumFreezeCurveVo measDataCumFreezeCurveVo = measDataCumFreezeCurveDao.getMeasDataCumFreezeCurveVoByMeasPointIdAndMeasItemCodeAndGmtMeasFreeze(measPointId, measItemCode, gmtMeasFreeze);
            if(measDataCumFreezeCurveVo != null) {
                BigDecimal selfRate = measDataCumFreezeCurveVo.getSelfRate();
                if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                    selfRate = new BigDecimal("1.0");
                }
                BigDecimal ctRate = measDataCumFreezeCurveVo.getCtRate();
                if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ctRate = new BigDecimal("1.0");
                }
                BigDecimal ptRate = measDataCumFreezeCurveVo.getPtRate();
                if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ptRate = new BigDecimal("1.0");
                }
                BigDecimal measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().setScale(6, RoundingMode.HALF_UP);
                if(measDataCumFreezeCurveGetRequest.getMeasDataSideType() == 1) {
                    // measDataValue = measDataValue.multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                    if(StringUtils.containsAny(measItemCode, "gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre")) {
                        // 电量 * CT * PT
                        measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                    }
                }
                measDataMap.put(measItemCode, new MeasDataCumFreezeCurveValue(measPointId, measItemCode, gmtMeasFreeze, measDataValue, measDataCumFreezeCurveVo.getMeasDataRate().setScale(6, RoundingMode.HALF_UP), measDataCumFreezeCurveVo.getMeasDataSource(), measDataCumFreezeCurveVo.getFreezeMode(), measDataCumFreezeCurveVo.getGmtMeasData(), measDataCumFreezeCurveVo.getGmtCreate(), measDataCumFreezeCurveVo.getGmtModified()));
            }
        }
        response.setMeasPointId(measPointId);
        response.setMeasDataMap(measDataMap);
        return response;
    }

    @Override
    public MeasDataCumFreezeCurveBatchGetResponse batchGetMeasDataCumFreezeCurve(MeasDataCumFreezeCurveBatchGetRequest measDataCumFreezeCurveBatchGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start batchGetMeasDataCumFreezeCurve >>>>>>> ");
            logger.debug(" MeasDataCumFreezeCurveBatchGetRequest     : " + JsonConvertUtils.convertToString(measDataCumFreezeCurveBatchGetRequest));
        }

        MeasDataCumFreezeCurveBatchGetResponse response = new MeasDataCumFreezeCurveBatchGetResponse();
        Set<Long> measPointIdSet = measDataCumFreezeCurveBatchGetRequest.getMeasPointIdSet();
        Set<String> measItemCodeSet = measDataCumFreezeCurveBatchGetRequest.getMeasItemCodeSet();
        long gmtMeasFreeze = measDataCumFreezeCurveBatchGetRequest.getGmtMeasFreeze();
        Map<Long, Map<String, MeasDataCumFreezeCurveValue>> batchMeasDataMap = Maps.newHashMap();
        List<MeasDataCumFreezeCurveVo> measDataCumFreezeCurveList = measDataCumFreezeCurveDao.getMeasDataCumFreezeCurveVoListByMeasPointIdSetAndMeasItemCodeSetAndGmtMeasFreeze(measPointIdSet, measItemCodeSet, gmtMeasFreeze);
        measDataCumFreezeCurveList.forEach(measDataCumFreezeCurveVo -> {
            Long measPointId = measDataCumFreezeCurveVo.getMeasPointId();
            String measItemCode = measDataCumFreezeCurveVo.getMeasItemCode();
            Map<String, MeasDataCumFreezeCurveValue> measDataMap = batchMeasDataMap.get(measPointId);
            if(measDataMap == null) {
                measDataMap = Maps.newHashMap();
            }
            BigDecimal selfRate = measDataCumFreezeCurveVo.getSelfRate();
            if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                selfRate = new BigDecimal("1.0");
            }
            BigDecimal ctRate = measDataCumFreezeCurveVo.getCtRate();
            if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                ctRate = new BigDecimal("1.0");
            }
            BigDecimal ptRate = measDataCumFreezeCurveVo.getPtRate();
            if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                ptRate = new BigDecimal("1.0");
            }
            BigDecimal measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().setScale(6, RoundingMode.HALF_UP);
            if(measDataCumFreezeCurveBatchGetRequest.getMeasDataSideType() == 1) {
                // measDataValue = measDataValue.multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                if(StringUtils.containsAny(measItemCode, "gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre")) {
                    // 电量 * CT * PT
                    measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                }
            }
            measDataMap.put(measItemCode, new MeasDataCumFreezeCurveValue(measPointId, measItemCode, gmtMeasFreeze, measDataValue, measDataCumFreezeCurveVo.getMeasDataRate().setScale(6, RoundingMode.HALF_UP), measDataCumFreezeCurveVo.getMeasDataSource(), measDataCumFreezeCurveVo.getFreezeMode(), measDataCumFreezeCurveVo.getGmtMeasData(), measDataCumFreezeCurveVo.getGmtCreate(), measDataCumFreezeCurveVo.getGmtModified()));
            batchMeasDataMap.put(measPointId, measDataMap);
        });
        response.setBatchMeasDataMap(batchMeasDataMap);
        return response;
    }

    @Override
    public MeasDataCumFreezeCurveGetRangeResponse getRangeMeasDataCumFreezeCurve(MeasDataCumFreezeCurveGetRangeRequest measDataCumFreezeCurveGetRangeRequest) {

        MeasDataCumFreezeCurveGetRangeResponse response = new MeasDataCumFreezeCurveGetRangeResponse();
        Long measPointId = measDataCumFreezeCurveGetRangeRequest.getMeasPointId();
        Set<String> measItemCodeSet = measDataCumFreezeCurveGetRangeRequest.getMeasItemCodeSet();
        long gmtMeasFreezeStart = measDataCumFreezeCurveGetRangeRequest.getGmtMeasFreezeStart();
        long gmtMeasFreezeEnd = measDataCumFreezeCurveGetRangeRequest.getGmtMeasFreezeEnd();
        Map<String, List<MeasDataCumFreezeCurveValue>> measDataListMap = Maps.newHashMap();
        for(String measItemCode : measItemCodeSet) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("measPointId", measPointId);
            params.put("measItemCode", measItemCode);
            params.put("gmtMeasFreezeStart", gmtMeasFreezeStart);
            params.put("gmtMeasFreezeEnd", gmtMeasFreezeEnd);
            List<MeasDataCumFreezeCurveVo> measDataCumFreezeCurveList = measDataCumFreezeCurveDao.getMeasDataCumFreezeCurveVoList(params, new Sorter("gmt_meas_freeze", "ASC"), null);
            List<MeasDataCumFreezeCurveValue> measDataList = Lists.newArrayList();
            for(MeasDataCumFreezeCurveVo measDataCumFreezeCurveVo : measDataCumFreezeCurveList) {
                BigDecimal selfRate = measDataCumFreezeCurveVo.getSelfRate();
                if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                    selfRate = new BigDecimal("1.0");
                }
                BigDecimal ctRate = measDataCumFreezeCurveVo.getCtRate();
                if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ctRate = new BigDecimal("1.0");
                }
                BigDecimal ptRate = measDataCumFreezeCurveVo.getPtRate();
                if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ptRate = new BigDecimal("1.0");
                }
                BigDecimal measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().setScale(6, BigDecimal.ROUND_HALF_UP);
                if(measDataCumFreezeCurveGetRangeRequest.getMeasDataSideType() == 1) {
                    // measDataValue = measDataValue.multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                    if(StringUtils.containsAny(measItemCode, "gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre")) {
                        // 电量 * CT * PT
                        measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                }
                measDataList.add(new MeasDataCumFreezeCurveValue(measPointId, measItemCode, measDataCumFreezeCurveVo.getGmtMeasFreeze(), measDataValue, measDataCumFreezeCurveVo.getMeasDataRate().setScale(6, BigDecimal.ROUND_HALF_UP), measDataCumFreezeCurveVo.getMeasDataSource(), measDataCumFreezeCurveVo.getFreezeMode(), measDataCumFreezeCurveVo.getGmtMeasData(), measDataCumFreezeCurveVo.getGmtCreate(), measDataCumFreezeCurveVo.getGmtModified()));
            }
            measDataListMap.put(measItemCode, measDataList);
        }
        response.setMeasPointId(measPointId);
        response.setMeasDataListMap(measDataListMap);

        return response;
    }

    @Override
    public Map<String, BigDecimal> getValueSum(Set<String> measItemCodeSet, Set<String> measIdList) {
        Map<String, BigDecimal> valueMap = new ConcurrentHashMap<>();
        measIdList.forEach(measPointId -> {
            MeasDataLatestGetRequest getRequest = new MeasDataLatestGetRequest();
            getRequest.setMeasPointId(Long.valueOf(measPointId));
            getRequest.setMeasDataSideType(1);
            getRequest.setMeasItemCodeSet(measItemCodeSet);
            MeasDataLatestGetResponse getResponse = this.getMeasDataLatest(getRequest);
            if (getResponse != null) {
                Map<String, MeasDataLatestInfo> measDataMap = getResponse.getMeasDataMap();
                measItemCodeSet.forEach(itemCode -> {
                    MeasDataLatestInfo dataLatestInfo = measDataMap.get(itemCode);
                    if (dataLatestInfo == null) {
                        return;
                    }
                    Object measDataValue = dataLatestInfo.getMeasDataValue();
                    if (measDataValue == null) {
                        return;
                    }
                    String value = measDataValue.toString();
                    if (value.equals("0E-8")) {
                        value = "0.0";
                    }
                    BigDecimal valueDecimal = new BigDecimal(value);
                    if (valueMap.containsKey(itemCode)) {
                        if (itemCode.startsWith("gen_watt_temp") || itemCode.startsWith("gen_watt_u") || itemCode.startsWith("gen_watt_pf")) {
                            // 取最大值
                            BigDecimal bigDecimal = valueMap.get(itemCode);
                            int i = bigDecimal.compareTo(valueDecimal);
                            if (i < 0) {
                                valueMap.put(itemCode, valueDecimal);
                            }
                        } else {
                            // 相加
                            if (valueMap.containsKey(itemCode)) {
                                BigDecimal bigDecimal = valueMap.get(itemCode);
                                BigDecimal decimal = bigDecimal.add(valueDecimal);
                                valueMap.put(itemCode, decimal);
                            }
                        }
                    } else {
                        valueMap.put(itemCode, valueDecimal);
                    }
                });
            }
        });
        return valueMap;
    }

    @Override
    public List<MeasDataCumFreezeCurveGetRangeResponse> batchGetRangeMeasDataCumFreezeCurve(MeasDataCumFreezeCurveBatchGetRangeRequest measDataCumFreezeCurveBatchGetRangeRequest) {
        List<MeasDataCumFreezeCurveGetRangeResponse> measDataCumFreezeCurveGetRangeResponseList=new ArrayList<>();
        for (Long measPointId:measDataCumFreezeCurveBatchGetRangeRequest.getMeasPointIdSet()){
            MeasDataCumFreezeCurveGetRangeResponse response = new MeasDataCumFreezeCurveGetRangeResponse();
            Set<String> measItemCodeSet = measDataCumFreezeCurveBatchGetRangeRequest.getMeasItemCodeSet();
            long gmtMeasFreezeStart = measDataCumFreezeCurveBatchGetRangeRequest.getGmtMeasFreezeStart();
            long gmtMeasFreezeEnd = measDataCumFreezeCurveBatchGetRangeRequest.getGmtMeasFreezeEnd();
            Map<String, List<MeasDataCumFreezeCurveValue>> measDataListMap = Maps.newHashMap();
            for(String measItemCode : measItemCodeSet) {
                Map<String, Object> params = Maps.newHashMap();
                params.put("measPointId", measPointId);
                params.put("measItemCode", measItemCode);
                params.put("gmtMeasFreezeStart", gmtMeasFreezeStart);
                params.put("gmtMeasFreezeEnd", gmtMeasFreezeEnd);
                List<MeasDataCumFreezeCurveVo> measDataCumFreezeCurveList = measDataCumFreezeCurveDao.getMeasDataCumFreezeCurveVoList(params, new Sorter("gmt_meas_freeze", "ASC"), null);
                List<MeasDataCumFreezeCurveValue> measDataList = Lists.newArrayList();
                for(MeasDataCumFreezeCurveVo measDataCumFreezeCurveVo : measDataCumFreezeCurveList) {
                    BigDecimal selfRate = measDataCumFreezeCurveVo.getSelfRate();
                    if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                        selfRate = new BigDecimal("1.0");
                    }
                    BigDecimal ctRate = measDataCumFreezeCurveVo.getCtRate();
                    if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                        ctRate = new BigDecimal("1.0");
                    }
                    BigDecimal ptRate = measDataCumFreezeCurveVo.getPtRate();
                    if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                        ptRate = new BigDecimal("1.0");
                    }
                    BigDecimal measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().setScale(6, BigDecimal.ROUND_HALF_UP);
                    if(measDataCumFreezeCurveBatchGetRangeRequest.getMeasDataSideType() == 1) {
                        // measDataValue = measDataValue.multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                        if(StringUtils.containsAny(measItemCode, "gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre")) {
                            // 电量 * CT * PT
                            measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                        }
                    }
                    measDataList.add(new MeasDataCumFreezeCurveValue(measPointId, measItemCode, measDataCumFreezeCurveVo.getGmtMeasFreeze(), measDataValue, measDataCumFreezeCurveVo.getMeasDataRate().setScale(6, BigDecimal.ROUND_HALF_UP), measDataCumFreezeCurveVo.getMeasDataSource(), measDataCumFreezeCurveVo.getFreezeMode(), measDataCumFreezeCurveVo.getGmtMeasData(), measDataCumFreezeCurveVo.getGmtCreate(), measDataCumFreezeCurveVo.getGmtModified()));
                }
                measDataListMap.put(measItemCode, measDataList);
            }
            response.setMeasPointId(measPointId);
            response.setMeasDataListMap(measDataListMap);
            measDataCumFreezeCurveGetRangeResponseList.add(response);
        }
        return measDataCumFreezeCurveGetRangeResponseList;
    }


}
