package com.gaea.iesms.bm.datacenter.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

/**
 * @description: json转化工具
 * @author: lifeng.du
 * @email: xxx@xx.com
 * @date: 2023/4/17 13:31
 */
public class JsonConvertUtils {


    private static final Logger logger = LoggerFactory.getLogger(JsonConvertUtils.class);

    public static String convertToString(Object object) {
        if(object == null) {
            return null;
        }
        try {
            return new ObjectMapper().registerModules().writeValueAsString(object);
        }
        catch(JsonProcessingException jpe) {
            logger.error(jpe.getMessage(), jpe.fillInStackTrace());
            return null;
        }
    }

    public static String convertToString(Object object, PropertyNamingStrategy propertyNamingStrategy) {
        if(object == null) {
            return null;
        }
        try {
            return new ObjectMapper().registerModules().setPropertyNamingStrategy(propertyNamingStrategy).setSerializationInclusion(JsonInclude.Include.NON_NULL).writeValueAsString(object);
        }
        catch(JsonProcessingException jpe) {
            logger.error(jpe.getMessage(), jpe.fillInStackTrace());
            return null;
        }
    }

    public static String convertToString(Object object, JsonInclude.Include include) {
        if(object == null) {
            return null;
        }
        try {
            return new ObjectMapper().setSerializationInclusion(include).writeValueAsString(object);
        }
        catch(JsonProcessingException jpe) {
            logger.error(jpe.getMessage(), jpe.fillInStackTrace());
            return null;
        }
    }

    public static String convertToString(Object object, Module... modules) {
        if(object == null) {
            return null;
        }
        try {
            return new ObjectMapper().registerModules(modules).writeValueAsString(object);
        }
        catch(JsonProcessingException jpe) {
            logger.error(jpe.getMessage(), jpe.fillInStackTrace());
            return null;
        }
    }

    public static String convertToString(Object object, JsonInclude.Include include, Module... modules) {
        if(object == null) {
            return null;
        }
        try {
            return new ObjectMapper().setSerializationInclusion(include).registerModules(modules).writeValueAsString(object);
        }
        catch(JsonProcessingException jpe) {
            logger.error(jpe.getMessage(), jpe.fillInStackTrace());
            return null;
        }
    }

    public static <T> T convertFromString(String content, Class<T> valueType) {
        if(valueType == null || content == null) {
            return null;
        }
        try {
            return new ObjectMapper().readValue(content, valueType);
        }
        catch(IOException ioe) {
            logger.error(ioe.getMessage(), ioe.fillInStackTrace());
            return null;
        }
    }

    public static <T> T convertFromString(String content, Class<T> valueType, Boolean acceptCaseInsensitiveProperties) {
        if(valueType == null || content == null) {
            return null;
        }
        try {
            // JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, acceptCaseInsensitiveProperties);
            return new ObjectMapper().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, acceptCaseInsensitiveProperties).readValue(content, valueType);
        }
        catch(IOException ioe) {
            logger.error(ioe.getMessage(), ioe.fillInStackTrace());
            return null;
        }
    }
}
