package com.gaea.iesms.bm.datacenter;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/4/11
 */
@EnableDiscoveryClient
@EnableFeignClients(basePackages = "com.gaea.iesms.core.feign.**")
@SpringBootApplication(scanBasePackages = {"com.gaea.iesms.bm.datacenter.**", "com.gaea.spring.cloud.starter.**"})
public class DataCenterStarter {

    public static void main(final String... args) {
        try {
            SpringApplication.run(DataCenterStarter.class, args);
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
}
