package com.gaea.iesms.bm.datacenter.config;

import com.easesource.data.id.generator.IdGenerator;
import com.gaea.iesms.bm.datacenter.utils.EaseDataCenterDataIdGenerator;
import com.gaea.iesms.bm.datacenter.utils.EaseDataCenterDeviceIdGenerator;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

/**
 * @author Nick Zhang
 * @date 2019-03-11
 */
@Configuration
public class IdGeneratorConfig {

    @Scope(value = ConfigurableBeanFactory.SCOPE_SINGLETON)
    @Bean(name = "datacenterDeviceIdGenerator")
    @Qualifier("datacenterDeviceIdGenerator")
    IdGenerator iotDeviceIdGenerator() {
        return new EaseDataCenterDeviceIdGenerator();
    }

    @Scope(value = ConfigurableBeanFactory.SCOPE_SINGLETON)
    @Bean(name = "datacenterDataIdGenerator")
    @Qualifier("datacenterDataIdGenerator")
    IdGenerator iotDataIdGenerator() {
        return new EaseDataCenterDataIdGenerator();
    }

}
