package com.gaea.iesms.bm.datacenter.controller;

import com.gaea.base.core.R;
import com.gaea.iesms.bm.datacenter.model.request.*;
import com.gaea.iesms.bm.datacenter.model.response.*;
import com.gaea.iesms.bm.datacenter.service.AccessMgmtService;
import com.gaea.iesms.core.feign.request.datacenter.*;
import com.gaea.iesms.core.feign.response.datacenter.RunAccessGatewayNameAndDescUpdateResponse;
import com.gaea.iesms.core.feign.response.datacenter.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @description: 接入设备管理
 * @author: lifeng.du
 * @email: xxx@xx.com
 * @date: 2023/4/18 9:46
 */
@Api(tags = "接入设备管理")
@RestController
@RequestMapping("/accessMgmt")
public class AccessMgmtController {

    @Autowired
    private AccessMgmtService accessMgmtService;

    /**
     * 查询接入网关设备资产
     *
     * @param devAccessGatewayQueryRequest
     *          接入网关设备资产查询请求
     * @return  接入网关设备资产查询回应
     */
    @PostMapping("/queryDevAccessGateway")
    @ApiOperation(value = "查询接入网关设备资产")
    public R<DevAccessGatewayQueryResponse> queryDevAccessGateway(@RequestBody DevAccessGatewayQueryRequest devAccessGatewayQueryRequest) {
        DevAccessGatewayQueryResponse response=accessMgmtService.queryDevAccessGateway(devAccessGatewayQueryRequest);
        return R.ok(response);
    }

    /**
     * 单个获取运行接入网关设备
     *
     * @param getRequest
     *          运行接入网关设备单个获取请求
     * @return  运行接入网关设备单个获取回应
     */
    @PostMapping("/getRunAccessGateway")
    @ApiOperation(value = "单个获取运行接入网关设备")
    public R<RunAccessGatewayGetResponse> getRunAccessGateway(@RequestBody RunAccessGatewayGetRequest getRequest) {
        RunAccessGatewayGetResponse response=accessMgmtService.getRunAccessGateway(getRequest);
        return R.ok(response);
    }

    /**
     * 单个修改运行接入网关设备
     *  修改接入网关设备名称、说明
     *
     * @param runAccessGatewayNameAndDescUpdateRequest
     *          运行接入网关设备修改获取请求
     * @return  运行接入网关设备修改获取回应
     */
    @PostMapping("/updateRunAccessGatewayNameAndDesc")
    @ApiOperation(value = "修改运行接入网关设备名称、说明")
    public R<RunAccessGatewayNameAndDescUpdateResponse> updateRunAccessGatewayNameAndDesc(@RequestBody RunAccessGatewayNameAndDescUpdateRequest runAccessGatewayNameAndDescUpdateRequest) {
        RunAccessGatewayNameAndDescUpdateResponse response=accessMgmtService.updateRunAccessGatewayNameAndDesc(runAccessGatewayNameAndDescUpdateRequest);
        return R.ok(response);
    }

    /**
     * 单个修改运行接入网关设备
     *  修改接入网关设备运行状态
     *
     * @param runAccessGatewayRunStatusUpdateRequest
     *          运行接入网关设备修改运行状态请求
     * @return  运行接入网关设备修改运行状态回应
     */
    @ApiOperation("修改接入网关设备运行状态")
    @PostMapping("/updateRunAccessGatewayRunStatus")
    public R updateRunAccessGatewayRunStatus(@RequestBody RunAccessGatewayRunStatusUpdateRequest runAccessGatewayRunStatusUpdateRequest) {
        RunAccessGatewayRunStatusUpdateResponse response = accessMgmtService.updateRunAccessGatewayRunStatus(runAccessGatewayRunStatusUpdateRequest);
        return R.ok(response);
    }

    /**
     * 单个修改运行接入网关设备
     *  修改接入网关设备运行工况信息
     *
     * @param runAccessGatewayOpsInfoUpdateRequest
     *          运行接入网关设备修改运行工况信息请求
     * @return  运行接入网关设备修改运行工况信息回应
     */
    @ApiOperation("修改接入网关设备运行工况信息")
    @PostMapping("/updateRunAccessGatewayOpsInfo")
    public R updateRunAccessGatewayOpsInfo( @RequestBody RunAccessGatewayOpsInfoUpdateRequest runAccessGatewayOpsInfoUpdateRequest) {
        RunAccessGatewayOpsInfoUpdateResponse response = accessMgmtService.updateRunAccessGatewayOpsInfo(runAccessGatewayOpsInfoUpdateRequest);
        return R.ok(response);
    }

    /**
     * 单个修改运行接入网关设备
     *  设置接入网关设备下线信息
     *
     * @param runAccessGatewayOfflineSetRequest
     *          运行接入网关设备设置下线信息
     * @return  运行接入网关设备设置下线信息
     */
    @ApiOperation("设置接入网关设备下线信息")
    @PostMapping("/setRunAccessGatewayOffline")
    public R setRunAccessGatewayOffline( @RequestBody  RunAccessGatewayOfflineSetRequest runAccessGatewayOfflineSetRequest) {
        RunAccessGatewayOfflineSetResponse response = accessMgmtService.setRunAccessGatewayOffline(runAccessGatewayOfflineSetRequest);
        return R.ok(response);
    }


    /**
     * 单个运行接入网关设备添加到系统单位
     *
     * @param runAccessGatewayAddToOrgRequest
     *          单个运行接入网关设备添加到系统单位请求
     * @return  单个运行接入网关设备添加到系统单位回应
     */
    @ApiOperation("单个运行接入网关设备添加到系统单位")
    @PostMapping("/addToOrgRunAccessGateway")
    public R addToOrgRunAccessGateway( @RequestBody  RunAccessGatewayAddToOrgRequest runAccessGatewayAddToOrgRequest) {
        RunAccessGatewayAddToOrgResponse response = accessMgmtService.addToOrgRunAccessGateway(runAccessGatewayAddToOrgRequest);
        return R.ok(response);
    }

    /**
     * 单个运行接入网关设备从系统单位中删除
     *
     * @param runAccessGatewayDeleteFromOrgRequest
     *          单个运行接入网关设备从系统单位中删除请求
     * @return  单个运行接入网关设备从系统单位中删除回应
     */
    @ApiOperation("单个运行接入网关设备从系统单位中删除")
    @PostMapping("/deleteFromOrgRunAccessGateway")
    public R deleteFromOrgRunAccessGateway( @RequestBody  RunAccessGatewayDeleteFromOrgRequest runAccessGatewayDeleteFromOrgRequest) {
        RunAccessGatewayDeleteFromOrgResponse response = accessMgmtService.deleteFromOrgRunAccessGateway(runAccessGatewayDeleteFromOrgRequest);
        return R.ok(response);
    }

    /**
     * 查询运行接入网关设备
     *
     * @param queryRequest
     *          运行接入网关设备查询请求
     * @return  运行接入网关设备查询回应
     */
    @ApiOperation("查询运行接入网关设备")
    @PostMapping("/queryRunAccessGateway")
    public R queryRunAccessGateway( @RequestBody  RunAccessGatewayQueryRequest queryRequest) {
        RunAccessGatewayQueryResponse response = accessMgmtService.queryRunAccessGateway(queryRequest);
        return R.ok(response);
    }

    /**
     * 单个获取运行量测点
     *
     * @param getRequest
     *          运行量测点单个获取请求
     * @return  运行量测点单个获取回应
     */
    @ApiOperation("单个获取运行量测点")
    @PostMapping("/getRunMeasPoint")
    public R getRunMeasPoint(@RequestBody RunMeasPointGetRequest getRequest) {
        RunMeasPointGetResponse response = accessMgmtService.getRunMeasPoint(getRequest);
        return R.ok(response);
    }

    /**
     * 单个修改运行量测点
     *  修改名称、说明
     *
     * @param runMeasPointNameAndDescUpdateRequest
     *          运行量测点单个获取请求
     * @return  运行量测点单个获取回应
     */
    @ApiOperation("修改运行量测点名称、说明")
    @PostMapping("/updateRunMeasPointNameAndDesc")
    public R updateRunMeasPointNameAndDesc( @RequestBody  RunMeasPointNameAndDescUpdateRequest runMeasPointNameAndDescUpdateRequest) {
        RunMeasPointNameAndDescUpdateResponse response = accessMgmtService.updateRunMeasPointNameAndDesc(runMeasPointNameAndDescUpdateRequest);
        return R.ok(response);
    }

    /**
     * 批量修改运行量测点
     *
     * @param runMeasPointOpsInfoBatchUpdateRequest
     *          运行量测点单个获取请求
     * @return  运行量测点单个获取回应
     */
    @ApiOperation("批量修改运行量测点名称、说明")
    @PostMapping("/batchUpdateRunMeasPointOpsInfo")
    public R<RunMeasPointOpsInfoBatchUpdateResponse> batchUpdateRunMeasPointOpsInfo( @RequestBody  RunMeasPointOpsInfoBatchUpdateRequest runMeasPointOpsInfoBatchUpdateRequest) {
        RunMeasPointOpsInfoBatchUpdateResponse response = accessMgmtService.batchUpdateRunMeasPointOpsInfo(runMeasPointOpsInfoBatchUpdateRequest);
        return R.ok(response);
    }


    /**
     * 单个修改运行量测点
     *  修改名称、说明
     *
     * @param runMeasPointOpsInfoUpdateRequest
     *          运行量测点单个获取请求
     * @return  运行量测点单个获取回应
     */
    @ApiOperation("修改名称、说明")
    @PostMapping("/updateRunMeasPointOpsInfo")
    public R<RunMeasPointOpsInfoUpdateResponse> updateRunMeasPointOpsInfo( @RequestBody RunMeasPointOpsInfoUpdateRequest runMeasPointOpsInfoUpdateRequest) {
        RunMeasPointOpsInfoUpdateResponse response = accessMgmtService.updateRunMeasPointOpsInfo(runMeasPointOpsInfoUpdateRequest);
        return R.ok(response);
    }


}
