package com.gaea.iesms.bm.datacenter.mapper;

import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.gaea.iesms.core.feign.request.datacenter.EditMeterRequest;
import com.gaea.iesms.core.model.entity.datacenter.RunMeasPointChangeLogDo;
import com.gaea.iesms.core.model.entity.datacenter.RunMeasPointDo;
import com.gaea.iesms.core.feign.response.datacenter.RunMeasPointVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-08
 */
@Mapper
public interface RunMeasPointDao extends CrudMapper<RunMeasPointDo, Long> {


    int deleteById(Long id);

    RunMeasPointVo getRunMeasPointJALAByMeasPointId(@Param("id") Long id);

    RunMeasPointVo getRunMeasPointVoByMeasPointId(Long id);

    List<RunMeasPointVo> getRunMeasPointVoListByAccessGatewayId(@Param("accessGatewayId") Long accessGatewayId);

    List<RunMeasPointVo> getRunMeasPointVoListByOrgNoAndDevAccessGatewaySortNoAndDevAccessGatewayNo(@Param("orgNo") String orgNo, @Param("devAccessGatewaySortNo") String devAccessGatewaySortNo, @Param("devAccessGatewayNo") String devAccessGatewayNo);

    List<RunMeasPointVo> getRunMeasPointVoListByProductKeyAndClientId(@Param("productKey") String productKey, @Param("clientId") String clientId);

    List<RunMeasPointVo> getRunMeasPointVoListByProductKeyAndUpcommProtoAndUpcommLogicAddr(@Param("productKey") String productKey, @Param("upcommProto") String upcommProto, @Param("upcommLogicAddr") String upcommLogicAddr);

    void brushMeasPoint(@Param("id") long id,@Param("devTermCommAddr")String mac,@Param("devMeterCommAddr")String devMeterCommAddr);


    List<RunMeasPointVo> getRunMeasPointListBySn(@Param("sn") String sn,@Param("isMeter") String isMeter);


    void insertRunMeasPointLog(@Param("runMeasPointChangeLogDo") RunMeasPointChangeLogDo runMeasPointChangeLogDo);

    Set<Long> getRunAccessGatewayMeasPointIds(@Param("gatewayIdSet") Set<Long> gatewayIdSet);

    int batchUpdateRunMeasPointOpsInfo(@Param("measPointIdList") List<Long> measPointIdList, @Param("gmtMessageUp") Long gmtMessageUp, @Param("gmtMeasdataUp") Long gmtMeasdataUp, @Param("gmtAlarmUp") Long gmtAlarmUp, @Param("gmtModified") Long gmtModified);

    List<RunMeasPointVo> batchGetRunMeasPointVoListByMeasPointIdList(@Param("measPointIdList") List<Long> measPointIdList);

    void editMeter(@Param("editMeterRequest") EditMeterRequest editMeterRequest);

    String getMeasItemType(@Param("measItemCode") String measItemCode);
}
