package com.gaea.iesms.bm.datacenter.config;

import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

import javax.sql.DataSource;

/**
 * @author Nick Zhang
 * @date 2019-02-28
 */
@Configuration
@MapperScan(basePackages = {"com.gaea.iesms.bm.datacenter.mapper"}, sqlSessionTemplateRef = "easesystemSqlSessionTemplate")
public class EaseSystemMyBatisSqlSessionConfig {

    @Bean(name = "easesystemSqlSessionFactory")
    @Qualifier("easesystemSqlSessionFactory")
    public SqlSessionFactory easesystemSqlSessionFactory(@Qualifier("easesystemDataSource") DataSource easesystemDataSource) throws Exception {
        SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
        org.apache.ibatis.session.Configuration mybatisGlobalConfiguration = new org.apache.ibatis.session.Configuration();
        mybatisGlobalConfiguration.setCallSettersOnNulls(true);
        mybatisGlobalConfiguration.setMapUnderscoreToCamelCase(true);
        bean.setConfiguration(mybatisGlobalConfiguration);
        bean.setDataSource(easesystemDataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:com/gaea/iesms/bm/datacenter/mapper/*Mapper.xml"));
        return bean.getObject();
    }

    @Bean(name = "easesystemSqlSessionTemplate")
    @Qualifier("easesystemSqlSessionTemplate")
    public SqlSessionTemplate easesystemSqlSessionTemplate(@Qualifier("easesystemSqlSessionFactory") SqlSessionFactory easesystemSqlSessionFactory) {
        return new SqlSessionTemplate(easesystemSqlSessionFactory);
    }

}
