package com.gaea.iesms.bm.datacenter.service;

import com.gaea.iesms.core.feign.request.datacenter.*;
import com.gaea.iesms.core.feign.response.datacenter.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 量测数据
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
public interface MeasDataService {

    /**
     * 获取量测点最新数据
     * @param measDataLatestGetRequest
     *          获取量测点最新数据请求
     * @return  获取量测点最新数据回应
     */
    MeasDataLatestGetResponse getMeasDataLatest(MeasDataLatestGetRequest measDataLatestGetRequest);

    /**
     * 批量获取量测点最新数据
     * @param measDataLatestBatchGetRequest
     *          批量获取量测点最新数据请求
     * @return  批量获取量测点最新数据回应
     */
    MeasDataLatestBatchGetResponse batchGetMeasDataLatest(MeasDataLatestBatchGetRequest measDataLatestBatchGetRequest);


    /**
     * 获取瞬时量曲线数据（时间点）
     * @param measDataInsFreezeCurveGetRequest
     *          获取瞬时量曲线数据请求
     * @return  获取瞬时量曲线数据回应
     */
    MeasDataInsFreezeCurveGetResponse getMeasDataInsFreezeCurve(MeasDataInsFreezeCurveGetRequest measDataInsFreezeCurveGetRequest);

    /**
     * 获取瞬时量曲线数据（时间范围）
     * @param measDataInsFreezeCurveGetRangeRequest
     *          获取瞬时量曲线数据请求
     * @return  获取瞬时量曲线数据回应
     */
    MeasDataInsFreezeCurveGetRangeResponse getRangeMeasDataInsFreezeCurve(MeasDataInsFreezeCurveGetRangeRequest measDataInsFreezeCurveGetRangeRequest);

    /**
     * 批量获取瞬时量曲线数据（时间范围）
     * @param measDataInsFreezeCurveGetRangeRequest
     *          获取瞬时量曲线数据请求
     * @return  获取瞬时量曲线数据回应
     */
    MeasDataInsFreezeCurveGetRangeListResponse getRangeMeasDataInsFreezeCurveList(List<MeasDataInsFreezeCurveGetRangeRequest> measDataInsFreezeCurveGetRangeRequest);


    /**
     * 获取累计量曲线数据（时间点）
     * @param measDataCumFreezeCurveGetRequest
     *          获取累计量曲线数据请求
     * @return  获取累计量曲线数据回应
     */
    MeasDataCumFreezeCurveGetResponse getMeasDataCumFreezeCurve(MeasDataCumFreezeCurveGetRequest measDataCumFreezeCurveGetRequest);

    /**
     * 批量（多量测点）获取累计量曲线数据（时间点）
     * @param measDataCumFreezeCurveBatchGetRequest
     *          批量（多量测点）获取累计量曲线数据请求
     * @return  批量（多量测点）获取累计量曲线数据回应
     */
    MeasDataCumFreezeCurveBatchGetResponse batchGetMeasDataCumFreezeCurve(MeasDataCumFreezeCurveBatchGetRequest measDataCumFreezeCurveBatchGetRequest);

    /**
     * 获取累计量曲线数据（时间范围）
     * @param measDataCumFreezeCurveGetRangeRequest
     *          获取累计量曲线数据请求
     * @return  获取累计量曲线数据回应
     */
    MeasDataCumFreezeCurveGetRangeResponse getRangeMeasDataCumFreezeCurve(MeasDataCumFreezeCurveGetRangeRequest measDataCumFreezeCurveGetRangeRequest);


    /**
     * 调用接口，获取数据并将相同数据项的数据求和，
     * 如果是电压，功率因数，温度则取最大值和最小值
     * gen_watt_u gen_watt_temp gen_watt_pf
     *
     * @param measItemCodeSet
     * @param measIdList
     */
    Map<String, BigDecimal> getValueSum(Set<String> measItemCodeSet, Set<String> measIdList);

    /**
     * 获取累计量曲线数据（时间范围）
     * @param measDataCumFreezeCurveBatchGetRangeRequest
     *          获取累计量曲线数据请求
     * @return  获取累计量曲线数据回应
     */
    List<MeasDataCumFreezeCurveGetRangeResponse> batchGetRangeMeasDataCumFreezeCurve(MeasDataCumFreezeCurveBatchGetRangeRequest measDataCumFreezeCurveBatchGetRangeRequest);
}
