package com.gaea.iesms.bm.datacenter.service.impl;


import com.gaea.base.core.R;
import com.gaea.iesms.bm.datacenter.mapper.*;
import com.gaea.iesms.bm.datacenter.model.request.*;
import com.gaea.iesms.bm.datacenter.model.response.*;
import com.gaea.iesms.bm.datacenter.service.AbstractBaseService;
import com.gaea.iesms.bm.datacenter.service.AccessMgmtService;
import com.gaea.iesms.bm.datacenter.utils.JsonConvertUtils;
import com.gaea.iesms.core.feign.enums.TopicEnum;
import com.gaea.iesms.core.feign.request.datacenter.*;
import com.gaea.iesms.core.feign.request.iot.RemoteGmDevMeterGetRequest;
import com.gaea.iesms.core.feign.request.iot.RemoteGmDevMeterRequest;
import com.gaea.iesms.core.feign.response.datacenter.RunAccessGatewayNameAndDescUpdateResponse;
import com.gaea.iesms.core.feign.response.datacenter.RunMeasPointOpsInfoUpdateResponse;
import com.gaea.iesms.core.feign.response.datacenter.*;
import com.gaea.iesms.core.feign.response.iot.RemoteGmDevMeterGetResponse;
import com.gaea.iesms.core.feign.response.iot.RemoteGmDevMeterVo;
import com.gaea.iesms.core.feign.service.RemoteIotService;
import com.gaea.iesms.core.model.entity.datacenter.*;
import com.gaea.iesms.core.model.entity.iot.GmDevTerm;
import com.gaea.utils.ObjectUtils;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 *
 * @author Nick Zhang
 */
@Service(value = "accessMgmtService")
public class AccessMgmtServiceImpl extends AbstractBaseService implements AccessMgmtService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private DevAccessDao devAccessDao;

    @Resource
    private DevAccessGatewayDao devAccessGatewayDao;

    @Resource
    private DevAccessTrunkingDao devAccessTrunkingDao;

    @Resource
    private DevAccessMeasureDao devAccessMeasureDao;

    @Resource
    private RunAccessGatewayDao runAccessGatewayDao;

    @Resource
    private RunMeasPointDao runMeasPointDao;

    @Resource
    private RemoteIotService remoteIotService;

    @Override
    public DevAccessGatewayQueryResponse queryDevAccessGateway(DevAccessGatewayQueryRequest devAccessGatewayQueryRequest) {
        DevAccessGatewayQueryResponse response = new DevAccessGatewayQueryResponse();
        response.setReturnCode("SUCCESS");
        return response;
    }

    @Override
    public RunAccessGatewayGetResponse getRunAccessGateway(RunAccessGatewayGetRequest getRequest) {
        RunAccessGatewayGetResponse getResponse = new RunAccessGatewayGetResponse();
        getResponse.setReturnCode("FAILURE");
        getResponse.setFailureCode("-1");
        if(getRequest != null && getRequest.getDevAccessId() != null && getRequest.getDevAccessId() > 0L) {
            RunAccessGatewayVo runAccessGateway = runAccessGatewayDao.getRunAccessGatewayVoById(getRequest.getDevAccessId());
            List<RunMeasPointVo> runMeasPointList = runMeasPointDao.getRunMeasPointVoListByAccessGatewayId(getRequest.getDevAccessId());
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunAccessGateway(runAccessGateway);
            getResponse.setRunMeasPointList(runMeasPointList);
        }
        else if(getRequest != null && !StringUtils.isAnyBlank(getRequest.getOrgNo(), getRequest.getDevAccessSortNo(), getRequest.getDevAccessNo())) {
            RunAccessGatewayVo runAccessGateway = runAccessGatewayDao.getRunAccessGatewayVoByOrgNoAndDevAccessSortNoAndDevAccessNo(getRequest.getOrgNo(), getRequest.getDevAccessSortNo(), getRequest.getDevAccessNo());
            List<RunMeasPointVo> runMeasPointList = runMeasPointDao.getRunMeasPointVoListByOrgNoAndDevAccessGatewaySortNoAndDevAccessGatewayNo(getRequest.getOrgNo(), getRequest.getDevAccessSortNo(), getRequest.getDevAccessNo());
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunAccessGateway(runAccessGateway);
            getResponse.setRunMeasPointList(runMeasPointList);
        }
        else if(getRequest != null && !StringUtils.isAnyBlank(getRequest.getProductKey(), getRequest.getClientId())) {
            RunAccessGatewayVo runAccessGateway = runAccessGatewayDao.getRunAccessGatewayVoByProductKeyAndClientId(getRequest.getProductKey(), getRequest.getClientId());
            List<RunMeasPointVo> runMeasPointList = runMeasPointDao.getRunMeasPointVoListByProductKeyAndClientId(getRequest.getProductKey(), getRequest.getClientId());
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunAccessGateway(runAccessGateway);
            getResponse.setRunMeasPointList(runMeasPointList);
        }
        else if(getRequest != null && !StringUtils.isAnyBlank(getRequest.getProductKey(), getRequest.getUpcommProto(), getRequest.getUpcommLogicAddr())) {
            RunAccessGatewayVo runAccessGateway = runAccessGatewayDao.getRunAccessGatewayVoByProductKeyAndUpcommProtoAndUpcommLogicAddr(getRequest.getProductKey(), getRequest.getUpcommProto(), getRequest.getUpcommLogicAddr());
            List<RunMeasPointVo> runMeasPointList = runMeasPointDao.getRunMeasPointVoListByProductKeyAndUpcommProtoAndUpcommLogicAddr(getRequest.getProductKey(), getRequest.getUpcommProto(), getRequest.getUpcommLogicAddr());
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunAccessGateway(runAccessGateway);
            getResponse.setRunMeasPointList(runMeasPointList);
        }
        return getResponse;
    }

    @Override
    public RunAccessGatewayNameAndDescUpdateResponse updateRunAccessGatewayNameAndDesc(RunAccessGatewayNameAndDescUpdateRequest runAccessGatewayNameAndDescUpdateRequest) {

        RunAccessGatewayNameAndDescUpdateResponse response = new RunAccessGatewayNameAndDescUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long devAccessId = runAccessGatewayNameAndDescUpdateRequest.getDevAccessId();
        if(devAccessId != null && devAccessId > 0L) {
            DevAccessDo devAccessDo = devAccessDao.get(devAccessId);
            if(devAccessDo != null && StringUtils.isNotBlank(runAccessGatewayNameAndDescUpdateRequest.getNewDevAccessName())) {
                devAccessDo.setDevAccessName(runAccessGatewayNameAndDescUpdateRequest.getNewDevAccessName());
            }
            if(devAccessDo != null && StringUtils.isNotBlank(runAccessGatewayNameAndDescUpdateRequest.getNewDevAccessDesc())) {
                devAccessDo.setDevAccessDesc(runAccessGatewayNameAndDescUpdateRequest.getNewDevAccessDesc());
            }
            devAccessDao.update(devAccessDo);
            RunAccessGatewayVo runAccessGatewayVo = runAccessGatewayDao.getRunAccessGatewayVoById(devAccessId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunAccessGateway(runAccessGatewayVo);
        }
        return response;
    }

    @Override
    public RunAccessGatewayRunStatusUpdateResponse updateRunAccessGatewayRunStatus(RunAccessGatewayRunStatusUpdateRequest runAccessGatewayRunStatusUpdateRequest) {
        RunAccessGatewayRunStatusUpdateResponse response = new RunAccessGatewayRunStatusUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long devAccessId = runAccessGatewayRunStatusUpdateRequest.getDevAccessId();
        if(devAccessId != null && devAccessId > 0L) {
            RunAccessGatewayDo runAccessGatewayDo = runAccessGatewayDao.get(devAccessId);
            if(runAccessGatewayDo != null) {
                runAccessGatewayDo.setRunStatus(runAccessGatewayRunStatusUpdateRequest.getRunStatus());
                runAccessGatewayDo.setGmtModified(System.currentTimeMillis());
                runAccessGatewayDao.update(runAccessGatewayDo);
            }
            RunAccessGatewayVo runAccessGatewayVo = runAccessGatewayDao.getRunAccessGatewayVoById(devAccessId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunAccessGateway(runAccessGatewayVo);
        }
        return response;
    }

    @Override
    public RunAccessGatewayOpsInfoUpdateResponse updateRunAccessGatewayOpsInfo(RunAccessGatewayOpsInfoUpdateRequest runAccessGatewayOpsInfoUpdateRequest) {
        RunAccessGatewayOpsInfoUpdateResponse response = new RunAccessGatewayOpsInfoUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long devAccessId = runAccessGatewayOpsInfoUpdateRequest.getDevAccessId();
        if(devAccessId != null && devAccessId > 0L) {
            RunAccessGatewayDo runAccessGatewayDo = runAccessGatewayDao.get(devAccessId);
            if(runAccessGatewayDo != null) {
                if(StringUtils.isNotBlank(runAccessGatewayOpsInfoUpdateRequest.getRunParam())) {
                    runAccessGatewayDo.setRunParam(runAccessGatewayOpsInfoUpdateRequest.getRunParam());
                }
                if(StringUtils.isNotBlank(runAccessGatewayOpsInfoUpdateRequest.getRunClientIp())) {
                    runAccessGatewayDo.setRunClientIp(runAccessGatewayOpsInfoUpdateRequest.getRunClientIp());
                }
                if(ObjectUtils.isNotNull(runAccessGatewayOpsInfoUpdateRequest.getRunClientPort())) {
                    runAccessGatewayDo.setRunClientPort(runAccessGatewayOpsInfoUpdateRequest.getRunClientPort());
                }
                if(StringUtils.isNotBlank(runAccessGatewayOpsInfoUpdateRequest.getRunServerIp())) {
                    runAccessGatewayDo.setRunServerIp(runAccessGatewayOpsInfoUpdateRequest.getRunServerIp());
                }
                if(ObjectUtils.isNotNull(runAccessGatewayOpsInfoUpdateRequest.getRunServerPort())) {
                    runAccessGatewayDo.setRunServerPort(runAccessGatewayOpsInfoUpdateRequest.getRunServerPort());
                }
                if(StringUtils.isNotBlank(runAccessGatewayOpsInfoUpdateRequest.getRunServerApn())) {
                    runAccessGatewayDo.setRunServerApn(runAccessGatewayOpsInfoUpdateRequest.getRunServerApn());
                }
                if(StringUtils.isNotBlank(runAccessGatewayOpsInfoUpdateRequest.getSoftwareVer())) {
                    runAccessGatewayDo.setSoftwareVer(runAccessGatewayOpsInfoUpdateRequest.getSoftwareVer());
                }
                if(StringUtils.isNotBlank(runAccessGatewayOpsInfoUpdateRequest.getHardwareVer())) {
                    runAccessGatewayDo.setHardwareVer(runAccessGatewayOpsInfoUpdateRequest.getHardwareVer());
                }
                if(ObjectUtils.isNotNull(runAccessGatewayOpsInfoUpdateRequest.getGmtConnectedAt())) {
                    runAccessGatewayDo.setOnline(true);
                    runAccessGatewayDo.setGmtConnectedAt(runAccessGatewayOpsInfoUpdateRequest.getGmtConnectedAt());
                }
                if(ObjectUtils.isNotNull(runAccessGatewayOpsInfoUpdateRequest.getGmtHeartbeatUp())) {
                    runAccessGatewayDo.setOnline(true);
                    runAccessGatewayDo.setGmtHeartbeatUp(runAccessGatewayOpsInfoUpdateRequest.getGmtHeartbeatUp());
                }
                if(ObjectUtils.isNotNull(runAccessGatewayOpsInfoUpdateRequest.getGmtMessageUp())) {
                    runAccessGatewayDo.setOnline(true);
                    runAccessGatewayDo.setGmtMessageUp(runAccessGatewayOpsInfoUpdateRequest.getGmtMessageUp());
                }
                if(ObjectUtils.isNotNull(runAccessGatewayOpsInfoUpdateRequest.getGmtMeasdataUp())) {
                    runAccessGatewayDo.setOnline(true);
                    runAccessGatewayDo.setGmtMeasdataUp(runAccessGatewayOpsInfoUpdateRequest.getGmtMeasdataUp());
                }
                if(ObjectUtils.isNotNull(runAccessGatewayOpsInfoUpdateRequest.getGmtAlarmUp())) {
                    runAccessGatewayDo.setOnline(true);
                    runAccessGatewayDo.setGmtAlarmUp(runAccessGatewayOpsInfoUpdateRequest.getGmtAlarmUp());
                }
                runAccessGatewayDo.setGmtModified(System.currentTimeMillis());
                runAccessGatewayDao.update(runAccessGatewayDo);
            }
            RunAccessGatewayVo runAccessGatewayVo = runAccessGatewayDao.getRunAccessGatewayVoById(devAccessId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunAccessGateway(runAccessGatewayVo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" RunAccessGatewayOpsInfoUpdateResponse        : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end updateRunAccessGatewayOpsInfo <<<<<<<< ");
        }
        return response;
    }

    @Override
    public RunAccessGatewayOfflineSetResponse setRunAccessGatewayOffline(RunAccessGatewayOfflineSetRequest runAccessGatewayOfflineSetRequest) {
        RunAccessGatewayOfflineSetResponse response = new RunAccessGatewayOfflineSetResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long devAccessId = runAccessGatewayOfflineSetRequest.getDevAccessId();
        if(devAccessId != null && devAccessId > 0L) {
            RunAccessGatewayDo runAccessGatewayDo = runAccessGatewayDao.get(devAccessId);
            if(runAccessGatewayDo != null) {
                runAccessGatewayDo.setOnline(false);
                runAccessGatewayDo.setGmtOffline(runAccessGatewayOfflineSetRequest.getGmtOffline());
                runAccessGatewayDo.setGmtModified(System.currentTimeMillis());
                runAccessGatewayDao.update(runAccessGatewayDo);
            }
            RunAccessGatewayVo runAccessGatewayVo = runAccessGatewayDao.getRunAccessGatewayVoById(devAccessId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunAccessGateway(runAccessGatewayVo);
        }
        return response;
    }

    @Override
    public RunAccessGatewayAddToOrgResponse addToOrgRunAccessGateway(RunAccessGatewayAddToOrgRequest runAccessGatewayAddToOrgRequest) {
        RunAccessGatewayAddToOrgResponse response = new RunAccessGatewayAddToOrgResponse();
        response.setReturnCode("SUCCESS");
        return response;
    }

    @Override
    public RunAccessGatewayDeleteFromOrgResponse deleteFromOrgRunAccessGateway(RunAccessGatewayDeleteFromOrgRequest runAccessGatewayDeleteFromOrgRequest) {
        RunAccessGatewayDeleteFromOrgResponse response = new RunAccessGatewayDeleteFromOrgResponse();
        response.setReturnCode("SUCCESS");
        return response;
    }

    @Override
    public RunAccessGatewayQueryResponse queryRunAccessGateway(RunAccessGatewayQueryRequest queryRequest) {
        RunAccessGatewayQueryResponse queryResponse = new RunAccessGatewayQueryResponse();
        queryResponse.setReturnCode("FAILURE");
        queryResponse.setFailureCode("-1");
        Set<Long> devAccessIdSet = queryRequest.getDevAccessIdSet();
        Set<String> orgNoSet = queryRequest.getOrgNoSet();
        Set<String> devAccessSortNoSet = queryRequest.getDevAccessSortNoSet();
        Set<String> devAccessNoSet = queryRequest.getDevAccessNoSet();
        Set<String> productKeySet = queryRequest.getProductKeySet();
        Set<String> clientIdSet = queryRequest.getClientIdSet();
        Map<String, Object> params = Maps.newHashMap();
        if(devAccessIdSet != null && devAccessIdSet.size() > 0) {
            params.put("devAccessId", devAccessIdSet.iterator().next());
        }
        else if(orgNoSet != null && orgNoSet.size() > 0) {
            params.put("orgNo", orgNoSet.iterator().next());
        }
        else if(devAccessSortNoSet != null && devAccessSortNoSet.size() > 0) {
            params.put("devAccessSortNo", devAccessSortNoSet.iterator().next());
        }
        else if(devAccessNoSet != null && devAccessNoSet.size() > 0) {
            params.put("devAccessNo", devAccessNoSet.iterator().next());
        }
        else if(productKeySet != null && productKeySet.size() > 0) {
            params.put("productKey", productKeySet.iterator().next());
        }
        else if(clientIdSet != null && clientIdSet.size() > 0) {
            params.put("clientId", clientIdSet.iterator().next());
        }
        int runAccessGatewayVoCount = runAccessGatewayDao.getRunAccessGatewayVoCount(params);
        List<RunAccessGatewayVo> runAccessGatewayVoList = runAccessGatewayDao.getRunAccessGatewayVoList(params, null, null);
        queryResponse.setReturnCode("SUCCESS");
        queryResponse.setFailureCode(null);
        queryResponse.setRunAccessGatewayCount(runAccessGatewayVoCount);
        queryResponse.setRunAccessGatewayList(runAccessGatewayVoList);
        return queryResponse;
    }

    @Override
    public RunMeasPointGetResponse getRunMeasPoint(RunMeasPointGetRequest getRequest) {
        RunMeasPointGetResponse getResponse = new RunMeasPointGetResponse();
        getResponse.setReturnCode("FAILURE");
        getResponse.setFailureCode("-1");
        Long measPointId = getRequest.getMeasPointId();
        if(measPointId != null && measPointId > 0L) {
            RunMeasPointVo runMeasPointVo = runMeasPointDao.getRunMeasPointVoByMeasPointId(measPointId);
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunMeasPoint(runMeasPointVo);
        }
        return getResponse;
    }

    @Override
    public List<RunMeasPointDo> getRunMeasPointList(String accessGatewayId) {
        Map<String, Object> param=new HashMap<>();
        param.put("accessGatewayId",accessGatewayId);
        List<RunMeasPointDo> list = runMeasPointDao.getList(param, null, null);
        return list;
    }

    @Override
    public RunMeasPointNameAndDescUpdateResponse updateRunMeasPointNameAndDesc(RunMeasPointNameAndDescUpdateRequest runMeasPointNameAndDescUpdateRequest) {
        RunMeasPointNameAndDescUpdateResponse response = new RunMeasPointNameAndDescUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long measPointId = runMeasPointNameAndDescUpdateRequest.getMeasPointId();
        if(measPointId != null && measPointId > 0L) {
            RunMeasPointDo runMeasPointDo = runMeasPointDao.get(measPointId);
            if(runMeasPointDo != null && runMeasPointDo.getAccessMeasureId() != null && runMeasPointDo.getAccessMeasureId() > 0L) {
                Long accessMeasureId = runMeasPointDo.getAccessMeasureId();
                DevAccessDo devAccessDo = devAccessDao.get(accessMeasureId);
                if(devAccessDo != null && StringUtils.isNotBlank(runMeasPointNameAndDescUpdateRequest.getNewAccessMeasureName())) {
                    devAccessDo.setDevAccessName(runMeasPointNameAndDescUpdateRequest.getNewAccessMeasureName());
                }
                if(devAccessDo != null && StringUtils.isNotBlank(runMeasPointNameAndDescUpdateRequest.getNewAccessMeasureDesc())) {
                    devAccessDo.setDevAccessDesc(runMeasPointNameAndDescUpdateRequest.getNewAccessMeasureDesc());
                }
                devAccessDao.update(devAccessDo);
            }

            RunMeasPointVo runMeasPointVo = runMeasPointDao.getRunMeasPointVoByMeasPointId(measPointId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunMeasPoint(runMeasPointVo);
        }
        return response;
    }

    @Override
    public RunMeasPointOpsInfoUpdateResponse updateRunMeasPointOpsInfo(RunMeasPointOpsInfoUpdateRequest runMeasPointOpsInfoUpdateRequest) {
        RunMeasPointOpsInfoUpdateResponse response = new RunMeasPointOpsInfoUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long measPointId = runMeasPointOpsInfoUpdateRequest.getMeasPointId();
        if(measPointId != null && measPointId > 0L) {
            RunMeasPointDo runMeasPointDo = runMeasPointDao.get(measPointId);
            if(runMeasPointDo != null && runMeasPointDo.getAccessMeasureId() != null && runMeasPointDo.getAccessMeasureId() > 0L) {
                if(ObjectUtils.isNotNull(runMeasPointOpsInfoUpdateRequest.getGmtMessageUp())) {
                    runMeasPointDo.setGmtMessageUp(runMeasPointOpsInfoUpdateRequest.getGmtMessageUp());
                }
                if(ObjectUtils.isNotNull(runMeasPointOpsInfoUpdateRequest.getGmtMeasdataUp())) {
                    runMeasPointDo.setGmtMeasdataUp(runMeasPointOpsInfoUpdateRequest.getGmtMeasdataUp());
                }
                if(ObjectUtils.isNotNull(runMeasPointOpsInfoUpdateRequest.getGmtAlarmUp())) {
                    runMeasPointDo.setGmtAlarmUp(runMeasPointOpsInfoUpdateRequest.getGmtAlarmUp());
                }
                runMeasPointDo.setGmtModified(System.currentTimeMillis());
                runMeasPointDao.update(runMeasPointDo);
            }

            RunMeasPointVo runMeasPointVo = runMeasPointDao.getRunMeasPointVoByMeasPointId(measPointId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunMeasPoint(runMeasPointVo);
        }
        return response;
    }

    @Override
    public RunMeasPointOpsInfoBatchUpdateResponse batchUpdateRunMeasPointOpsInfo(RunMeasPointOpsInfoBatchUpdateRequest runMeasPointOpsInfoBatchUpdateRequest) {
        RunMeasPointOpsInfoBatchUpdateResponse response = new RunMeasPointOpsInfoBatchUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        List<Long> measPointIdList = runMeasPointOpsInfoBatchUpdateRequest.getMeasPointIdList();
        if(measPointIdList != null && measPointIdList.size() > 0) {
            runMeasPointDao.batchUpdateRunMeasPointOpsInfo(measPointIdList, runMeasPointOpsInfoBatchUpdateRequest.getGmtMessageUp(), runMeasPointOpsInfoBatchUpdateRequest.getGmtMeasdataUp(), runMeasPointOpsInfoBatchUpdateRequest.getGmtAlarmUp(), System.currentTimeMillis());
            List<RunMeasPointVo> runMeasPointVoList = runMeasPointDao.batchGetRunMeasPointVoListByMeasPointIdList(measPointIdList);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunMeasPointList(runMeasPointVoList);
        }
        return response;
    }
    @Resource
    private DataSourceTransactionManager transactionManager;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public R<BrushMeterResponse> brushMeter(String mac, String key,String topic,String devMeterCommProto) {


        long accessMeasureId = datacenterDeviceIdGenerator.nextId();
        long runMeasPointId=datacenterDeviceIdGenerator.nextId();
        long now = System.currentTimeMillis();
        devMeterCommProto = StringUtils.isEmpty(devMeterCommProto)?TopicEnum.findMeterCommProto(topic):devMeterCommProto;
//        devMeterCommProto=StringUtils.isEmpty(topic)?null: TopicEnum.findMeterCommProto(topic);
        R<GmDevTerm> gmDevTermR = remoteIotService.selectOneGmDevTerm(mac);
        GmDevTerm gmDevTerm=gmDevTermR.getData();
        //获取终端相关信息
        if (StringUtils.isEmpty(devMeterCommProto)){
            RemoteGmDevMeterGetResponse remoteGmDevMeterGetResponse=new RemoteGmDevMeterGetResponse();
            try {
                RemoteGmDevMeterGetRequest remoteGmDevMeterGetRequest=new RemoteGmDevMeterGetRequest();
                remoteGmDevMeterGetRequest.setDevMeterNo(key);
                remoteGmDevMeterGetRequest.setOrgNo(gmDevTerm.getOrgNo());
                R<RemoteGmDevMeterGetResponse> gmDevMeter = remoteIotService.getGmDevMeter(remoteGmDevMeterGetRequest);
                remoteGmDevMeterGetResponse= gmDevMeter.getData()!=null?gmDevMeter.getData():null;

            }catch (Exception e){
                System.out.println(e.getMessage());
            }
            if (remoteGmDevMeterGetResponse!=null){
                RemoteGmDevMeterVo devMeter = remoteGmDevMeterGetResponse.getGmDevMeter()!=null?remoteGmDevMeterGetResponse.getGmDevMeter():null;
                devMeterCommProto=(devMeter==null||StringUtils.isEmpty(devMeter.getDevMeterCommProto()))?"EMT6SERIES":devMeter.getDevMeterCommProto();
            }
        }
//        devMeterCommProto=StringUtils.isEmpty(devMeterCommProto)?gmDevTerm.getDevTermCommProto():devMeterCommProto;

        BrushMeterResponse brushMeterResponse=new BrushMeterResponse();
        RemoteGmDevMeterRequest remoteGmDevMeterRequest=RemoteGmDevMeterRequest.builder()
                .orgNo(gmDevTerm.getOrgNo())
                .devTermNo(mac)
                .devMeterNo(key)
                .devMeterName(key)
                .devMeterStatus(3)
                .devMeterType(1)
                .devMeterCommMode(gmDevTerm.getDevTermCommMode().toString())
                .devMeterCommProto(devMeterCommProto)
                .devMeterCommAddr(key)
                .selfRate(BigDecimal.valueOf(1))
                .ctRate(BigDecimal.valueOf(1))
                .ptRate(BigDecimal.valueOf(1))
                .accessGatewayId(gmDevTerm.getAccessGatewayId())
                .accessMeasureId(accessMeasureId)
                .measPointId(runMeasPointId)
                .measKind(1)
//                .measSn(Integer.valueOf(key))
                .sortSn(1)
                .modelCode(gmDevTerm.getModelCode())
                .isValid(true)
                .build();
//        System.out.println(remoteGmDevMeterRequest.toString());
//        R r = remoteIotService.insertOrUpdateGmDevMeter(remoteGmDevMeterRequest);
//        if (!r.isSuccess()){
//           return R.failure();
//        }

        DevAccessDo devAccessDo=new DevAccessDo();
        devAccessDo.setId(accessMeasureId);
        devAccessDo.setOrgNo(gmDevTerm.getOrgNo());
        devAccessDo.setDevAccessSortNo("HEPSTD-PV-METER");
        devAccessDo.setDevAccessNo(mac+"-"+key);
        devAccessDo.setDevAccessName(key);
        devAccessDo.setDevAccessDesc(key);
        devAccessDo.setDevAccessDetail("{}");
        devAccessDo.setGateway(false);
        devAccessDo.setTrunking(false);
        devAccessDo.setMeasure(true);
        devAccessDo.setLifeState("03");
        devAccessDo.setMfrCode("HEPSTD");
        devAccessDo.setModelCode("HEPSTD-PV-INVERTER");
        devAccessDo.setSortSn(1);
        devAccessDo.setValid(true);
        devAccessDo.setGmtCreate(now);
        devAccessDo.setGmtModified(now);
        devAccessDo.setGmtInvalid(0);
        devAccessDo.setVersion(1);
        devAccessDao.insert(devAccessDo);

        DevAccessMeasureDo devAccessMeasureDo=new DevAccessMeasureDo();
        devAccessMeasureDo.setId(accessMeasureId);
        devAccessMeasureDo.setMeasCommMode("RS485");
        devAccessMeasureDo.setMeasCommAddr(key);
        devAccessMeasureDo.setMeasCommProto(devMeterCommProto);
        devAccessMeasureDo.setEnableElec(true);
        devAccessMeasureDo.setVersion(1);
        devAccessMeasureDao.insert(devAccessMeasureDo);

        RunMeasPointDo runMeasPointDo=new RunMeasPointDo();
        runMeasPointDo.setId(runMeasPointId);
        runMeasPointDo.setOrgNo(gmDevTerm.getOrgNo());
        runMeasPointDo.setAccessMeasureId(accessMeasureId);
        runMeasPointDo.setAccessTrunkingId((long)0);
        runMeasPointDo.setAccessGatewayId(gmDevTerm.getAccessGatewayId());
        runMeasPointDo.setMeasKind(0);
//        runMeasPointDo.setMeasSn(Integer.parseInt(key));
        runMeasPointDo.setMeasCommMode("RS485");
        runMeasPointDo.setMeasCommAddr(key);
        runMeasPointDo.setMeasCommProto(devMeterCommProto);
        runMeasPointDo.setMeasCommPort(0);
        runMeasPointDo.setGmtMessageUp(now);
        runMeasPointDo.setGmtMeasdataUp(now);
        runMeasPointDo.setGmtAlarmUp(0);
        runMeasPointDo.setGmtCreate(now);
        runMeasPointDo.setGmtModified(now);
        runMeasPointDo.setVersion(1);
        runMeasPointDao.insert(runMeasPointDo);
//        transactionManager.commit(transaction);
//        //插入日志表
        if (StringUtils.isEmpty(topic)){
            RunMeasPointChangeLogDo runMeasPointChangeLogDo=new RunMeasPointChangeLogDo();
            BeanUtils.copyProperties(runMeasPointDo,runMeasPointChangeLogDo);
            runMeasPointChangeLogDo.setSn(mac);
            runMeasPointDao.insertRunMeasPointLog(runMeasPointChangeLogDo);
        }


        logger.info("终端地址： " + mac + " 三张表刷新成功");
        brushMeterResponse.setAccessMeasureId(accessMeasureId);
        brushMeterResponse.setRunMeasPointId(runMeasPointId);
        return R.ok(brushMeterResponse);
    }

    @Override
    public RunMeasPointListResponse getRunMeasPointListBySn(String sn) {
        List<RunMeasPointVo> runMeasPointDoList=runMeasPointDao.getRunMeasPointListBySn(sn,"1");
        RunMeasPointListResponse runMeasPointListResponse=new RunMeasPointListResponse();
        runMeasPointListResponse.setRunMeasPointList(runMeasPointDoList);
        return runMeasPointListResponse;
    }

    @Override
    public void editMeter(EditMeterRequest editMeterRequest) {

//        RunMeasPointDo runMeasPointDo =new RunMeasPointDo();
//        runMeasPointDo.setId(editMeterRequest.getRunMeasPointId());
//        BeanUtils.copyProperties(editMeterRequest,runMeasPointDo);
        runMeasPointDao.editMeter(editMeterRequest);
//        runMeasPointDao.update(runMeasPointDo);

    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void delTermMeter(Long runMeasPointId) {
        if (runMeasPointId==0){
            return;
        }
        RunMeasPointDo runMeasPointDo = runMeasPointDao.get(runMeasPointId);

        if (runMeasPointDo==null){
            return;
        }

        DevAccessDo devAccessDo=new DevAccessDo();
        devAccessDo.setId(runMeasPointDo.getAccessMeasureId());
        devAccessDao.delete(devAccessDo);
        devAccessDao.deleteById(runMeasPointDo.getAccessMeasureId());

        DevAccessMeasureDo devAccessMeasureDo=new DevAccessMeasureDo();
        devAccessMeasureDo.setId(runMeasPointDo.getAccessMeasureId());
        devAccessMeasureDao.delete(devAccessMeasureDo);

        runMeasPointDao.delete(runMeasPointDo);

    }


}
