package com.gaea.iesms.bm.mqttHandler.model.jsondto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 *
 * @see GatewayEnergyMqttJsonDto
 *
 * @author Nick Zhang
 * @date 2019-06-06
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect
public class GatewayEnergyLineMqttJsonDto implements Serializable {

    private static final long serialVersionUID = 4502421517230569442L;

    /**
     * 线路编号
     */
    @JsonProperty("LINENO")
    private Integer lineNo;

    /**
     * 线路电能示值
     */
    @JsonProperty("ENERGY")
    private BigDecimal energy;

}
