package com.gaea.iesms.bm.mqttHandler.model.jsondto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 告警
 *
 * 订阅主题：
 * /ProductKey/ClientName/message
 * 数据格式：
 * {
 *     "Code": "HL",
 *     "TimeStamp": 1491356290,
 *     "LineNo": 1,
 *     "Content": "超过额定电流",
 *     "Data": 66
 * }
 *
 * 属性说明：
 * 序号	属性	说明
 * 1	Code	故障代码。过压、欠压、过流、过温、漏电的代码分别是HV、LV、HC、HT、LEAK
 * Err_HV、Err_LV、Err_HC、Err_HT、Err_LEAK
 * 2	TimeStamp	故障发生时的时间戳
 * 3	LineNo	发生故障的线路编号
 * 4	Message	故障说明
 * 5	Data	故障发生时的数值
 *
 * 报警：达到预警值，但是未断开保护，会上报报警代码。
 * 故障：达到保护值，设备会断开保护，同时上报故障代码。
 *
 * 类型	报警代码	故障代码
 * 过压	HV（可设，默认265V）	Err_HV（默认275V）
 * 欠压	LV(可设，默认175V)	Err_LV（默认160V）
 * 过流	HC（可设，默认最大额定）	Err_HC（默认额定电流的1.1倍）
 * 过温	HT（默认75℃）	Err_HT（默认80℃持续1min）
 * 漏电	LEAK（根据产品而定）	Err_LEAK（根据产品而定）
 *
 *
 * @author Nick Zhang
 * @date 2019-06-06
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect
public class GatewayMessageMqttJsonDto implements Serializable {

    private static final long serialVersionUID = -4239711612708036124L;

    /**
     * 时间戳
     */
    @JsonProperty("TIMESTAMP")
    private Long timeStamp;

    /**
     * 线路编号
     */
    @JsonProperty("LINENO")
    private Integer lineNo;

    /**
     * 故障代码
     */
    @JsonProperty("CODE")
    private String code;

    /**
     * 故障说明
     */
    @JsonProperty("MESSAGE")
    private String message;

    /**
     * 故障发生时的数值
     */
    @JsonProperty("DATA")
    private BigDecimal data;

}
